/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Ribbon;
import com.bbn.openmap.geo.Rotation;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RibbonIterator
implements Iterator<Ribbon>,
Iterable<Ribbon> {
    protected Geo v1;
    protected Geo v2;
    protected double radius;
    protected Geo gc;
    protected Rotation rotator;
    protected Geo point;
    protected double distance;

    public RibbonIterator(Geo v1, Geo v2, double radius) {
        this(v1, v2, radius, 2.0 * radius);
    }

    public RibbonIterator(Geo v1, Geo v2, double radius, double rotationIntervalDist) {
        this.v1 = v1;
        this.v2 = v2;
        if (v1 == null || v2 == null || v1.equals(v2)) {
            this.point = v2;
        } else {
            this.distance = v1.distance(v2);
            this.radius = radius;
            this.gc = v1.crossNormalize(v2);
            this.rotator = new Rotation(this.gc, rotationIntervalDist);
            this.point = v1;
        }
    }

    @Override
    public Ribbon next() {
        if (!this.hasNext()) {
            return Ribbon.getEmpty();
        }
        if (this.point != this.v2 && this.v1.distance(this.point) < this.distance) {
            Ribbon result = new Ribbon(this.point, this.gc, this.radius);
            this.point = this.rotator.rotate(this.point);
            return result;
        }
        this.point = this.v2;
        return new Ribbon(this.point, this.gc, this.radius);
    }

    @Override
    public boolean hasNext() {
        return this.point != this.v2;
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<Ribbon> iterator() {
        return this;
    }
}

