/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.ServerMapTileFactory;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class GoogleMapTileFactory
extends ServerMapTileFactory {
    public static final String API_KEY_PROPERTY = "key";
    public static final String MAPTYPE_PROPERTY = "mapType";
    String apiKey = null;
    String mapType = null;
    int imageEdgeBuffer = 30;

    public GoogleMapTileFactory() {
        this.rootDir = "http://maps.googleapis.com/maps/api/staticmap?";
    }

    public String buildFilePath(int x, int y, int z, String fileExt) {
        StringBuilder ret = new StringBuilder(this.rootDir);
        int dim = 256 + this.imageEdgeBuffer * 2;
        LatLonPoint uLcoord = this.mtcTransform.tileUVToLatLon(new Point2D.Double(x, y), z, new LatLonPoint.Double());
        Mercator m = new Mercator(uLcoord, this.mtcTransform.getScaleForZoom(z), 256, 256);
        LatLonPoint nCenter = m.inverse(256.0, 256 + this.imageEdgeBuffer);
        ret.append("zoom=").append(z);
        ret.append("&center=").append(nCenter.getLatitude()).append(",").append(nCenter.getLongitude());
        ret.append("&size=").append(256).append("x").append(dim);
        if (this.mapType != null) {
            ret.append("&maptype=").append(this.mapType);
        }
        ret.append("&sensor=false");
        if (this.apiKey != null) {
            ret.append("&key=").append(this.apiKey);
        }
        return ret.toString();
    }

    protected BufferedImage preprocessImage(Image origImage, int imageWidth, int imageHeight) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage(origImage, 0, 0, 256, 256, 2);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.apiKey = props.getProperty(prefix + API_KEY_PROPERTY, this.apiKey);
        this.mapType = props.getProperty(prefix + MAPTYPE_PROPERTY, this.mapType);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + API_KEY_PROPERTY, PropUtils.unnull(this.apiKey));
        props.put(prefix + MAPTYPE_PROPERTY, PropUtils.unnull(this.mapType));
        return props;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getMapType() {
        return this.mapType;
    }

    public void setMapType(String mapType) {
        this.mapType = mapType;
    }
}

