/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.quadtree;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.util.quadtree.MutableDistance;
import com.bbn.openmap.util.quadtree.QuadTreeLeaf;
import com.bbn.openmap.util.quadtree.QuadTreeRect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTreeNode<T>
implements Serializable {
    static final long serialVersionUID = -6111633198469889444L;
    public static final float NO_MIN_SIZE = -1.0f;
    public static final float DEFAULT_MIN_SIZE = 5.0f;
    protected Collection<QuadTreeLeaf<T>> items;
    protected Collection<QuadTreeNode<T>> children;
    protected int maxItems;
    protected double minSize;
    public QuadTreeRect bounds;
    protected boolean allTheSamePoint;
    protected double firstLat;
    protected double firstLon;

    public QuadTreeNode(double north, double west, double south, double east, int maximumItems) {
        this(north, west, south, east, maximumItems, -1.0);
    }

    public QuadTreeNode(double north, double west, double south, double east, int maximumItems, double minimumSize) {
        this.bounds = new QuadTreeRect(north, west, south, east);
        this.maxItems = maximumItems;
        this.minSize = minimumSize;
        this.items = new ArrayList<QuadTreeLeaf<T>>();
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    protected void split() {
        if (this.minSize != -1.0 && MoreMath.approximately_equal(this.bounds.north, this.bounds.south, this.minSize) && MoreMath.approximately_equal(this.bounds.east, this.bounds.west, this.minSize)) {
            return;
        }
        double nsHalf = this.bounds.north - (this.bounds.north - this.bounds.south) / 2.0;
        double ewHalf = this.bounds.east - (this.bounds.east - this.bounds.west) / 2.0;
        this.children = new ArrayList<QuadTreeNode<T>>(4);
        this.children.add(new QuadTreeNode<T>(this.bounds.north, this.bounds.west, nsHalf, ewHalf, this.maxItems));
        this.children.add(new QuadTreeNode<T>(this.bounds.north, ewHalf, nsHalf, this.bounds.east, this.maxItems));
        this.children.add(new QuadTreeNode<T>(nsHalf, ewHalf, this.bounds.south, this.bounds.east, this.maxItems));
        this.children.add(new QuadTreeNode<T>(nsHalf, this.bounds.west, this.bounds.south, ewHalf, this.maxItems));
        ArrayList<QuadTreeLeaf<T>> temp = new ArrayList<QuadTreeLeaf<T>>(this.items);
        this.items.clear();
        for (QuadTreeLeaf quadTreeLeaf : temp) {
            this.put(quadTreeLeaf);
        }
    }

    protected QuadTreeNode<T> getChild(double lat, double lon) {
        if (this.bounds.pointWithinBounds(lat, lon)) {
            if (this.children != null) {
                for (QuadTreeNode<T> child : this.children) {
                    if (!child.bounds.pointWithinBounds(lat, lon)) continue;
                    return child.getChild(lat, lon);
                }
            } else {
                return this;
            }
        }
        return null;
    }

    public boolean put(double lat, double lon, T obj) {
        return this.put(new QuadTreeLeaf<T>(lat, lon, obj));
    }

    public boolean put(QuadTreeLeaf<T> leaf) {
        if (this.children == null) {
            this.items.add(leaf);
            if (this.items.size() == 1) {
                this.allTheSamePoint = true;
                this.firstLat = leaf.latitude;
                this.firstLon = leaf.longitude;
            } else if (this.firstLat != leaf.latitude || this.firstLon != leaf.longitude) {
                this.allTheSamePoint = false;
            }
            if (this.items.size() > this.maxItems && !this.allTheSamePoint) {
                this.split();
            }
            return true;
        }
        QuadTreeNode<T> node = this.getChild(leaf.latitude, leaf.longitude);
        if (node != null) {
            return node.put(leaf);
        }
        return false;
    }

    public T remove(double lat, double lon, T obj) {
        return this.remove(new QuadTreeLeaf<T>(lat, lon, obj));
    }

    public T remove(QuadTreeLeaf<T> leaf) {
        if (this.children == null) {
            for (QuadTreeLeaf<T> qtl : new ArrayList<QuadTreeLeaf<T>>(this.items)) {
                if (leaf.object != qtl.object) continue;
                this.items.remove(qtl);
                return qtl.object;
            }
        } else {
            QuadTreeNode<T> node = this.getChild(leaf.latitude, leaf.longitude);
            if (node != null) {
                return node.remove(leaf);
            }
        }
        return null;
    }

    public void clear() {
        this.items.clear();
        if (this.children != null) {
            for (QuadTreeNode<T> child : this.children) {
                child.clear();
            }
            this.children = null;
        }
    }

    public T get(double lat, double lon) {
        return this.get(lat, lon, Double.POSITIVE_INFINITY);
    }

    public T get(double lat, double lon, double withinDistance) {
        return this.get(lat, lon, new MutableDistance(withinDistance));
    }

    public T get(double lat, double lon, MutableDistance bestDistance) {
        T closest = null;
        if (this.children == null) {
            for (QuadTreeLeaf<T> qtl : this.items) {
                double dx = lon - qtl.longitude;
                double dy = lat - qtl.latitude;
                double distanceSqr = dx * dx + dy * dy;
                if (!(distanceSqr < bestDistance.value)) continue;
                bestDistance.value = distanceSqr;
                closest = qtl.object;
            }
            return closest;
        }
        for (QuadTreeNode<T> child : this.children) {
            T test;
            double childDistance = child.bounds.borderDistanceSqr(lat, lon);
            if (!(childDistance < bestDistance.value) || (test = child.get(lat, lon, bestDistance)) == null) continue;
            closest = test;
        }
        return closest;
    }

    public Collection<T> get(double north, double west, double south, double east) {
        return this.get(new QuadTreeRect(north, west, south, east), new ArrayList());
    }

    public Collection<T> get(double north, double west, double south, double east, Collection<T> collection) {
        return this.get(new QuadTreeRect(north, west, south, east), collection);
    }

    public Collection<T> get(QuadTreeRect rect, Collection<T> collection) {
        if (this.children == null) {
            for (QuadTreeLeaf<T> qtl : this.items) {
                if (!rect.pointWithinBounds(qtl.latitude, qtl.longitude)) continue;
                collection.add(qtl.object);
            }
        } else {
            for (QuadTreeNode<T> child : this.children) {
                if (!child.bounds.within(rect)) continue;
                child.get(rect, collection);
            }
        }
        return collection;
    }
}

