/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskService {
    private ExecutorService executor = Executors.newCachedThreadPool();

    public static TaskService singleton() {
        return SingletonHolder.instance;
    }

    private TaskService() {
    }

    public void spawn(Runnable task) {
        this.executor.execute(task);
    }

    public <T> Future<T> spawn(Callable<T> task) {
        return this.executor.submit(task);
    }

    public void setExecutorService(ExecutorService eService) {
        if (eService != null) {
            this.executor = eService;
        }
    }

    public void setMaxNumThreads(int maxNumThreads) {
        this.executor = new ThreadPoolExecutor(0, maxNumThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    private static class SingletonHolder {
        private static final TaskService instance = new TaskService();

        private SingletonHolder() {
        }
    }
}

