/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.dnd;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.dnd.ComponentDragGestureListener;
import com.bbn.openmap.tools.dnd.DefaultTransferableObject;
import com.bbn.openmap.tools.dnd.DnDListener;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class DefaultDnDCatcher
extends DnDListener
implements BeanContextChild,
BeanContextMembershipListener,
PropertyChangeListener,
Serializable,
ProjectionListener,
LayerListener,
ActionListener {
    protected PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);
    protected BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport();
    protected Hashtable layers = new Hashtable();
    protected transient MouseDelegator md;
    protected transient Projection proj;
    protected Object transferData;
    protected Point dropLocation;

    public DefaultDnDCatcher() {
        this(new DragSource());
    }

    public DefaultDnDCatcher(DragSource ds) {
        this(ds, null);
    }

    public DefaultDnDCatcher(DragSource ds, Component c) {
        this(ds, c, 0);
    }

    public DefaultDnDCatcher(DragSource ds, Component c, int act) {
        this(ds, c, act, null);
    }

    public DefaultDnDCatcher(DragSource ds, Component c, int act, DragGestureListener dgl) {
        super(ds, c, act, dgl);
        this.dragSource = this.getDragSource();
        this.dragGestureListener = new ComponentDragGestureListener(this, this);
        this.setSourceActions(2);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (!(source instanceof JMenuItem)) {
            return;
        }
        JMenuItem mi = (JMenuItem)source;
        String name = mi.getText();
        OMGraphicHandlerLayer targetLayer = (OMGraphicHandlerLayer)this.layers.get(name);
        if (targetLayer == null) {
            Debug.message("defaultdndcatcher", "ERROR> DefaultDnDCatcher::actionPerformed: no layer found with name " + name);
            return;
        }
        targetLayer.doAction((OMGraphic)this.transferData, new OMAction(128));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.pcSupport.addPropertyChangeListener(propertyName, in_pcl);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public boolean consume(MouseEvent e) {
        if (e.getID() == 501) {
            this.mousePressed(e);
        } else if (e.getID() == 502) {
            this.mouseReleased(e);
        } else if (e.getID() == 506) {
            this.mouseDragged(e);
        }
        return false;
    }

    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(2);
        this.transferData = this.extractTransferData(dtde);
        this.dropLocation = this.extractDropLocation(dtde);
        dtde.dropComplete(true);
        if (this.transferData == null || this.dropLocation == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Available Drop Targets:");
        titledBorder.setTitleColor(Color.gray);
        popup.setBorder(titledBorder);
        CompoundBorder compoundborder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        if (this.transferData instanceof Location) {
            ((Location)this.transferData).setLocation(this.dropLocation.x, this.dropLocation.y, this.proj);
            OMGraphicHandlerLayer omlayer = null;
            Enumeration keys = this.layers.keys();
            while (keys.hasMoreElements()) {
                String layer_name = keys.nextElement().toString();
                omlayer = (OMGraphicHandlerLayer)this.layers.get(layer_name);
                if (!omlayer.isVisible()) continue;
                JMenuItem menuItem = new JMenuItem(layer_name);
                menuItem.setHorizontalTextPosition(0);
                menuItem.setBorder(compoundborder);
                menuItem.addActionListener(this);
                popup.add(menuItem);
            }
            popup.addSeparator();
        }
        JMenuItem menuItem = new JMenuItem("CANCEL");
        menuItem.setForeground(Color.red);
        menuItem.setHorizontalTextPosition(0);
        menuItem.setBorder(compoundborder);
        popup.add(menuItem);
        popup.setPreferredSize(new Dimension(150, (popup.getComponentCount() + 1) * 25));
        popup.show(((DropTarget)dtde.getSource()).getComponent(), this.dropLocation.x, this.dropLocation.y);
    }

    private Point extractDropLocation(DropTargetDropEvent dtde) {
        if (dtde == null) {
            Debug.message("defaultdndcatcher", "ERROR> BDnDC::getTransferData(): dropEvent is null");
            return null;
        }
        return dtde.getLocation();
    }

    private Object extractTransferData(DropTargetDropEvent dtde) {
        if (dtde == null) {
            Debug.message("defaultdndcatcher", "ERROR> DefaultDnDCatcher::getTransferData(): dropEvent is null");
            return null;
        }
        Transferable tr = dtde.getTransferable();
        try {
            return tr.getTransferData(DefaultTransferableObject.OBJECT_FLAVOR);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MouseDelegator) {
            this.md = (MouseDelegator)someObj;
        }
        if (someObj instanceof MapBean) {
            ((MapBean)someObj).addProjectionListener(this);
            this.setProjection(((MapBean)someObj).getProjection().makeClone());
        }
        if (someObj instanceof LayerHandler) {
            LayerHandler lh = (LayerHandler)someObj;
            lh.addLayerListener(this);
            this.setLayers(lh.getLayers());
        }
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj == this.md) {
            this.md = null;
        }
        if (someObj instanceof MapBean) {
            ((MapBean)someObj).removeProjectionListener(this);
            this.setProjection((Projection)null);
        }
        if (someObj instanceof LayerHandler) {
            LayerHandler lh = (LayerHandler)someObj;
            lh.removeLayerListener(this);
            this.setLayers((Layer[])null);
        }
    }

    public void firePropertyChange(String property, Object oldObj, Object newObj) {
        this.pcSupport.firePropertyChange(property, oldObj, newObj);
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        this.beanContextChildSupport.fireVetoableChange(name, oldValue, newValue);
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public Projection getProjection() {
        return this.proj;
    }

    public void mouseDragged(MouseEvent e) {
        Debug.message("defaultdndcatcher", "mouseDragged, startDrag=" + this.startDrag);
        if (this.startDrag) {
            this.startDrag = false;
            if (this.md.getActiveMouseMode() instanceof SelectMouseMode) {
                this.appendEvent(e);
                this.setComponent((Component)e.getSource());
                this.fireDragGestureRecognized(2, ((MouseEvent)this.getTriggerEvent()).getPoint());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.startDrag = true;
    }

    public void projectionChanged(ProjectionEvent e) {
        this.setProjection(e);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void setLayers(Layer[] allLayers) {
        this.layers.clear();
        if (allLayers != null) {
            for (int i = 0; i < allLayers.length; ++i) {
                new DropTarget(allLayers[i], 2, this);
                if (!(allLayers[i] instanceof OMGraphicHandlerLayer)) continue;
                Debug.message("DnDCatcher", "Layers changed");
                this.layers.put(allLayers[i].getName(), allLayers[i]);
            }
        }
    }

    public void setLayers(LayerEvent evt) {
        if (evt.getType() == 403) {
            this.setLayers(evt.getLayers());
        }
    }

    public Projection setProjection(ProjectionEvent projEvent) {
        Projection newProjection = projEvent.getProjection();
        if (!newProjection.equals(this.getProjection())) {
            Projection clone = newProjection.makeClone();
            this.setProjection(clone);
            return clone;
        }
        return null;
    }

    public void setProjection(Projection projection) {
        this.proj = projection;
    }

    public void startDragAction(DragGestureEvent dge, DragSourceListener dsl) {
        this.dragSource.startDrag(dge, this.getCursor(DragSource.DefaultMoveDrop), new DefaultTransferableObject(SinkGraphic.getSharedInstance()), dsl);
    }
}

