/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.grid.ColorGeneratorLoader;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.omGraphics.grid.SlopeGenerator;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlopeGeneratorLoader
extends ColorGeneratorLoader {
    public static final String CONTRAST_PROPERTY = "CONTRAST";
    protected int contrast = 5;

    public SlopeGeneratorLoader() {
        this.setPrettyName(this.i18n.get(SlopeGeneratorLoader.class, "name", "Greyscale Slope"));
    }

    public void setContrast(int cont) {
        int oldValue = this.contrast;
        this.contrast = cont;
        if (oldValue != this.contrast) {
            this.firePropertyChange(CONTRAST_PROPERTY, new Integer(oldValue), new Integer(this.contrast));
        }
    }

    public int getContrast() {
        return this.contrast;
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        JPanel contrastPanel = PaletteHelper.createPaletteJPanel("Contrast Adjustment");
        JSlider contrastSlide = new JSlider(0, 1, 10, this.getContrast());
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        dict.put(new Integer(1), new JLabel("min"));
        dict.put(new Integer(10), new JLabel("max"));
        contrastSlide.setLabelTable(dict);
        contrastSlide.setPaintLabels(true);
        contrastSlide.setMajorTickSpacing(1);
        contrastSlide.setPaintTicks(true);
        contrastSlide.setSnapToTicks(true);
        contrastSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JSlider slider = (JSlider)ce.getSource();
                if (!slider.getValueIsAdjusting()) {
                    SlopeGeneratorLoader.this.setContrast(slider.getValue());
                }
            }
        });
        contrastPanel.add(contrastSlide);
        panel.add(contrastPanel);
        return panel;
    }

    public OMGridGenerator getGenerator() {
        SlopeGenerator gen = new SlopeGenerator();
        gen.setColors(this.getColors());
        gen.setContrast(this.contrast);
        return gen;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        super.addPropertyChangeListener(CONTRAST_PROPERTY, pcl);
        super.addPropertyChangeListener("COLORS", pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        super.removePropertyChangeListener(CONTRAST_PROPERTY, pcl);
        super.removePropertyChangeListener("COLORS", pcl);
    }
}

