/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BasicStrokeEditor
extends JDialog
implements ActionListener {
    protected BasicStroke basicStroke = null;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected float width;
    protected int endCaps;
    protected int lineJoins;
    protected float miterLimit;
    protected float[] dash;
    protected float dashPhase;
    protected transient JTextField widthField;
    protected transient JTextField miterLimitField;
    protected transient JTextField dashField;
    protected transient JTextField dashPhaseField;
    protected transient JPanel palette = null;
    protected transient JButton closebutton;
    protected transient JButton applybutton;
    protected transient JComboBox capBox;
    protected transient JComboBox joinBox;
    public static final String NONE = "No Dash Pattern";
    public static final String LaunchCmd = "LAUNCH";
    JButton launchButton;

    public BasicStrokeEditor() {
        this.basicStroke = new BasicStroke(1.0f);
    }

    public BasicStrokeEditor(BasicStroke bs) {
        this.basicStroke = bs != null ? bs : new BasicStroke(1.0f);
        this.setStrokeWidth(this.basicStroke.getLineWidth());
        this.setMiterLimit(this.basicStroke.getMiterLimit());
        this.setDash(this.basicStroke.getDashArray());
        this.setDashPhase(this.basicStroke.getDashPhase());
        this.setEndCaps(this.basicStroke.getEndCap());
        this.setLineJoins(this.basicStroke.getLineJoin());
    }

    public void resetStroke() {
        BasicStroke oldStroke = this.basicStroke;
        this.setMiterLimit(this.miterLimit);
        this.basicStroke = new BasicStroke(this.width, this.endCaps, this.lineJoins, this.miterLimit, this.dash, this.dashPhase);
        this.pcs.firePropertyChange("line", oldStroke, this.basicStroke);
    }

    protected void widgetsToSettings() {
        try {
            float w = new Float(this.widthField.getText()).floatValue();
            if (w < 0.0f) {
                w = 0.0f;
            }
            this.width = w;
        }
        catch (NumberFormatException nfe) {
            this.width = 1.0f;
        }
        try {
            this.setMiterLimit(new Float(this.miterLimitField.getText()).floatValue());
        }
        catch (NumberFormatException nfe) {
            this.setMiterLimit(10.0f);
        }
        this.dash = BasicStrokeEditor.stringToDashArray(this.dashField.getText());
        try {
            float dp = new Float(this.dashPhaseField.getText()).floatValue();
            if (dp < 0.0f) {
                dp = 0.0f;
            }
            this.dashPhase = dp;
        }
        catch (NumberFormatException nfe) {
            this.dashPhase = 0.0f;
        }
        this.endCaps = this.capBox.getSelectedIndex();
        this.lineJoins = this.joinBox.getSelectedIndex();
    }

    public void setGUI() {
        if (this.palette == null) {
            this.setTitle("Modify Line Stroke Parameters");
            this.palette = new JPanel();
            this.palette.setLayout(new BoxLayout(this.palette, 1));
            JPanel capPanel = PaletteHelper.createPaletteJPanel("Line Cap Decoration");
            String[] capStrings = new String[]{"Butt", "Round", "Square"};
            this.capBox = new JComboBox<String>(capStrings);
            this.capBox.addActionListener(this);
            capPanel.add(this.capBox);
            this.palette.add(capPanel);
            JPanel joinPanel = PaletteHelper.createPaletteJPanel("Line Joint Decoration");
            String[] joinStrings = new String[]{"Miter", "Round", "Bevel"};
            this.joinBox = new JComboBox<String>(joinStrings);
            this.joinBox.addActionListener(this);
            joinPanel.add(this.joinBox);
            this.palette.add(joinPanel);
            JPanel widthPanel = new JPanel();
            widthPanel.setLayout(new GridLayout(0, 1));
            JLabel widthLabel = new JLabel("Line Width");
            this.widthField = new JTextField(Float.toString(this.basicStroke.getLineWidth()), 4);
            this.widthField.setToolTipText("Enter pixel width of line.");
            widthPanel.add(widthLabel);
            widthPanel.add(this.widthField);
            JPanel mlPanel = new JPanel();
            mlPanel.setLayout(new GridLayout(0, 1));
            JLabel miterLimitLabel = new JLabel("Miter Limit");
            this.miterLimitField = new JTextField(Float.toString(this.basicStroke.getMiterLimit()), 4);
            this.miterLimitField.setToolTipText("Min angle for corner decorations.");
            mlPanel.add(miterLimitLabel);
            mlPanel.add(this.miterLimitField);
            JPanel dlPanel = new JPanel();
            dlPanel.setLayout(new FlowLayout());
            JLabel dashLabel = new JLabel("Dash Pattern");
            this.dashField = new JTextField(BasicStrokeEditor.dashArrayToString(this.basicStroke.getDashArray()), 15);
            this.dashField.setToolTipText("Number of pixels on off on ...");
            dlPanel.add(dashLabel);
            dlPanel.add(this.dashField);
            JPanel dpPanel = new JPanel();
            dpPanel.setLayout(new GridLayout(0, 1));
            JLabel dashPhaseLabel = new JLabel("Dash Phase");
            this.dashPhaseField = new JTextField(Float.toString(this.basicStroke.getDashPhase()), 4);
            this.dashPhaseField.setToolTipText("Phase to start dash array.");
            dpPanel.add(dashPhaseLabel);
            dpPanel.add(this.dashPhaseField);
            JPanel textFieldPanel = new JPanel();
            textFieldPanel.setLayout(new GridLayout(0, 3));
            textFieldPanel.add(widthPanel);
            textFieldPanel.add(dpPanel);
            textFieldPanel.add(mlPanel);
            this.palette.add(textFieldPanel);
            this.palette.add(dlPanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(0, 2));
            this.closebutton = new JButton("Cancel");
            this.closebutton.addActionListener(this);
            this.applybutton = new JButton("OK");
            this.applybutton.addActionListener(this);
            buttonPanel.add(this.applybutton);
            buttonPanel.add(this.closebutton);
            this.palette.add(buttonPanel);
            this.getContentPane().add(this.palette);
            this.pack();
        } else {
            this.widthField.setText(Float.toString(this.basicStroke.getLineWidth()));
            this.miterLimitField.setText(Float.toString(this.basicStroke.getMiterLimit()));
            this.dashField.setText(BasicStrokeEditor.dashArrayToString(this.basicStroke.getDashArray()));
            this.dashPhaseField.setText(Float.toString(this.basicStroke.getDashPhase()));
        }
        this.capBox.setSelectedIndex(this.basicStroke.getEndCap());
        this.joinBox.setSelectedIndex(this.basicStroke.getLineJoin());
    }

    public static String dashArrayToString(float[] da) {
        if (da == null) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < da.length; ++i) {
            sb.append(Float.toString(da[i])).append(" ");
        }
        return sb.toString();
    }

    public static float[] stringToDashArray(String das) {
        if (das == null || das.equals(NONE) || das.length() == 0) {
            return null;
        }
        Vector<String> floats = PropUtils.parseSpacedMarkers(das);
        float[] ret = new float[floats.size()];
        int index = 0;
        Enumeration<String> thing = floats.elements();
        while (thing.hasMoreElements()) {
            String f = thing.nextElement();
            try {
                ret[index++] = new Float(f).floatValue();
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return ret;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applybutton) {
            this.widgetsToSettings();
            this.resetStroke();
            this.setVisible(false);
        } else if (event.getSource() == this.closebutton) {
            this.setVisible(false);
        } else if (event.getActionCommand() == LaunchCmd) {
            this.setGUI();
            this.setVisible(true);
        } else {
            this.widgetsToSettings();
            this.resetStroke();
        }
    }

    public BasicStroke getBasicStroke() {
        return this.basicStroke;
    }

    public void setBasicStroke(BasicStroke bs) {
        this.basicStroke = bs;
        if (this.launchButton != null) {
            float buttonHeight = 20.0f;
            this.launchButton.setIcon(BasicStrokeEditor.createIcon(this.getBasicStroke(), 40, (int)buttonHeight, true));
        }
    }

    public void setLaunchButton(JButton lb) {
        this.launchButton = lb;
    }

    public JButton getLaunchButton() {
        if (this.launchButton == null) {
            float buttonHeight = 20.0f;
            ImageIcon icon = BasicStrokeEditor.createIcon(this.getBasicStroke(), 40, (int)buttonHeight, true);
            this.launchButton = new JButton(icon);
            this.launchButton.setToolTipText("Modify Line Stroke");
            this.launchButton.addActionListener(this);
            this.launchButton.setActionCommand(LaunchCmd);
        }
        return this.launchButton;
    }

    public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
        this.pcs = propertyChangeSupport;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    public static ImageIcon createIcon(BasicStroke stroke, int width, int height, boolean horizontalOrientation) {
        BufferedImage bigImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bigImage.getGraphics();
        g.setBackground(OMColor.clear);
        g.setPaint(OMColor.clear);
        g.fillRect(0, 0, width, height);
        g.setPaint(Color.black);
        g.setStroke(stroke);
        if (horizontalOrientation) {
            g.drawLine(0, height / 2, width, height / 2);
        } else {
            g.drawLine(width / 2, 0, width / 2, height);
        }
        return new ImageIcon(bigImage);
    }

    public void setStrokeWidth(float w) {
        if (w < 1.0f) {
            w = 1.0f;
        }
        this.width = w;
    }

    public float getStrokeWidth() {
        return this.width;
    }

    public void setMiterLimit(float ml) {
        this.miterLimit = ml < 1.0f ? 10.0f : ml;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setDash(float[] da) {
        this.dash = da;
    }

    public float[] getDash() {
        return this.dash;
    }

    public void setDashPhase(float dp) {
        this.dashPhase = dp;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public void setEndCaps(int ec) {
        this.endCaps = ec;
    }

    public int getEndCaps() {
        return this.endCaps;
    }

    public void setLineJoins(int lj) {
        this.lineJoins = lj;
    }

    public int getLineJoins() {
        return this.lineJoins;
    }
}

