/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.dataAccess.mapTile.MapTileMaker;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelMaker;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelMakerFace;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.PaintListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.EditableOMRect;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.tools.drawing.OMDrawingToolMouseMode;
import com.bbn.openmap.tools.drawing.OMRectLoader;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.TaskService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTileMakerComponent
extends OMComponentPanel
implements MapPanelChild,
LayerListener,
DrawingToolRequestor,
PaintListener,
ProjectionListener {
    protected Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.mapTile.MapTileMakerComponent");
    public static final String TILE_MAKER_PROPERTIES_FILE = "file";
    private static final long serialVersionUID = 1L;
    protected String preferredLocation = "West";
    protected String parentName = null;
    protected String fileName = null;
    protected String rootDir = null;
    protected boolean transparentTiles = false;
    protected LayerHandler layerHandler;
    protected List<ZoomLevelMakerFace> faces = new ArrayList<ZoomLevelMakerFace>();
    protected ZoomLevelMakerFace activeFace;
    protected OMDrawingTool drawingTool;
    protected DrawingAttributes rectDA = DrawingAttributes.getDefaultClone();
    protected Dialog cancelDialog;
    protected MapMouseMode proxyMMM = null;
    protected Projection proj;

    public MapTileMakerComponent() {
        this.init();
    }

    protected void init() {
        this.drawingTool = new OMDrawingTool();
        this.drawingTool.getMouseMode().setVisible(false);
        this.drawingTool.getMouseMode().setModeCursor(Cursor.getPredefinedCursor(1));
        this.drawingTool.addLoader(new OMRectLoader());
        GridBagLayout selfLayout = new GridBagLayout();
        this.setLayout(selfLayout);
        GridBagLayout outerLayout = new GridBagLayout();
        JPanel mainPanel = new JPanel(outerLayout);
        String map_tile_maker = this.i18n.get(MapTileMakerComponent.class, "map_tile_maker", "Map Tile Maker");
        mainPanel.setBorder(BorderFactory.createTitledBorder(map_tile_maker));
        GridBagConstraints outerC = new GridBagConstraints();
        outerC.insets = new Insets(0, 5, 5, 5);
        outerC.gridx = 0;
        outerC.fill = 1;
        outerC.weightx = 1.0;
        outerC.weighty = 1.0;
        String zoom_level = this.i18n.get(MapTileMakerComponent.class, "zoom_level", "Zoom Level");
        ZoomLevelMakerFace zlif = new ZoomLevelMakerFace(new ZoomLevelMaker(zoom_level + " " + 0, "", 0), this);
        this.faces.add(zlif);
        mainPanel.add((Component)zlif, outerC);
        JPanel masterOptions = new JPanel(new GridBagLayout());
        String use_transparent_background = this.i18n.get(MapTileMakerComponent.class, "use_transparent_background", "Use transparent background for tiles");
        JCheckBox transparentButton = new JCheckBox(use_transparent_background, this.transparentTiles);
        transparentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MapTileMakerComponent.this.transparentTiles = ((JCheckBox)ae.getSource()).isSelected();
            }
        });
        GridBagConstraints optC = new GridBagConstraints();
        optC.anchor = 17;
        optC.fill = 2;
        optC.weightx = 1.0;
        optC.gridx = -1;
        masterOptions.add((Component)transparentButton, optC);
        outerC.weighty = 0.0;
        mainPanel.add((Component)masterOptions, outerC);
        String make_tiles = this.i18n.get(MapTileMakerComponent.class, "make_tiles", "Make Tiles");
        JButton launchButton = new JButton(make_tiles);
        launchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MapTileMakerComponent.this.confirmLaunchTileMaker();
            }
        });
        outerC.fill = 0;
        outerC.weightx = 0.0;
        outerC.weighty = 0.0;
        mainPanel.add((Component)launchButton, outerC);
        outerC.fill = 1;
        outerC.weightx = 1.0;
        outerC.weighty = 1.0;
        this.add((Component)mainPanel, outerC);
        this.resetActive(this.faces.get(0));
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.rootDir = props.getProperty(prefix + "rootDir");
        this.fileName = props.getProperty(prefix + TILE_MAKER_PROPERTIES_FILE);
    }

    protected void confirmLaunchTileMaker() {
        Frame frame = JOptionPane.getFrameForComponent(this);
        String confirm_configuration = this.i18n.get(MapTileMakerComponent.class, "confirm_configuration", "Confirm Configuration");
        ConfirmationDialog dialog = new ConfirmationDialog(frame, null, confirm_configuration, this);
        dialog.setVisible(true);
    }

    protected void launchTileMaker(Properties props) {
        TreeSet<Object> sortedKeys = new TreeSet<Object>(props.keySet());
        if (this.fileName != null) {
            try {
                BufferedWriter bWriter = new BufferedWriter(new FileWriter(this.fileName));
                for (Object key : sortedKeys) {
                    bWriter.write(key + "=" + props.get(key) + "\n");
                }
                bWriter.flush();
                bWriter.close();
            }
            catch (IOException e) {
                this.logger.warning("caught exception writing out properties file");
                e.printStackTrace();
            }
        }
        final TileRunnable runner = new TileRunnable(props);
        Thread runnerThread = new Thread(runner);
        runnerThread.start();
        Frame frame = JOptionPane.getFrameForComponent(this);
        Object[] buttons = new JButton[1];
        JButton button1 = new JButton("Cancel");
        button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                runner.cancel();
            }
        });
        buttons[0] = button1;
        String creating_map_tiles = this.i18n.get(MapTileMakerComponent.class, "creating_map_tiles", "Creating Map Tiles...");
        JOptionPane pane = new JOptionPane(creating_map_tiles, 1, 2, null, buttons, button1);
        this.cancelDialog = pane.createDialog(frame, "MapTileMaker Running");
        this.cancelDialog.setModal(true);
        this.cancelDialog.setVisible(true);
    }

    protected void resetActive(ZoomLevelMakerFace activeZlif) {
        this.activeFace = activeZlif;
        for (ZoomLevelMakerFace zlif : this.faces) {
            zlif.setActive(zlif.equals(activeZlif));
        }
        this.shuffleLayers(activeZlif);
        this.activeFace.enableBoundaryButtons(!this.drawingTool.isActivated());
        MapHandler mHandler = (MapHandler)this.getBeanContext();
        if (mHandler != null) {
            mHandler.get(MapBean.class).repaint();
        }
    }

    protected void shuffleLayers(ZoomLevelMakerFace activeZlif) {
        if (this.layerHandler != null) {
            Layer[] layers;
            for (Layer layer : layers = this.layerHandler.getLayers()) {
                for (ZoomLevelMakerFace.LayerObject lo : activeZlif.layerList) {
                    if (!lo.getLayer().equals(layer)) continue;
                    layer.setVisible(lo.isSelected());
                }
            }
            this.layerHandler.setLayers();
        }
    }

    @Override
    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof LayerHandler) {
            this.layerHandler = (LayerHandler)someObj;
            this.layerHandler.addLayerListener(this);
        }
        if (this.drawingTool != null) {
            this.drawingTool.findAndInit(someObj);
        }
        if (someObj instanceof MapBean) {
            MapBean map = (MapBean)someObj;
            map.addProjectionListener(this);
            map.addPaintListener(this);
        }
    }

    public void setParentName(String name) {
        this.parentName = name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getPreferredLocation() {
        return this.preferredLocation;
    }

    @Override
    public void setPreferredLocation(String string) {
        this.preferredLocation = string;
    }

    @Override
    public void setLayers(LayerEvent evt) {
        if (evt.getType() == 403) {
            Layer[] layers = evt.getLayers();
            for (ZoomLevelMakerFace zlif : this.faces) {
                zlif.setLayers(layers);
            }
        }
    }

    protected void pushLayerSettingsToAll(List<ZoomLevelMakerFace.LayerObject> layerObjects) {
        for (ZoomLevelMakerFace zlif : this.faces) {
            zlif.matchObjects(layerObjects);
        }
    }

    protected void pushBoundarySettingsToAll(List<ZoomLevelMakerFace.BoundsObject> boundsList) {
        ArrayList<ZoomLevelMakerFace.BoundsObject> copy = new ArrayList<ZoomLevelMakerFace.BoundsObject>();
        copy.addAll(boundsList);
        for (ZoomLevelMakerFace zlif : this.faces) {
            zlif.matchBounds(copy);
        }
    }

    public void createRectangle() {
        GraphicAttributes ga = new GraphicAttributes();
        this.rectDA.setTo(ga);
        ga.setRenderType(1);
        ga.setLineType(2);
        EditableOMRect eomr = new EditableOMRect(ga);
        eomr.setXorRendering(false);
        this.create(eomr);
    }

    public void edit(OMGraphic omg, MouseEvent mevent) {
        OMDrawingTool dt = this.getDrawingTool();
        if (dt != null && dt.canEdit(omg.getClass())) {
            dt.resetBehaviorMask();
            MouseDelegator mDelegator = dt.getMouseDelegator();
            OMDrawingToolMouseMode omdtmm = dt.getMouseMode();
            if (!omdtmm.isVisible()) {
                dt.setMask(16);
            }
            if (dt.select(omg, this, mevent)) {
                if (this.activeFace != null) {
                    this.activeFace.enableBoundaryButtons(!this.drawingTool.isActivated());
                }
                dt.getCurrentEditable().getStateMachine().setSelected();
                if (!omdtmm.isVisible() && mDelegator != null) {
                    MapMouseMode mmm = mDelegator.getActiveMouseMode();
                    if (mmm.actAsProxyFor(omdtmm, 0)) {
                        this.setProxyMouseMode(mmm);
                    } else {
                        dt.deactivate();
                    }
                }
            }
        }
    }

    protected OMGraphic create(EditableOMGraphic omg) {
        OMDrawingTool dt = this.getDrawingTool();
        OMGraphic ret = null;
        if (dt != null) {
            dt.resetBehaviorMask();
            OMDrawingToolMouseMode omdtmm = dt.getMouseMode();
            MouseDelegator mDelegator = dt.getMouseDelegator();
            if (!omdtmm.isVisible()) {
                dt.setMask(16);
            }
            if ((ret = dt.edit(omg, (DrawingToolRequestor)this, null)) != null) {
                if (this.activeFace != null) {
                    this.activeFace.enableBoundaryButtons(!this.drawingTool.isActivated());
                }
                dt.getCurrentEditable().getStateMachine().setUndefined();
                if (!omdtmm.isVisible() && mDelegator != null) {
                    MapMouseMode mmm = mDelegator.getActiveMouseMode();
                    if (mmm.actAsProxyFor(omdtmm, 0)) {
                        this.setProxyMouseMode(mmm);
                    } else {
                        dt.deactivate();
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public void drawingComplete(OMGraphic omg, OMAction action) {
        this.releaseProxyMouseMode();
        if (this.activeFace != null) {
            this.activeFace.handleBoundary(omg, action);
            if (this.activeFace != null) {
                this.activeFace.enableBoundaryButtons(!this.drawingTool.isActivated());
            }
        }
    }

    protected synchronized void setProxyMouseMode(MapMouseMode mmm) {
        this.proxyMMM = mmm;
    }

    protected synchronized MapMouseMode getProxyMouseMode() {
        return this.proxyMMM;
    }

    public void releaseProxyMouseMode() {
        MapMouseMode pmmm = this.getProxyMouseMode();
        OMDrawingTool dt = this.getDrawingTool();
        if (pmmm != null && dt != null) {
            if (pmmm.isProxyFor(dt.getMouseMode())) {
                pmmm.releaseProxy();
                this.setProxyMouseMode(null);
            }
            if (dt.isActivated()) {
                dt.deactivate();
            }
        }
    }

    String getFileName() {
        return this.fileName;
    }

    void setFileName(String fileName) {
        this.fileName = fileName;
    }

    OMDrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    void setDrawingTool(OMDrawingTool drawingTool) {
        this.drawingTool = drawingTool;
    }

    DrawingAttributes getRectDA() {
        return this.rectDA;
    }

    void setRectDA(DrawingAttributes rectDA) {
        this.rectDA = rectDA;
    }

    @Override
    public void listenerPaint(Object source, Graphics graphics) {
        if (this.activeFace != null) {
            this.activeFace.paintBoundaries(graphics);
        }
    }

    @Override
    public void projectionChanged(ProjectionEvent e) {
        this.proj = e.getProjection();
        for (ZoomLevelMakerFace face : this.faces) {
            face.generate(this.proj);
        }
    }

    protected class TileRunnable
    implements Runnable {
        Properties props;
        boolean cancel = false;
        Future<Boolean> work = null;

        protected TileRunnable(Properties properties) {
            this.props = properties;
        }

        public synchronized void cancel() {
            this.cancel = true;
        }

        public void run() {
            this.work = TaskService.singleton().spawn(new TileWorker(this.props));
            try {
                while (!this.work.isDone()) {
                    if (!this.cancel) continue;
                    this.work.cancel(true);
                }
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (MapTileMakerComponent.this.cancelDialog != null) {
                MapTileMakerComponent.this.cancelDialog.setVisible(false);
                MapTileMakerComponent.this.cancelDialog.dispose();
                MapTileMakerComponent.this.cancelDialog = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TileWorker
    implements Callable<Boolean> {
        Properties props;

        protected TileWorker(Properties properties) {
            this.props = properties;
        }

        @Override
        public Boolean call() {
            MapTileMaker tileMaker = new MapTileMaker(this.props);
            tileMaker.makeTiles();
            return Boolean.TRUE;
        }
    }

    protected class ConfirmationDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        Properties launchProps;

        public ConfirmationDialog(Frame frame, Component locationComp, String title, MapTileMakerComponent mapTileMakerComponent) {
            super(frame, title, true);
            this.launchProps = new Properties();
            Container contentPane = this.getContentPane();
            JLabel info = new JLabel();
            StringBuffer content = new StringBuffer();
            int faceCount = 0;
            for (ZoomLevelMakerFace face : MapTileMakerComponent.this.faces) {
                if (!face.isInclude()) continue;
                ++faceCount;
            }
            if (faceCount == 0) {
                String no_zoom_levels_were_included = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "no_zoom_levels_were_included", "No zoom levels were included for tile creation");
                content.append("<html><body><p>").append(no_zoom_levels_were_included).append(".<p></body></html>");
                contentPane.add(info);
            } else {
                this.setPreferredSize(new Dimension(600, 500));
                JScrollPane scrollPane = new JScrollPane(info, 20, 30);
                contentPane.add((Component)scrollPane, "Center");
                content.append("<html><body>");
                String launching_maptilemaker = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "launching_maptilemaker", "Launching MapTileMaker with these settings");
                content.append("<h3>").append(launching_maptilemaker).append(":</h3>");
                StringBuffer zoomLevelList = new StringBuffer();
                StringBuffer totalLayers = null;
                for (ZoomLevelMakerFace face : MapTileMakerComponent.this.faces) {
                    if (!face.isInclude()) continue;
                    ZoomLevelMaker zli = face.getZoomLevelMaker();
                    zli.setPropertyPrefix("zoom" + zli.getZoomLevel());
                    zoomLevelList.append(" ").append(zli.getPropertyPrefix());
                    String zoom_level = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "zoom_level", "Zoom Level");
                    zli.name = zoom_level + " " + zli.getZoomLevel();
                    int rangeVal = zli.getRange();
                    if (rangeVal < zli.getZoomLevel()) {
                        zli.name = zli.name + " to " + rangeVal;
                    }
                    String configuration_for = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "configuration_for", "Configuration for");
                    zli.description = configuration_for + " " + zli.name;
                    zli.layers = new ArrayList<String>();
                    zli.bounds = new ArrayList<Rectangle2D>();
                    boolean buildLayerList = false;
                    content.append("<p><hr><b>").append(zoom_level).append(" ").append(zli.name).append("</b>");
                    String layers_string = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "layers_string", "Layers");
                    content.append("<ul><b>").append(layers_string).append(":</b>");
                    for (ZoomLevelMakerFace.LayerObject lo : face.layerList) {
                        if (totalLayers == null) {
                            totalLayers = new StringBuffer();
                            buildLayerList = true;
                        }
                        if (lo.isSelected()) {
                            content.append("<li>").append(lo.layer.getName());
                            zli.layers.add(lo.layer.getPropertyPrefix());
                        }
                        if (!buildLayerList) continue;
                        totalLayers.append(lo.layer.getPropertyPrefix()).append(" ");
                        lo.layer.getProperties(this.launchProps);
                    }
                    content.append("</ul>");
                    String coverage_string = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "coverage_string", "Coverage");
                    content.append("<ul><b>").append(coverage_string).append(":</b>");
                    if (face.boundsObjectList == null || face.boundsObjectList.isEmpty()) {
                        int edgeTileCount = face.zfi.getEdgeTileCount();
                        String entire_earth = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "entire_earth", "Entire Earth");
                        content.append("<li>").append(entire_earth).append(" (").append(edgeTileCount).append("x").append(edgeTileCount).append(" tiles)");
                    } else {
                        for (ZoomLevelMakerFace.BoundsObject bo : face.boundsObjectList) {
                            OMRect rect = bo.bounds;
                            content.append("<li>(").append(rect.getNorthLat()).append(", ").append(rect.getWestLon()).append(", ").append(rect.getSouthLat()).append(", ").append(rect.getEastLon()).append(")");
                            zli.bounds.add(zli.createProperBounds(rect.getWestLon(), rect.getNorthLat(), rect.getEastLon(), rect.getSouthLat()));
                        }
                    }
                    content.append("</ul>");
                    zli.getProperties(this.launchProps);
                }
                this.launchProps.put("zoomLevels", zoomLevelList.toString().trim());
                if (totalLayers != null) {
                    this.launchProps.put("layers", totalLayers.toString().trim());
                }
                if (MapTileMakerComponent.this.transparentTiles) {
                    this.launchProps.put("background", "00000000");
                } else {
                    MapHandler mh = (MapHandler)MapTileMakerComponent.this.getBeanContext();
                    MapBean mb = mh.get(MapBean.class);
                    Color background = mb.getBackground();
                    String colorString = Integer.toHexString(background.getRGB());
                    this.launchProps.put("background", colorString);
                }
                this.launchProps.put("antialiasing", "true");
                this.launchProps.put("rootDir", MapTileMakerComponent.this.rootDir);
                this.launchProps.put("formatters", "png");
                this.launchProps.put("png.class", "com.bbn.openmap.image.PNGImageIOFormatter");
                content.append("</body></html>");
            }
            info.setText(content.toString());
            info.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel buttonPanel = new JPanel();
            String create_map_tiles = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "create_map_tiles", "Create Map Tiles");
            JButton confirm = new JButton(create_map_tiles);
            confirm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ConfirmationDialog.this.setVisible(false);
                    MapTileMakerComponent.this.launchTileMaker(ConfirmationDialog.this.getLaunchProps());
                }
            });
            if (faceCount > 0) {
                buttonPanel.add(confirm);
            }
            String cancel_string = MapTileMakerComponent.this.i18n.get(MapTileMakerComponent.class, "cancel_string", "Cancel");
            JButton cancel = new JButton(cancel_string);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ConfirmationDialog.this.setVisible(false);
                }
            });
            buttonPanel.add(cancel);
            contentPane.add((Component)buttonPanel, "Last");
            this.pack();
            this.setLocationRelativeTo(locationComp);
        }

        Properties getLaunchProps() {
            return this.launchProps;
        }
    }
}

