/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MapHandlerChild;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.event.ProgressSupport;
import com.bbn.openmap.gui.ProgressListenerGauge;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyHandler
extends MapHandlerChild
implements SoloMapComponent {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.PropertyHandler");
    protected transient I18n i18n = Environment.getI18n();
    protected String propertyPrefix;
    public static final String propsFileName = "properties";
    public static final String configDirProperty = "configDir";
    public static final String componentProperty = "components";
    public static final String includeProperty = "include";
    public static final String localizedProperty = "localized";
    protected Properties properties = new Properties();
    protected Set usedPrefixes = Collections.synchronizedSet(new HashSet());
    protected ProgressSupport progressSupport;
    protected boolean updateProgress = false;
    protected Hashtable prefixLibrarian = new Hashtable();
    protected boolean DEBUG = logger.isLoggable(Level.FINE);

    public PropertyHandler() {
        this(new Builder());
    }

    public PropertyHandler(boolean provideProgressUpdates) {
        this(new Builder().setProgressUpdates(provideProgressUpdates));
    }

    public PropertyHandler(String urlString) throws MalformedURLException, IOException {
        this(new Builder().setPropertiesFile(urlString));
    }

    public PropertyHandler(URL url) throws IOException {
        this(new Builder().setPropertiesFile(url));
    }

    public PropertyHandler(Properties props) {
        this(new Builder().setProperties(props));
    }

    public PropertyHandler(Builder builder) {
        this.setPropertyPrefix(builder.propertyPrefix);
        this.setUpdateProgress(builder.update);
        Properties properties = builder.properties;
        if (properties == null) {
            this.searchForAndLoadProperties();
        } else {
            this.init(properties, "URL");
            Environment.init(this.getProperties());
        }
    }

    public String getDefaultPropertyFileName() {
        return PropUtils.getScopedPropertyPrefix("openmap") + propsFileName;
    }

    protected void searchForAndLoadProperties() {
        this.searchForAndLoadProperties(this.getDefaultPropertyFileName());
    }

    protected void searchForAndLoadProperties(String propsFileName) {
        Properties systemProperties;
        InputStream propsIn;
        Properties tmpProperties = new Properties();
        boolean foundProperties = false;
        if (Debug.debugging("locale")) {
            Locale.setDefault(new Locale("pl", "PL"));
        }
        if (Debug.debugging("showprogress")) {
            this.updateProgress = true;
        }
        logger.fine("***** Searching for properties ****");
        String propertyPrefix = PropUtils.getScopedPropertyPrefix(this.getPropertyPrefix());
        if (this.DEBUG) {
            logger.fine("Looking for " + propsFileName + " in Resources");
        }
        if ((propsIn = this.getClass().getResourceAsStream(propsFileName)) == null && Environment.isApplet()) {
            URL[] cba = new URL[]{Environment.getApplet().getCodeBase()};
            URLClassLoader ucl = URLClassLoader.newInstance(cba);
            propsIn = ucl.getResourceAsStream(propsFileName);
        }
        if (propsIn == null) {
            propsIn = ClassLoader.getSystemResourceAsStream(propsFileName);
            if (propsIn != null && this.DEBUG) {
                logger.fine("Loading properties from System Resources: " + propsFileName);
            }
        } else if (this.DEBUG) {
            logger.fine("Loading properties from file " + propsFileName + " from package of class " + this.getClass());
        }
        if (propsIn != null) {
            foundProperties = PropUtils.loadProperties(tmpProperties, propsIn);
            this.init(tmpProperties, "resources");
            tmpProperties.clear();
        }
        if (!foundProperties && (Environment.isApplet() || this.DEBUG)) {
            logger.fine("Unable to locate as resource: " + propsFileName);
        }
        if (Environment.isApplet()) {
            Environment.init(this.getProperties());
            return;
        }
        try {
            systemProperties = System.getProperties();
        }
        catch (AccessControlException ace) {
            systemProperties = new Properties();
        }
        String configDirProperty = propertyPrefix + configDirProperty;
        String openmapConfigDirectory = systemProperties.getProperty(configDirProperty);
        if (openmapConfigDirectory == null) {
            Vector<String> cps = Environment.getClasspathDirs();
            String defaultExtraDir = "share";
            for (String searchLoc : cps) {
                File shareDir = new File(searchLoc, defaultExtraDir);
                if (!shareDir.exists()) continue;
                openmapConfigDirectory = shareDir.getPath();
                break;
            }
        }
        Environment.addPathToClasspaths(openmapConfigDirectory);
        if (this.DEBUG) {
            logger.fine("PropertyHandler: Looking for " + propsFileName + " in configuration directory: " + (openmapConfigDirectory == null ? "not set" : openmapConfigDirectory));
        }
        foundProperties |= PropUtils.loadProperties(tmpProperties, openmapConfigDirectory, propsFileName);
        Properties includeProperties = this.getIncludeProperties(tmpProperties.getProperty(propertyPrefix + includeProperty), tmpProperties);
        this.merge(includeProperties, "include file properties", openmapConfigDirectory);
        this.merge(tmpProperties, propsFileName, openmapConfigDirectory);
        tmpProperties.clear();
        this.merge(systemProperties, "system properties", "system");
        String userHomeDirectory = systemProperties.getProperty("user.home");
        if (this.DEBUG) {
            logger.fine("Looking for " + propsFileName + " in user's home directory: " + userHomeDirectory);
        }
        foundProperties |= PropUtils.loadProperties(tmpProperties, userHomeDirectory, propsFileName);
        if (this.DEBUG) {
            logger.fine("***** Done with property search ****");
        }
        if (!foundProperties && !Environment.isApplet()) {
            PropUtils.copyProperties(PropUtils.promptUserForProperties(), this.properties);
        }
        includeProperties = this.getIncludeProperties(tmpProperties.getProperty(propertyPrefix + includeProperty), tmpProperties);
        this.merge(includeProperties, "include file properties", userHomeDirectory);
        this.merge(tmpProperties, propsFileName, userHomeDirectory);
        Properties localizedProperties = this.getLocalizedProperties(tmpProperties.getProperty(propertyPrefix + localizedProperty), userHomeDirectory);
        this.merge(localizedProperties, "localized properties", null);
        Environment.init(this.getProperties());
    }

    protected Properties getLocalizedProperties(String localizedPropertyFile, String userHomeDirectory) {
        Properties props = null;
        if (localizedPropertyFile == null) {
            Locale loc = Locale.getDefault();
            localizedPropertyFile = "openmap_" + loc.toString() + ".properties";
        }
        boolean tryHomeDirectory = false;
        if (this.DEBUG) {
            logger.fine("Looking for localized file: " + localizedPropertyFile);
        }
        try {
            URL propsURL = PropUtils.getResourceOrFileOrURL(localizedPropertyFile);
            if (propsURL == null) {
                tryHomeDirectory = true;
            } else {
                if (this.DEBUG) {
                    logger.fine("Found localized properties in classpath");
                }
                props = PropertyHandler.fetchProperties(propsURL);
            }
        }
        catch (MalformedURLException murle) {
            logger.warning("PropertyHandler can't find localized property file: " + localizedPropertyFile);
            tryHomeDirectory = true;
        }
        if (tryHomeDirectory) {
            props = new Properties();
            if (!PropUtils.loadProperties(props, userHomeDirectory, localizedPropertyFile)) {
                props = null;
            } else if (this.DEBUG) {
                logger.fine("Found localized properties in home directory");
            }
        }
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    protected void init(Properties props, String howString) {
        String prefix = PropUtils.getScopedPropertyPrefix(this.getPropertyPrefix());
        Properties includeProperties = this.getIncludeProperties(props.getProperty(prefix + includeProperty), props);
        this.merge(includeProperties, "include file properties", howString);
        if (!Environment.isApplet()) {
            Properties systemProperties = System.getProperties();
            this.merge(systemProperties, props);
        }
        this.merge(props, "loaded", howString);
        if (this.DEBUG) {
            logger.fine("loaded properties");
        }
    }

    protected Properties getIncludeProperties(String markerList, Properties props) {
        Properties newProps = new Properties();
        Properties tmpProps = new Properties();
        Vector<String> includes = PropUtils.parseSpacedMarkers(markerList);
        int size = includes.size();
        if (size > 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("handling include files: " + includes);
            }
            for (int i = 0; i < size; ++i) {
                String includeName = includes.elementAt(i);
                String includeProperty = includeName + ".URL";
                String include = props.getProperty(includeProperty);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("checking " + includeProperty + ", getting: " + include);
                }
                if (include == null) {
                    logger.warning("PropertyHandler.getIncludeProperties(): Failed to locate include file \"" + includeName + "\" with URL \"" + includeProperty + "\"\n  Skipping include file \"" + include + "\"");
                    continue;
                }
                try {
                    tmpProps.clear();
                    URL tmpInclude = PropUtils.getResourceOrFileOrURL(null, include);
                    if (tmpInclude == null) {
                        logger.fine("Can't locate URL trying to find included properties: " + include);
                        continue;
                    }
                    InputStream is = tmpInclude.openStream();
                    tmpProps.load(is);
                    if (this.DEBUG) {
                        logger.fine("PropertyHandler.getIncludeProperties(): located include properties file URL: " + include);
                    }
                    Properties includeProperties = this.getIncludeProperties(tmpProps.getProperty(includeProperty), tmpProps);
                    this.merge(includeProperties, newProps, "include file properties", "within " + include);
                    this.merge(tmpProps, newProps, "include file properties", include);
                    continue;
                }
                catch (MalformedURLException e) {
                    logger.warning("malformed URL for include file: |" + include + "| for " + includeName);
                    continue;
                }
                catch (IOException ioe) {
                    logger.warning("IOException processing " + include + "| for " + includeName);
                }
            }
        } else {
            logger.fine("no include files found.");
        }
        return newProps;
    }

    protected void merge(Properties from) {
        this.merge(from, this.getProperties(), null, null);
    }

    protected void merge(Properties from, Properties to) {
        this.merge(from, to, null, null);
    }

    protected void merge(Properties from, String what, String where) {
        this.merge(from, this.getProperties(), what, where);
    }

    protected void merge(Properties from, Properties to, String what, String where) {
        if (!from.isEmpty()) {
            if (to == null) {
                to = this.getProperties();
            }
            PropUtils.copyProperties(from, to);
        } else if (what != null && this.DEBUG) {
            logger.fine("no " + what + " found" + (where == null ? "." : " in " + where));
        }
    }

    public void setProperties(Properties props) {
        this.init(props, null);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Object get(String markername) {
        return this.prefixLibrarian.get(markername.intern());
    }

    public Properties getProperties(String prefix) {
        Properties prefixProperties = new Properties();
        Properties props = this.getProperties();
        if (prefix != null) {
            String scopedPrefix = prefix + ".";
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(scopedPrefix)) continue;
                prefixProperties.put(key, props.get(key));
            }
        }
        return prefixProperties;
    }

    public void put(String markername, Object obj) {
        this.prefixLibrarian.put(markername.intern(), obj);
    }

    public Object remove(String markername) {
        return this.prefixLibrarian.remove(markername);
    }

    public Hashtable getPrefixLibrarian() {
        return this.prefixLibrarian;
    }

    public void createComponents(MapHandler mapHandler) {
        if (mapHandler == null) {
            logger.fine("no MapHandler to use to handle created components, skipping creation.");
            return;
        }
        ProgressListenerGauge plg = null;
        if (this.updateProgress) {
            try {
                String internString = this.i18n.get(this.getClass(), "progressTitle", "Progress");
                plg = new ProgressListenerGauge(internString);
                plg.setWindowSupport(new WindowSupport((Component)plg, new WindowSupport.Frm("", true)));
                this.addProgressListener(plg);
            }
            catch (Exception internString) {
                // empty catch block
            }
        }
        Vector<String> debugList = PropUtils.parseSpacedMarkers(this.properties.getProperty("openmap.Debug"));
        int size = debugList.size();
        for (String debugMarker : debugList) {
            Debug.put(debugMarker);
            if (!this.DEBUG) continue;
            logger.fine("adding " + debugMarker + " to Debug list.");
        }
        String propPrefix = PropUtils.getScopedPropertyPrefix(this.getPropertyPrefix());
        String componentProperty = propPrefix + componentProperty;
        Vector<String> componentList = PropUtils.parseSpacedMarkers(this.properties.getProperty(componentProperty));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("creating components from " + componentList);
        }
        if (this.updateProgress) {
            this.fireProgressUpdate(0, this.i18n.get(this.getClass(), "creatingComponentsProgressMessage", "Creating Components"), 0, 100);
        }
        Vector<?> components = ComponentFactory.create(componentList, this.properties, this.updateProgress ? this.getProgressSupport() : null, true);
        size = components.size();
        for (int i = 0; i < size; ++i) {
            Object obj = components.elementAt(i);
            try {
                if (obj instanceof String) {
                    logger.warning("finding out that the " + obj + " wasn't created");
                    continue;
                }
                mapHandler.addLater(obj);
                String markerName = componentList.elementAt(i).intern();
                this.prefixLibrarian.put(markerName, obj);
                this.addUsedPrefix(markerName);
                continue;
            }
            catch (MultipleSoloMapComponentException msmce) {
                logger.warning("PropertyHandler.createComponents(): tried to add multiple components of the same type when only one is allowed! - " + msmce);
            }
        }
        mapHandler.purgeLaterList();
        if (this.updateProgress) {
            this.fireProgressUpdate(2, this.i18n.get(this.getClass(), "completedProgressMessage", "Created all components, ready..."), size, size);
            this.removeProgressListener(plg);
        }
    }

    public String getPropertyPrefix() {
        String propertyPrefix = this.propertyPrefix;
        if (propertyPrefix == null) {
            propertyPrefix = "openmap";
        }
        return propertyPrefix;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public static Properties createOpenMapProperties(MapHandler mapHandler, PrintStream ps) {
        Properties createdProperties = new Properties();
        if (mapHandler == null) {
            logger.warning("can't create properties with null MapHandler");
            return null;
        }
        Iterator it = mapHandler.iterator();
        logger.fine("Looking for objects in MapHandler");
        MapBean mapBean = null;
        LayerHandler layerHandler = null;
        PropertyHandler propertyHandler = null;
        InformationDelegator infoDelegator = null;
        Vector otherComponents = new Vector();
        while (it.hasNext()) {
            Object someObj = it.next();
            logger.fine("found " + someObj.getClass().getName());
            if (someObj instanceof MapBean) {
                mapBean = (MapBean)someObj;
                continue;
            }
            if (someObj instanceof LayerHandler) {
                layerHandler = (LayerHandler)someObj;
                continue;
            }
            if (someObj instanceof Layer || someObj instanceof PlugIn) continue;
            if (someObj instanceof PropertyHandler) {
                propertyHandler = (PropertyHandler)someObj;
                if (infoDelegator == null) continue;
                propertyHandler.addProgressListener(infoDelegator);
                continue;
            }
            if (someObj instanceof InformationDelegator) {
                infoDelegator = (InformationDelegator)someObj;
                if (propertyHandler == null) continue;
                propertyHandler.addProgressListener((ProgressListener)someObj);
                continue;
            }
            otherComponents.add(someObj);
        }
        if (mapBean == null || layerHandler == null) {
            logger.warning("no MapBean(" + mapBean + ") or LayerHandler(" + layerHandler + ") to use to write properties");
            return null;
        }
        ps.println("######  OpenMap properties file ######");
        ps.println("## Refer to original openmap.properties file\n## for instructions on how to modify this file.");
        ps.println("######################################");
        PropertyHandler.printMapProperties(mapBean, ps, createdProperties);
        PropertyHandler.printComponentProperties(otherComponents, propertyHandler, ps, createdProperties);
        PropertyHandler.printLayerProperties(layerHandler, propertyHandler, ps, createdProperties);
        if (logger.isLoggable(Level.FINE) && createdProperties != null) {
            System.out.println(createdProperties);
        }
        return createdProperties;
    }

    protected static void printProperties(String key, String value, PrintStream ps, Properties createdProperties) {
        if (ps != null) {
            ps.println(key + "=" + value);
        }
        if (createdProperties != null) {
            createdProperties.put(key, value);
        }
    }

    protected static void printMapProperties(MapBean mapBean, PrintStream ps, Properties createdProperties) {
        Proj proj = mapBean.projection;
        ps.println("\n### OpenMap initial Map Settings ###");
        Point2D llp = proj.getCenter();
        PropertyHandler.printProperties("openmap.Latitude", Double.toString(llp.getY()), ps, createdProperties);
        PropertyHandler.printProperties("openmap.Longitude", Double.toString(llp.getX()), ps, createdProperties);
        PropertyHandler.printProperties("openmap.Scale", Float.toString(proj.getScale()), ps, createdProperties);
        PropertyHandler.printProperties("openmap.Projection", proj.getName(), ps, createdProperties);
        PropertyHandler.printProperties("openmap.BackgroundColor", Integer.toHexString(mapBean.getBackground().getRGB()), ps, createdProperties);
    }

    protected static void printComponentProperties(Vector components, PropertyHandler ph, PrintStream ps, Properties createdProperties) {
        boolean buildConfiguredApplication = true;
        boolean componentListBuilt = false;
        int numComponents = 0;
        String componentProperty = componentProperty;
        StringBuffer componentMarkerString = new StringBuffer(componentProperty).append("=");
        if (ph != null) {
            String phPrefix = PropUtils.getScopedPropertyPrefix(ph.getPropertyPrefix());
            componentProperty = phPrefix + componentProperty;
            componentMarkerString = new StringBuffer(componentProperty).append("=");
        }
        StringBuffer componentPropsString = new StringBuffer();
        if (ph != null && buildConfiguredApplication) {
            Properties phProps = ph.getProperties();
            componentMarkerString.append(phProps.getProperty(componentProperty));
            Vector<String> componentList = PropUtils.parseSpacedMarkers(phProps.getProperty(componentProperty));
            for (int i = 0; i < componentList.size(); ++i) {
                String markerNameClass = componentList.elementAt(i) + ".class";
                componentPropsString.append(markerNameClass).append("=").append(phProps.get(markerNameClass)).append("\n");
                if (createdProperties == null) continue;
                createdProperties.put(markerNameClass, phProps.get(markerNameClass));
            }
            componentListBuilt = true;
        }
        Properties componentProperties = new Properties();
        Enumeration comps = components.elements();
        while (comps.hasMoreElements()) {
            String markerName;
            Object someObj = comps.nextElement();
            if (someObj instanceof PropertyConsumer) {
                logger.fine("Getting Property Info for" + someObj.getClass().getName());
                PropertyConsumer pc = (PropertyConsumer)someObj;
                componentProperties.clear();
                markerName = pc.getPropertyPrefix();
                if (ph != null && markerName != null && !markerName.equals("openmap")) {
                    componentProperties = ph.getProperties(markerName);
                } else {
                    componentProperties.clear();
                }
                if (!componentListBuilt) {
                    if (markerName != null) {
                        componentMarkerString.append(" ").append(markerName);
                    } else {
                        markerName = "component" + numComponents++;
                        componentMarkerString.append(" ").append(markerName);
                        pc.setPropertyPrefix(markerName);
                    }
                    componentPropsString.append(markerName).append(".class=").append(someObj.getClass().getName()).append("\n");
                    if (createdProperties != null) {
                        createdProperties.put(markerName, someObj.getClass().getName());
                    }
                }
                pc.getProperties(componentProperties);
                TreeMap<Object, Object> orderedProperties = new TreeMap<Object, Object>(componentProperties);
                if (componentProperties.isEmpty()) continue;
                componentPropsString.append("####\n");
                for (String string : orderedProperties.keySet()) {
                    String value = componentProperties.getProperty(string);
                    if (value != null) {
                        componentPropsString.append(string).append("=").append(value).append("\n");
                    }
                    if (createdProperties == null || value == null) continue;
                    createdProperties.put(string, value);
                }
                continue;
            }
            if (componentListBuilt) continue;
            markerName = "component" + numComponents++;
            componentMarkerString.append(" ").append(markerName);
            componentPropsString.append(markerName).append(".class=").append(someObj.getClass().getName()).append("\n");
            if (createdProperties == null) continue;
            createdProperties.put(markerName, someObj.getClass().getName());
        }
        if (ps != null) {
            ps.println("\n\n### OpenMap Components ###");
            ps.println(componentMarkerString.toString());
            ps.println("\n### OpenMap Component Properties ###");
            ps.println(componentPropsString.toString());
            ps.println("### End Component Properties ###");
        }
        if (createdProperties != null) {
            createdProperties.put(componentProperty, componentMarkerString.substring(componentProperty.length() + 1));
        }
    }

    protected static void printLayerProperties(LayerHandler layerHandler, PropertyHandler ph, PrintStream ps, Properties createdProperties) {
        String layerMarkerStringKey = "openmap.layers";
        StringBuffer layerMarkerString = new StringBuffer(layerMarkerStringKey).append("=");
        String startUpLayerMarkerStringKey = "openmap.startUpLayers";
        StringBuffer startUpLayerMarkerString = new StringBuffer(startUpLayerMarkerStringKey).append("=");
        StringBuffer layerPropertiesString = new StringBuffer();
        Properties layerProperties = new Properties();
        Layer[] layers = layerHandler.getLayers();
        int numLayers = 0;
        for (int i = 0; i < layers.length; ++i) {
            String markerName = layers[i].getPropertyPrefix();
            if (markerName == null) {
                markerName = "layer" + numLayers++;
                layers[i].setPropertyPrefix(markerName);
            }
            if (ph != null) {
                layerProperties = ph.getProperties(markerName);
            } else {
                layerProperties.clear();
            }
            layerMarkerString.append(" ").append(markerName);
            if (layers[i].isVisible()) {
                startUpLayerMarkerString.append(" ").append(markerName);
            }
            layers[i].getProperties(layerProperties);
            layerPropertiesString.append("### -").append(markerName).append("- layer properties\n");
            TreeMap<Object, Object> orderedProperties = new TreeMap<Object, Object>(layerProperties);
            for (String string : orderedProperties.keySet()) {
                String value = layerProperties.getProperty(string);
                if (value != null) {
                    layerPropertiesString.append(string).append("=").append(value).append("\n");
                }
                if (createdProperties == null || value == null) continue;
                createdProperties.put(string, value);
            }
            layerPropertiesString.append("### end of -").append(markerName).append("- properties\n\n");
        }
        if (ps != null) {
            ps.println("\n### OpenMap Layers ###");
            ps.println(layerMarkerString.toString());
            ps.println(startUpLayerMarkerString.toString());
            ps.println(layerPropertiesString.toString());
        }
        if (createdProperties != null) {
            createdProperties.put(layerMarkerStringKey, layerMarkerString.substring(layerMarkerStringKey.length() + 1));
            createdProperties.put(startUpLayerMarkerStringKey, startUpLayerMarkerString.substring(startUpLayerMarkerStringKey.length() + 1));
        }
    }

    public void loadProjectionAndLayers(MapHandler mapHandler, Properties props) {
        MapBean mapBean = (MapBean)mapHandler.get("com.bbn.openmap.MapBean");
        LayerHandler layerHandler = (LayerHandler)mapHandler.get("com.bbn.openmap.LayerHandler");
        if (layerHandler != null) {
            layerHandler.removeAll();
            layerHandler.init("openmap", props);
        } else {
            logger.warning("Can't load new layers - can't find LayerHandler");
        }
        if (mapBean != null) {
            mapBean.setProjection(mapBean.getProjectionFactory().getDefaultProjectionFromEnvironment(Environment.getInstance(), mapBean.getWidth(), mapBean.getHeight()));
        } else {
            logger.warning("Can't load new projection - can't find MapBean");
        }
    }

    public String getUniquePrefix(String prefix) {
        if (!this.addUsedPrefix(prefix = prefix.replace(' ', '_'))) {
            int count = 2;
            String nextTry = prefix + count;
            while (!this.addUsedPrefix(nextTry)) {
                nextTry = prefix + ++count;
            }
            return nextTry;
        }
        return prefix;
    }

    public boolean addUsedPrefix(String prefix) {
        prefix = prefix.replace(' ', '_');
        return this.usedPrefixes.add(prefix.intern());
    }

    public boolean removeUsedPrefix(String prefix) {
        prefix = prefix.replace(' ', '_');
        return this.usedPrefixes.remove(prefix.intern());
    }

    public void addProgressListener(ProgressListener list) {
        this.getProgressSupport().add(list);
    }

    public void removeProgressListener(ProgressListener list) {
        this.getProgressSupport().remove(list);
    }

    public void clearProgressListeners() {
        this.getProgressSupport().clear();
    }

    protected ProgressSupport getProgressSupport() {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport(this);
        }
        return this.progressSupport;
    }

    protected void fireProgressUpdate(int type, String task, int frameNumber, int totalFrames) {
        if (this.updateProgress) {
            this.getProgressSupport().fireUpdate(type, task, totalFrames, frameNumber);
        } else if (type == 2) {
            this.getProgressSupport().fireUpdate(2, task, totalFrames, frameNumber);
        }
    }

    public void setUpdateProgress(boolean set) {
        this.updateProgress = set;
    }

    public boolean getUpdateProgress() {
        return this.updateProgress;
    }

    public boolean removeProperty(String property) {
        return this.getProperties().remove(property) != null;
    }

    public void addProperty(String property, String value) {
        this.getProperties().setProperty(property, value);
    }

    public void addProperties(URL urlToProperties) {
        this.addProperties(PropertyHandler.fetchProperties(urlToProperties));
    }

    public void addProperties(String propFile) throws MalformedURLException {
        this.addProperties(PropertyHandler.fetchProperties(PropUtils.getResourceOrFileOrURL(propFile)));
    }

    public void addProperties(Properties p) {
        String[] specialProps = new String[]{"openmap.layers", "openmap.startUpLayers", componentProperty};
        Properties tmp = new Properties();
        tmp.putAll((Map<?, ?>)p);
        for (int i = 0; i < specialProps.length; ++i) {
            this.prependProperty(specialProps[i], tmp);
            tmp.remove(specialProps[i]);
        }
        this.getProperties().putAll((Map<?, ?>)tmp);
    }

    public void removeMarker(String property, String marker) {
        String propertyString = this.getProperties().getProperty(property, "");
        int idx = propertyString.indexOf(marker);
        if (idx != -1) {
            StringBuffer sb = new StringBuffer(propertyString);
            sb.delete(idx, idx + marker.length());
            this.getProperties().setProperty(property, sb.toString());
        }
    }

    public void appendProperty(String property, Properties src) {
        this.appendProperty(property, src.getProperty(property, ""));
    }

    public void appendProperty(String property, String value) {
        String curVal = this.getProperties().getProperty(property, "");
        this.getProperties().setProperty(property, curVal + " " + value);
    }

    public void prependProperty(String property, Properties src) {
        this.prependProperty(property, src.getProperty(property, ""));
    }

    public void prependProperty(String property, String value) {
        String curVal = this.getProperties().getProperty(property, "");
        this.getProperties().setProperty(property, value + " " + curVal);
    }

    public static Properties fetchProperties(URL propsURL) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("checking (" + propsURL + ")");
        }
        Properties p = new Properties();
        if (propsURL != null) {
            try {
                InputStream is = propsURL.openStream();
                p.load(is);
                is.close();
            }
            catch (IOException e) {
                logger.warning("Exception reading map properties at " + propsURL + ": " + e);
            }
        }
        return p;
    }

    public void findAndInit(Object obj) {
        String prefix;
        if (obj instanceof PropertyConsumer && (prefix = ((PropertyConsumer)obj).getPropertyPrefix()) != null) {
            this.getPrefixLibrarian().put(prefix, obj);
        }
    }

    public void findAndUndo(Object obj) {
        String prefix;
        if (obj instanceof PropertyConsumer && (prefix = ((PropertyConsumer)obj).getPropertyPrefix()) != null) {
            this.getPrefixLibrarian().remove(prefix);
        }
        if (obj == this) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.prefixLibrarian != null) {
            this.prefixLibrarian.clear();
        }
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.usedPrefixes != null) {
            this.usedPrefixes.clear();
        }
    }

    public static class Builder {
        protected boolean update = false;
        protected Properties properties = null;
        protected String propertyPrefix = null;

        public Builder setPropertiesFile(String location) throws MalformedURLException, IOException {
            if (location != null) {
                this.properties = this.createProperties(PropUtils.getResourceOrFileOrURL(location));
            }
            return this;
        }

        public Builder setPropertiesFile(URL url) throws IOException {
            if (url != null) {
                this.properties = this.createProperties(url);
            }
            return this;
        }

        public Builder setProperties(Properties props) {
            this.properties = props;
            return this;
        }

        public Builder setPropertyPrefix(String prefix) {
            this.propertyPrefix = prefix;
            return this;
        }

        public Builder setProgressUpdates(boolean update) {
            this.update = update;
            return this;
        }

        protected Properties createProperties(URL location) throws IOException {
            InputStream is = null;
            if (location != null) {
                is = location.openStream();
            }
            Properties tmpProperties = new Properties();
            if (is != null) {
                tmpProperties.load(is);
            }
            return tmpProperties;
        }

        public PropertyHandler build() {
            return new PropertyHandler(this);
        }
    }
}

