/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.NatCubicClosedSpline;
import com.bbn.openmap.omGraphics.NatCubicSpline;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class OMSpline
extends OMPoly {
    private transient NatCubicSpline natCubic = new NatCubicSpline();
    private transient NatCubicClosedSpline natCubicClosed = new NatCubicClosedSpline();

    public OMSpline() {
    }

    public OMSpline(double[] llPoints, int units, int lType) {
        super(llPoints, units, lType);
    }

    public OMSpline(double[] llPoints, int units, int lType, int nsegs) {
        super(llPoints, units, lType, nsegs);
    }

    public OMSpline(int[] xypoints) {
        super(xypoints);
    }

    public OMSpline(int[] xPoints, int[] yPoints) {
        super(xPoints, yPoints);
    }

    public OMSpline(double latPoint, double lonPoint, int[] xypoints, int cMode) {
        super(latPoint, lonPoint, xypoints, cMode);
    }

    public OMSpline(double latPoint, double lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(latPoint, lonPoint, xPoints, yPoints, cMode);
    }

    public boolean generate(Projection proj) {
        this.setNeedToRegenerate(true);
        if (proj == null) {
            Debug.message("omspline", "OMSpline: null projection in generate!");
            return false;
        }
        NatCubicSpline spline = this.isGeometryClosed() ? this.natCubicClosed : this.natCubic;
        spline.setSteps(this.nsegs);
        switch (this.renderType) {
            case 2: {
                if (this.xs == null) {
                    Debug.message("omspline", "OMSpline x/y rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                float[][] splinePoints = spline.calc(this.xs, this.ys);
                this.xpoints = new float[1][0];
                this.xpoints[0] = splinePoints[0];
                this.ypoints = new float[1][0];
                this.ypoints[0] = splinePoints[1];
                break;
            }
            case 3: {
                if (this.xs == null) {
                    Debug.message("omspline", "OMSpline offset rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                int npts = this.xs.length;
                float[] _x = new float[npts];
                float[] _y = new float[npts];
                Point origin = new Point();
                if (proj instanceof GeoProj) {
                    ((GeoProj)proj).forward(this.lat, this.lon, (Point2D)origin, true);
                } else {
                    proj.forward(Math.toDegrees(this.lat), Math.toDegrees(this.lon), (Point2D)origin);
                }
                if (this.coordMode == 0) {
                    for (int i = 0; i < npts; ++i) {
                        _x[i] = (float)((double)this.xs[i] + origin.getX());
                        _y[i] = (float)((double)this.ys[i] + origin.getY());
                    }
                } else {
                    _x[0] = this.xs[0] + origin.x;
                    _y[0] = this.ys[0] + origin.y;
                    for (int i = 1; i < npts; ++i) {
                        _x[i] = (float)this.xs[i] + _x[i - 1];
                        _y[i] = (float)this.ys[i] + _y[i - 1];
                    }
                }
                float[][] splinePoints = spline.calc(_x, _y);
                this.xpoints = new float[1][0];
                this.xpoints[0] = splinePoints[0];
                this.ypoints = new float[1][0];
                this.ypoints[0] = splinePoints[1];
                break;
            }
            case 1: {
                if (this.rawllpts == null) {
                    Debug.message("omspline", "OMSpline latlon rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                double[] splinellpts = spline.calc(this.rawllpts, 1.0E-8f);
                ArrayList<float[]> vector = proj instanceof GeoProj ? ((GeoProj)proj).forwardPoly(splinellpts, this.lineType, this.nsegs, this.isPolygon) : proj.forwardPoly(this.rawllpts, this.isPolygon);
                int size = vector.size();
                this.xpoints = new float[size / 2][0];
                this.ypoints = new float[this.xpoints.length][0];
                int i = 0;
                int j = 0;
                while (i < size) {
                    this.xpoints[j] = vector.get(i);
                    this.ypoints[j] = vector.get(i + 1);
                    i += 2;
                    ++j;
                }
                if (this.doShapes || size <= 1) break;
                this.setNeedToRegenerate(false);
                this.initLabelingDuringGenerate();
                this.setLabelLocation(this.xpoints[0], this.ypoints[0]);
                return true;
            }
            case 0: {
                Debug.error("OMSpline.generate: invalid RenderType");
                return false;
            }
        }
        this.setNeedToRegenerate(false);
        this.setShape(this.createShape());
        this.setLabelLocation(this.getShape(), proj);
        return true;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.natCubic = new NatCubicSpline();
        this.natCubicClosed = new NatCubicClosedSpline();
    }
}

