/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.image.ImageHelper;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DeepCopyUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OMRasterObject
extends OMGraphicAdapter
implements OMGraphic,
ImageObserver {
    private static final long serialVersionUID = 1L;
    public static final int COLORMODEL_DIRECT = 0;
    public static final int COLORMODEL_INDEXED = 1;
    public static final int COLORMODEL_IMAGEICON = 2;
    public static final int SMOOTH_SCALING = 0;
    public static final int FAST_SCALING = 1;
    protected int colorModel = 0;
    protected int[] pixels = null;
    protected int x = 0;
    protected int y = 0;
    protected double lat = 0.0;
    protected double lon = 0.0;
    protected int width = 0;
    protected int height = 0;
    protected byte[] bits = null;
    protected transient Image bitmap = null;
    protected transient Point point1 = null;
    protected transient Point point2 = null;
    protected int filteredWidth = 0;
    protected int filteredHeight = 0;
    protected ImageFilter imageFilter = null;
    protected boolean needToReposition = true;
    transient int projHeight;
    transient int projWidth;
    protected double rotationAngle;
    protected Double renderRotationAngle = null;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.omGraphics.OMRasterObject");
    protected transient boolean DEBUG = logger.isLoggable(Level.FINE);

    public OMRasterObject() {
        super(0, 0, 0);
    }

    public OMRasterObject(int rType, int lType, int dcType) {
        super(rType, lType, dcType);
    }

    protected void setColorModel(int cm) {
        this.colorModel = cm;
    }

    public int getColorModel() {
        return this.colorModel;
    }

    public void setNeedToReposition(boolean value) {
        this.needToReposition = value;
    }

    public boolean getNeedToReposition() {
        return this.needToReposition;
    }

    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
        this.setNeedToRegenerate(true);
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    protected abstract int[] computePixels(byte[] var1);

    protected void rotate(Graphics2D g) {
        Double angle = this.renderRotationAngle;
        if (angle != null) {
            int w = this.width;
            int h = this.height;
            g.rotate(angle, this.point1.x + w / 2, this.point1.y + h / 2);
        }
    }

    public void render(Graphics graphics) {
        if (this.getNeedToRegenerate() || this.getNeedToReposition() || !this.isVisible()) {
            if (this.DEBUG) {
                logger.fine("OMRasterObject.render(): need to regenerate or not visible!");
            }
            return;
        }
        Graphics g = graphics.create();
        if (this.colorModel == 2 && this.getWidth() == -1) {
            logger.fine("OMRasterObject.render: Attempting to draw a Image that is not ready! Image probably wasn't available.");
        }
        if (g instanceof Graphics2D && this.renderRotationAngle != null) {
            this.rotate((Graphics2D)g);
        }
        this.renderImage(g, this.bitmap, this.point1);
        if (this.isSelected() || logger.isLoggable(Level.FINER)) {
            this.renderShape(g);
        }
        this.renderLabel(graphics);
    }

    protected void renderImage(Graphics g, Image image, Point loc) {
        if (image != null) {
            if (this.DEBUG) {
                logger.fine("drawing " + this.width + "x" + this.height + " image at " + loc.x + ", " + loc.y);
            }
            if (g instanceof Graphics2D && image instanceof RenderedImage) {
                ((Graphics2D)g).drawRenderedImage((RenderedImage)((Object)image), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, loc.x, loc.y));
            } else {
                g.drawImage(image, loc.x, loc.y, this);
            }
        } else if (this.DEBUG) {
            logger.fine("ignoring null bitmap image");
        }
    }

    public void setShape() {
        int w = this.width;
        int h = this.height;
        if (this.imageFilter != null) {
            w = this.filteredWidth;
            h = this.filteredHeight;
        }
        GeneralPath projectedShape = OMRasterObject.createBoxShape(this.point1.x, this.point1.y, w, h);
        double anchorX = this.point1.x + w / 2;
        double anchorY = this.point1.y + h / 2;
        this.setShape(this.adjustShapeForRotation(projectedShape, anchorX, anchorY));
    }

    protected GeneralPath adjustShapeForRotation(GeneralPath projectedShape, double anchorX, double anchorY) {
        if (this.renderRotationAngle != null) {
            AffineTransform at = new AffineTransform();
            at.rotate(this.rotationAngle, anchorX, anchorY);
            PathIterator pi = projectedShape.getPathIterator(at);
            GeneralPath rotPath = new GeneralPath();
            rotPath.append(pi, false);
            return rotPath;
        }
        return projectedShape;
    }

    protected boolean position(Projection proj) {
        if (proj == null) {
            logger.fine("OMRasterObject: null projection in position!");
            return false;
        }
        this.projWidth = proj.getWidth();
        this.projHeight = proj.getHeight();
        switch (this.renderType) {
            case 1: {
                if (!proj.isPlotable(this.lat, this.lon)) {
                    if (this.DEBUG) {
                        logger.fine("OMRasterObject: point is not plotable!");
                    }
                    this.setNeedToReposition(true);
                    return false;
                }
                this.point1 = (Point)proj.forward(this.lat, this.lon, (Point2D)new Point());
                break;
            }
            case 2: {
                this.point1 = new Point(this.x, this.y);
                break;
            }
            case 3: {
                if (!proj.isPlotable(this.lat, this.lon)) {
                    if (this.DEBUG) {
                        logger.fine("OMRasterObject: point is not plotable!");
                    }
                    this.setNeedToReposition(true);
                    return false;
                }
                this.point1 = (Point)proj.forward(this.lat, this.lon, (Point2D)new Point());
                this.point1.x += this.x;
                this.point1.y += this.y;
                break;
            }
            case 0: {
                if (this.DEBUG) {
                    logger.fine("OMRasterObject.position(): ignoring unknown rendertype, wingin' it");
                }
                if (this.lat == 0.0 && this.lon == 0.0) {
                    if (this.x == 0 && this.y == 0) {
                        if (this.DEBUG) {
                            logger.fine("OMRasterObject.position(): Not enough info in object to place it reasonably.");
                        }
                        this.point1 = new Point(-this.width, -this.height);
                        this.point2 = new Point(0, 0);
                        return false;
                    }
                    this.point1 = new Point(this.x, this.y);
                    break;
                }
                if (!proj.isPlotable(this.lat, this.lon)) {
                    logger.fine("OMRasterObject: point is not plotable!");
                    return false;
                }
                this.point1 = (Point)proj.forward(this.lat, this.lon, (Point2D)new Point());
            }
        }
        this.point2 = new Point(0, 0);
        this.point2.x = this.point1.x + this.width;
        this.point2.y = this.point1.y + this.height;
        this.setNeedToReposition(false);
        return true;
    }

    public void setImage(Image ii) {
        if (ii == null) {
            logger.fine("OMRasterObject.setImage(): image is null!");
            return;
        }
        this.colorModel = 2;
        this.bitmap = ii;
        if (this.bitmap instanceof BufferedImage) {
            this.width = ((BufferedImage)this.bitmap).getWidth();
            this.height = ((BufferedImage)this.bitmap).getHeight();
        } else {
            this.width = this.bitmap.getWidth(this);
            this.height = this.bitmap.getHeight(this);
        }
        if (!(ii instanceof RenderedImage)) {
            Toolkit.getDefaultToolkit().prepareImage(this.bitmap, -1, -1, this);
        }
    }

    public boolean regenerate(Projection proj) {
        boolean ret = super.regenerate(proj);
        if (proj != null && !ret) {
            ret = this.generate(proj);
        }
        return ret;
    }

    public Image getImage() {
        return this.bitmap;
    }

    public boolean shouldRenderFill() {
        return true;
    }

    public void setPixels(int[] values) {
        if (values.length != this.height * this.width) {
            logger.fine("OMRasterObject: new pixel[] size (" + values.length + ") doesn't" + " match [height*width (" + this.height * this.width + ")]");
        }
        this.pixels = values;
        this.setNeedToRegenerate(true);
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setX(int value) {
        if (this.x == value) {
            return;
        }
        this.x = value;
        this.setNeedToReposition(true);
    }

    public int getX() {
        return this.x;
    }

    public void setY(int value) {
        if (this.y == value) {
            return;
        }
        this.y = value;
        this.setNeedToReposition(true);
    }

    public int getY() {
        return this.y;
    }

    public Point getMapLocation() {
        return this.point1;
    }

    public void setLat(double value) {
        if (this.lat == value) {
            return;
        }
        this.lat = value;
        this.setNeedToReposition(true);
    }

    public double getLat() {
        return this.lat;
    }

    public void setLon(double value) {
        if (this.lon == value) {
            return;
        }
        this.lon = value;
        this.setNeedToReposition(true);
    }

    public double getLon() {
        return this.lon;
    }

    public void setHeight(int value) {
        if (this.height == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.height = value;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFilteredHeight() {
        return this.filteredHeight;
    }

    public void setWidth(int value) {
        if (this.width == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.width = value;
    }

    public int getWidth() {
        return this.width;
    }

    public int getFilteredWidth() {
        return this.filteredWidth;
    }

    public void setBits(byte[] values) {
        this.setNeedToRegenerate(true);
        this.bits = values;
    }

    public byte[] getBits() {
        return this.bits;
    }

    public void setImageFilter(ImageFilter filter) {
        this.imageFilter = filter;
        this.filteredWidth = this.width;
        this.filteredHeight = this.height;
        this.setNeedToRegenerate(true);
    }

    public ImageFilter getImageFilter() {
        return this.imageFilter;
    }

    public void scaleTo(int w, int h, int algorithmType) {
        this.filteredWidth = w;
        this.filteredHeight = h;
        this.imageFilter = new TrimScaleFilter(this.filteredWidth, this.filteredHeight, algorithmType);
        this.setNeedToRegenerate(true);
    }

    protected Image filterImage(Image image) {
        ImageFilter iImageFilter = this.imageFilter;
        if (iImageFilter instanceof TrimScaleFilter) {
            TrimScaleFilter tf = (TrimScaleFilter)iImageFilter;
            Image img = tf.trimExcessPixels();
            if (img != null) {
                image = img;
                iImageFilter = tf.getFilterWithChanges();
                if (this.point1.x < 0) {
                    this.point1.x = 0;
                }
                if (this.point1.y < 0) {
                    this.point1.y = 0;
                }
                if (this.DEBUG) {
                    logger.fine("OMRasterObject: newly located at " + this.point1);
                }
            } else if (this.DEBUG) {
                logger.fine("OMRasterObject: not being trimmed due to projection");
            }
        }
        if (Toolkit.getDefaultToolkit() != null && image != null && iImageFilter != null) {
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), iImageFilter);
            return Toolkit.getDefaultToolkit().createImage(prod);
        }
        return image;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0 && this.colorModel == 2) {
            this.setImage(img);
        }
        if ((infoflags & 1) != 0) {
            this.width = width;
        }
        if ((infoflags & 2) != 0) {
            this.height = height;
        }
        return this.bitmap == null || this.width <= 0 || this.height <= 0;
    }

    private void writeObject(ObjectOutputStream objectstream) throws IOException {
        objectstream.defaultWriteObject();
        PixelGrabber grabber = new PixelGrabber(this.bitmap, 0, 0, -1, -1, true);
        if (this.colorModel == 2 && this.bitmap != null) {
            try {
                grabber.grabPixels();
            }
            catch (InterruptedException e) {
                logger.fine("error grabbing pixels");
            }
            Object pix = grabber.getPixels();
            Dimension dim = new Dimension(this.bitmap.getWidth(this), this.bitmap.getHeight(this));
            objectstream.writeObject(dim);
            objectstream.writeObject(pix);
        }
    }

    private void readObject(ObjectInputStream objectstream) throws IOException, ClassNotFoundException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            objectstream.defaultReadObject();
            if (this.colorModel == 2) {
                Dimension dim = (Dimension)objectstream.readObject();
                Object img = objectstream.readObject();
                int[] pix = (int[])img;
                this.bitmap = toolkit.createImage(new MemoryImageSource(dim.width, dim.height, pix, 0, dim.width));
                this.setImage(this.bitmap);
            }
        }
        catch (ClassNotFoundException ce) {
            System.out.println("class not found");
        }
    }

    public boolean hasLineTypeChoice() {
        return false;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMRasterObject) {
            OMRasterObject rasterO = (OMRasterObject)source;
            this.colorModel = rasterO.colorModel;
            this.pixels = DeepCopyUtil.deepCopy(rasterO.pixels);
            this.x = rasterO.x;
            this.y = rasterO.y;
            this.lat = rasterO.lat;
            this.lon = rasterO.lon;
            this.width = rasterO.width;
            this.height = rasterO.height;
            this.bits = DeepCopyUtil.deepCopy(rasterO.bits);
            this.filteredWidth = rasterO.filteredWidth;
            this.filteredHeight = rasterO.filteredHeight;
            this.rotationAngle = rasterO.rotationAngle;
            this.imageFilter = rasterO.imageFilter;
        }
    }

    protected class TrimScaleFilter
    extends AreaAveragingScaleFilter {
        ImageFilter actualFilter;
        int algorithmType;

        public TrimScaleFilter(int width, int height) {
            super(width, height);
            this.actualFilter = null;
            this.algorithmType = 1;
        }

        protected TrimScaleFilter(int width, int height, int algorithmType) {
            super(width, height);
            this.actualFilter = null;
            this.algorithmType = algorithmType;
        }

        public void setHints(int hints) {
            int passthrough = hints;
            if (this.algorithmType == 1) {
                passthrough = hints ^ 2;
            }
            super.setHints(passthrough);
        }

        protected ImageFilter getFilterWithChanges() {
            if (this.actualFilter == null) {
                return this;
            }
            return this.actualFilter;
        }

        protected Image trimExcessPixels() {
            PixelGrabber pg;
            int[] pix;
            int endYPixelInSource;
            if (OMRasterObject.this.filteredWidth <= OMRasterObject.this.width && OMRasterObject.this.filteredHeight <= OMRasterObject.this.height) {
                if (OMRasterObject.this.DEBUG) {
                    logger.fine("TrimScaleFilter.trimExcessPixels(): image not enlarged, using entire image.");
                }
                return null;
            }
            if (OMRasterObject.this.DEBUG) {
                logger.fine("TrimScaleFilter.trimExcessPixels(): clipping enlarged image.");
            }
            float widthScale = (float)OMRasterObject.this.filteredWidth / (float)OMRasterObject.this.width;
            float heightScale = (float)OMRasterObject.this.filteredHeight / (float)OMRasterObject.this.height;
            int startXPixelInSource = OMRasterObject.this.point1.x < 0 ? (int)(-1.0 * (double)OMRasterObject.this.point1.x / (double)widthScale) : 0;
            int startYPixelInSource = OMRasterObject.this.point1.y < 0 ? (int)((float)(-1 * OMRasterObject.this.point1.y) / heightScale) : 0;
            Point scaledDim = new Point((int)((float)OMRasterObject.this.point1.x + (float)OMRasterObject.this.width * widthScale), (int)((float)OMRasterObject.this.point1.y + (float)OMRasterObject.this.height * heightScale));
            int endXPixelInSource = scaledDim.x > OMRasterObject.this.projWidth ? (int)((float)(OMRasterObject.this.projWidth - OMRasterObject.this.point1.x) / widthScale) + 1 : OMRasterObject.this.width;
            int n = endYPixelInSource = scaledDim.y > OMRasterObject.this.projHeight ? (int)((float)(OMRasterObject.this.projHeight - OMRasterObject.this.point1.y) / heightScale) + 1 : OMRasterObject.this.height;
            if (OMRasterObject.this.DEBUG) {
                logger.fine("TrimScaleFilter.trimExcessPixels(): image contributes " + startXPixelInSource + ", " + startYPixelInSource + " to " + endXPixelInSource + ", " + endYPixelInSource);
            }
            if (OMRasterObject.this.DEBUG) {
                logger.fine("TrimScaleFilter.trimExcessPixels():  new dimensions of scaled image " + (int)((float)(endXPixelInSource - startXPixelInSource) * widthScale) + ", " + (int)((float)(endYPixelInSource - startYPixelInSource) * heightScale));
            }
            if ((pix = ImageHelper.grabPixels(pg = new PixelGrabber(OMRasterObject.this.bitmap, startXPixelInSource, startYPixelInSource, endXPixelInSource - startXPixelInSource, endYPixelInSource - startYPixelInSource, true))) == null) {
                return null;
            }
            this.actualFilter = new TrimScaleFilter((int)((float)(endXPixelInSource - startXPixelInSource) * widthScale), (int)((float)(endYPixelInSource - startYPixelInSource) * heightScale), this.algorithmType);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image image = tk.createImage(new MemoryImageSource(endXPixelInSource - startXPixelInSource, endYPixelInSource - startYPixelInSource, pix, 0, endXPixelInSource - startXPixelInSource));
            return image;
        }
    }
}

