/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMRaster;
import java.io.IOException;
import javax.swing.ImageIcon;

public class ESRIPointRecord
extends ESRIRecord {
    protected double x;
    protected double y;
    protected ImageIcon ii;

    public ESRIPointRecord(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public ESRIPointRecord(byte[] b, int off) throws IOException {
        super(b, off);
        int ptr = off + 8;
        int shapeType = ESRIPointRecord.readLEInt(b, ptr);
        ptr += 4;
        if (shapeType != 1) {
            throw new IOException("Invalid point record.  Expected shape type 1 but found " + shapeType);
        }
        this.x = ESRIPointRecord.readLEDouble(b, ptr);
        this.y = ESRIPointRecord.readLEDouble(b, ptr += 8);
        ptr += 8;
    }

    public ESRIPointRecord(byte[] b, int off, ImageIcon imageIcon) throws IOException {
        super(b, off);
        int ptr = off + 8;
        int shapeType = ESRIPointRecord.readLEInt(b, ptr);
        ptr += 4;
        if (shapeType != 1 && shapeType != 0) {
            throw new IOException("Invalid point record.  Expected shape type 1 but found " + shapeType);
        }
        this.x = ESRIPointRecord.readLEDouble(b, ptr);
        this.y = ESRIPointRecord.readLEDouble(b, ptr += 8);
        ptr += 8;
        this.ii = imageIcon;
    }

    public ESRIBoundingBox getBoundingBox() {
        return new ESRIBoundingBox(this.x, this.y);
    }

    public int getRecordLength() {
        return 20;
    }

    public int write(byte[] b, int off) {
        int nBytes = super.write(b, off);
        nBytes += ESRIPointRecord.writeLEInt(b, off + nBytes, 1);
        nBytes += ESRIPointRecord.writeLEDouble(b, off + nBytes, this.x);
        nBytes += ESRIPointRecord.writeLEDouble(b, off + nBytes, this.y);
        return nBytes;
    }

    public void addOMGraphics(OMGraphicList list, DrawingAttributes drawingAttributes) {
        if (this.ii == null) {
            OMPoint r = new OMPoint((float)this.y, (float)this.x);
            if (drawingAttributes != null) {
                drawingAttributes.setTo(r);
            }
            list.add(r);
            r.setAppObject(new Integer(this.getRecordNumber()));
        } else {
            list.add(new OMRaster((double)((float)this.y), (double)((float)this.x), -this.ii.getIconWidth() / 2, -this.ii.getIconHeight() / 2, this.ii));
        }
    }

    public OMGeometry addOMGeometry(OMGeometryList list) {
        return null;
    }

    public int getShapeType() {
        return 1;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }
}

