/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.InfoDisplayListener;
import com.bbn.openmap.event.LayerStatusEvent;
import com.bbn.openmap.event.LayerStatusListener;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.SinkLayer;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleFilterLayer
extends Layer
implements InfoDisplayListener,
LayerStatusListener,
PropertyChangeListener,
MapMouseListener {
    public static final transient String layersProperty = "layers";
    public static final transient String transitionScalesProperty = "transitionScales";
    protected Vector<Layer> layers;
    protected float[] transitionScales;
    protected float defaultTransitionScale = 4.0E7f;
    protected int targetIndex = -1;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.ScaleFilterLayer");
    protected JPanel panel = null;
    protected JTabbedPane tabs = null;
    protected String mmID = null;
    protected boolean coolMM = false;
    protected MapMouseListener clmml = null;

    public ScaleFilterLayer() {
        this.setAddToBeanContext(true);
    }

    public Vector<Layer> getLayers() {
        if (this.layers == null) {
            this.layers = new Vector();
        }
        return this.layers;
    }

    public float[] getTransitionScales() {
        return this.transitionScales;
    }

    public void setLayersAndScales(Vector<Layer> list, float[] scales) {
        this.layers = list;
        this.transitionScales = scales;
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        this.setLayersAndScales(null, null);
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.parseLayers(prefix, props);
        this.parseScales(prefix, props);
        if (this.getProjection() != null) {
            Layer currentLayer = this.configureAppropriateLayer(this.getProjection().getScale());
            this.fireStatusUpdate(8342);
            currentLayer.projectionChanged(new ProjectionEvent(null, this.getProjection()));
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        float[] ts = this.getTransitionScales();
        StringBuffer tsBuffer = new StringBuffer();
        if (ts != null) {
            for (int i = 0; i < ts.length; ++i) {
                tsBuffer.append(Float.toString(ts[i])).append(" ");
            }
        }
        props.put(prefix + transitionScalesProperty, tsBuffer.toString());
        StringBuffer layerBuffer = new StringBuffer();
        for (Layer layer : this.getLayers()) {
            layerBuffer.append(layer.getPropertyPrefix()).append(" ");
            layer.getProperties(props);
        }
        props.put(prefix + layersProperty, layerBuffer.toString());
        return props;
    }

    public Layer getAppropriateLayer() {
        try {
            return this.getLayers().elementAt(this.targetIndex);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return SinkLayer.getSharedInstance();
    }

    protected void parseLayers(String prefix, Properties props) {
        PropUtils.putDataPrefixToLayerList(this, props, prefix + layersProperty);
        String layersString = props.getProperty(prefix + layersProperty);
        Vector<Layer> layers = this.getLayers();
        if (layersString == null || layersString.length() == 0) {
            logger.info("ScaleFilterLayer(): null layersString!");
            return;
        }
        StringTokenizer tok = new StringTokenizer(layersString);
        while (tok.hasMoreTokens()) {
            SinkLayer obj;
            String layerName = tok.nextToken();
            String classProperty = layerName + ".class";
            String className = props.getProperty(classProperty);
            if (className == null) {
                logger.info("ScaleFilterLayer.parseLayers(): Failed to locate property \"" + classProperty + "\"");
                logger.info("ScaleFilterLayer.parseLayers(): Skipping layer \"" + layerName + "\"");
                className = SinkLayer.class.getName();
            }
            try {
                obj = className.equals(SinkLayer.class.getName()) ? SinkLayer.getSharedInstance() : Class.forName(className).newInstance();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Instantiated " + className);
                }
            }
            catch (Exception e) {
                logger.info("Failed to instantiate \"" + className + "\": " + e);
                obj = SinkLayer.getSharedInstance();
            }
            if (!(obj instanceof Layer)) continue;
            Layer l = obj;
            l.setProperties(layerName, props);
            l.addLayerStatusListener(this);
            l.addInfoDisplayListener(this);
            layers.addElement(l);
        }
    }

    protected void parseScales(String prefix, Properties props) {
        StringTokenizer tok = null;
        Vector<Layer> layers = this.getLayers();
        int size = layers.size();
        if (size > 0) {
            --size;
        }
        this.transitionScales = new float[size];
        String scales = props.getProperty(prefix + transitionScalesProperty);
        if (scales == null) {
            logger.info("Failed to locate property \"transitionScales\"");
            if (this.transitionScales.length > 0) {
                this.transitionScales[0] = this.defaultTransitionScale;
            }
            for (int i = 1; i < this.transitionScales.length; ++i) {
                this.transitionScales[i] = this.transitionScales[i - 1] / 3.0f;
            }
            return;
        }
        try {
            tok = new StringTokenizer(scales);
            this.transitionScales[0] = tok.hasMoreTokens() ? new Float(tok.nextToken()).floatValue() : this.defaultTransitionScale;
        }
        catch (NumberFormatException e) {
            logger.info("ScaleFilterLayer.parseScales()1: " + e);
            this.transitionScales[0] = this.defaultTransitionScale;
        }
        if (tok != null) {
            for (int i = 1; i < this.transitionScales.length; ++i) {
                try {
                    this.transitionScales[i] = tok.hasMoreTokens() ? new Float(tok.nextToken()).floatValue() : this.transitionScales[i - 1] / 3.0f;
                    continue;
                }
                catch (NumberFormatException e) {
                    logger.info("ScaleFilterLayer.parseScales()2: " + e);
                    this.transitionScales[i] = this.transitionScales[i - 1] / 3.0f;
                }
            }
        }
    }

    @Override
    public synchronized void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            logger.info("null projection!");
            return;
        }
        this.setTargetIndex(proj.getScale());
        Layer layer = this.getAppropriateLayer();
        layer.renderDataForProjection(proj, g);
    }

    public boolean setTargetIndex(float scale) {
        boolean changed = false;
        float[] target = this.transitionScales;
        int i = 0;
        if (target != null) {
            for (i = 0; i < target.length && !(scale > target[i]); ++i) {
            }
        }
        if (this.targetIndex != i) {
            changed = true;
        }
        this.targetIndex = i;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ScaleFilterLayer(" + this.getName() + ") targetIndex: " + this.targetIndex + ", changed: " + changed);
        }
        return changed;
    }

    @Override
    public void projectionChanged(ProjectionEvent ev) {
        this.setProjection(ev);
        Projection proj = ev.getProjection();
        Layer layer = this.configureAppropriateLayer(proj.getScale());
        this.fireStatusUpdate(8342);
        layer.projectionChanged(ev);
    }

    protected Layer configureAppropriateLayer(float scale) {
        Layer currentLayer = this.getAppropriateLayer();
        boolean changed = this.setTargetIndex(scale);
        Layer layer = this.getAppropriateLayer();
        if (changed) {
            currentLayer.removeNotify();
            this.setPaletteTab(this.targetIndex);
            this.remove(currentLayer);
            this.add(layer);
            layer.addNotify();
            this.checkMouseMode();
        }
        return layer;
    }

    @Override
    public void paint(Graphics g) {
        this.getAppropriateLayer().paint(g);
        this.fireStatusUpdate(8359);
    }

    @Override
    public void updateLayerStatus(LayerStatusEvent evt) {
        this.fireStatusUpdate(evt);
    }

    @Override
    public Component getGUI() {
        if (this.panel == null) {
            Iterator<Layer> it = this.getLayers().iterator();
            this.panel = new JPanel();
            this.tabs = new JTabbedPane();
            JPanel bfPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            bfPanel.setLayout(gridbag);
            this.tabs.addTab("Scale Filter Controls", bfPanel);
            JButton gotoButton = new JButton("Go to Active Layer Tab");
            gotoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ScaleFilterLayer.this.setPaletteTab(ScaleFilterLayer.this.targetIndex);
                }
            });
            c.gridy = 0;
            gridbag.setConstraints(gotoButton, c);
            bfPanel.add(gotoButton);
            while (it.hasNext()) {
                Layer layer = it.next();
                Component layerGUI = layer.getGUI();
                if (layerGUI != null) {
                    this.tabs.addTab(layer.getName(), layerGUI);
                    continue;
                }
                this.tabs.addTab(layer.getName(), this.getEmptyGUIFiller(layer));
            }
            this.panel.add(this.tabs);
        }
        this.setPaletteTab(this.targetIndex);
        return this.panel;
    }

    public Component getEmptyGUIFiller(Layer layer) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(gridbag);
        JLabel label = new JLabel("No properties available for");
        JLabel label2 = new JLabel("the " + layer.getName() + ".");
        c.gridwidth = 0;
        gridbag.setConstraints(label, c);
        gridbag.setConstraints(label2, c);
        panel.add(label);
        panel.add(label2);
        return panel;
    }

    protected void setPaletteTab(int layerIndex) {
        Vector<Layer> layers = this.getLayers();
        if (layers.size() > layerIndex && this.tabs != null && layerIndex < this.tabs.getTabCount()) {
            this.tabs.setSelectedIndex(layerIndex + 1);
        }
    }

    @Override
    public void requestURL(InfoDisplayEvent event) {
        this.fireRequestURL(new InfoDisplayEvent(this, event.getInformation()));
    }

    @Override
    public void requestMessage(InfoDisplayEvent event) {
        this.fireRequestMessage(new InfoDisplayEvent(this, event.getInformation()));
    }

    @Override
    public void requestInfoLine(InfoDisplayEvent event) {
        this.fireRequestInfoLine(new InfoDisplayEvent(this, event.getInformation()));
    }

    @Override
    public void requestBrowserContent(InfoDisplayEvent event) {
        this.fireRequestBrowserContent(new InfoDisplayEvent(this, event.getInformation()));
    }

    @Override
    public void requestCursor(Cursor cursor) {
        this.fireRequestCursor(cursor);
    }

    @Override
    public void requestShowToolTip(InfoDisplayEvent event) {
        this.fireRequestToolTip(new InfoDisplayEvent(this, event.getInformation()));
    }

    @Override
    public void requestHideToolTip() {
        this.fireHideToolTip();
    }

    @Override
    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public synchronized boolean checkMouseMode() {
        this.coolMM = false;
        Layer layer = this.getAppropriateLayer();
        MapMouseListener mml = layer.getMapMouseListener();
        this.setCurrentLayerMapMouseListener(mml);
        if (mml != null) {
            String[] mmsl = mml.getMouseModeServiceList();
            for (int i = 0; i < mmsl.length; ++i) {
                if (mmsl[i].intern() != this.mmID) continue;
                this.coolMM = true;
                break;
            }
        }
        return this.coolMM;
    }

    public void setCurrentLayerMapMouseListener(MapMouseListener mml) {
        this.clmml = mml;
    }

    public MapMouseListener getCurrentLayerMapMouseListener() {
        return this.clmml;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "NewActiveMouseMode") {
            this.mmID = ((MapMouseMode)evt.getNewValue()).getID().intern();
            this.checkMouseMode();
        }
    }

    @Override
    public String[] getMouseModeServiceList() {
        HashSet<String> mmsl = new HashSet<String>();
        for (Layer l : this.getLayers()) {
            MapMouseListener mml = l.getMapMouseListener();
            if (mml == null) continue;
            String[] llist = mml.getMouseModeServiceList();
            for (int i = 0; i < llist.length; ++i) {
                mmsl.add(llist[i].intern());
            }
        }
        String[] rets = new String[mmsl.size()];
        return mmsl.toArray(rets);
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mousePressed(e);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseReleased(e);
        }
        return false;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseClicked(e);
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.coolMM) {
            this.getCurrentLayerMapMouseListener().mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.coolMM) {
            this.getCurrentLayerMapMouseListener().mouseExited(e);
        }
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseDragged(e);
        }
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseMoved(e);
        }
        return false;
    }

    @Override
    public void mouseMoved() {
        if (this.coolMM) {
            this.getCurrentLayerMapMouseListener().mouseMoved();
        }
    }

    @Override
    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        for (Layer layer : this.getLayers()) {
            layer.connectToBeanContext(in_bc);
        }
        super.setBeanContext(in_bc);
    }

    @Override
    public void dispose() {
        BeanContext bc;
        try {
            for (Layer layer : this.getLayers()) {
                layer.disconnectFromBeanContext();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if ((bc = this.getBeanContext()) instanceof MapHandler) {
            MapHandler mh = (MapHandler)bc;
            this.findAndUndo(mh.get(MouseDelegator.class));
        }
        super.dispose();
    }

    @Override
    public void findAndInit(Object obj) {
        super.findAndInit(obj);
        if (obj instanceof MouseDelegator) {
            ((MouseDelegator)obj).addPropertyChangeListener(this);
        }
        for (Layer layer : this.getLayers()) {
            layer.findAndInit(obj);
        }
    }

    @Override
    public void findAndUndo(Object obj) {
        super.findAndUndo(obj);
        if (obj == null) {
            return;
        }
        if (obj instanceof MouseDelegator) {
            ((MouseDelegator)obj).removePropertyChangeListener(this);
        }
        for (Layer layer : this.getLayers()) {
            layer.findAndUndo(obj);
        }
    }
}

