/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EarthquakeLayer
extends OMGraphicHandlerLayer
implements MapMouseListener {
    public static final transient String fingerSitesProperty = "sites";
    public static final transient String queryIntervalProperty = "queryInterval";
    protected String[] fingerSites = new String[]{"scec.gps.caltech.edu", "geophys.washington.edu", "giseis.alaska.edu", "mbmgsun.mtech.edu", "quake.eas.slu.edu"};
    protected boolean[] activeSites = new boolean[this.fingerSites.length];
    private long fetchIntervalMillis = 300000L;
    protected float[] llData = new float[0];
    protected String[] infoData = new String[0];
    protected String[] drillData = new String[0];
    private long lastDataFetchTime = 0L;
    protected Color lineColor = Color.red;
    protected boolean showingInfoLine = false;
    protected JPanel gui = null;

    public EarthquakeLayer() {
        this.activeSites[0] = true;
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public synchronized OMGraphicList prepare() {
        if (this.needToRefetchData()) {
            this.parseData(this.getEarthquakeData());
        }
        return this.generateGraphics();
    }

    protected boolean needToRefetchData() {
        long last = this.lastDataFetchTime;
        long now = System.currentTimeMillis();
        if (last + this.fetchIntervalMillis < now) {
            this.lastDataFetchTime = now;
            return true;
        }
        return false;
    }

    protected OMGraphicList generateGraphics() {
        OMGraphicList omgraphics = new OMGraphicList();
        int circle_r = 2;
        int circle_h = 5;
        int i = 0;
        int j = 0;
        while (i < this.llData.length) {
            OMGraphicList group = new OMGraphicList(2);
            OMPoint circ = new OMPoint(this.llData[i], this.llData[i + 1], circle_r);
            circ.setOval(true);
            circ.setFillPaint(this.lineColor);
            group.add(circ);
            OMText text = new OMText(this.llData[i], this.llData[i + 1], 0.0f, circle_h + 10, this.infoData[j], Font.decode("SansSerif"), 1);
            text.setLinePaint(this.lineColor);
            group.add(text);
            group.setAppObject(new Integer(j));
            omgraphics.add(group);
            i += 2;
            ++j;
        }
        omgraphics.generate(this.getProjection(), false);
        return omgraphics;
    }

    protected void parseData(Vector data) {
        int nLines = data.size();
        this.llData = new float[2 * nLines];
        this.infoData = new String[nLines];
        this.drillData = new String[nLines];
        int j = 0;
        int k = 0;
        for (int i = 0; i < nLines; ++i) {
            String sdep;
            String line = (String)data.elementAt(i);
            StringTokenizer tokens = new StringTokenizer(line);
            String sdate = tokens.nextToken();
            String stime = tokens.nextToken();
            String slat = tokens.nextToken();
            String slon = tokens.nextToken();
            if (slon.startsWith("NWSE")) {
                slon = tokens.nextToken();
            }
            if ((sdep = tokens.nextToken()).startsWith("NWSE")) {
                sdep = tokens.nextToken();
            }
            String smag = tokens.nextToken();
            String q = tokens.nextToken();
            String scomment = tokens.nextToken("\r\n");
            if (q.length() > 1) {
                scomment = q + " " + scomment;
            }
            this.infoData[j] = smag;
            this.drillData[j++] = sdate + " " + stime + " (UTC)  " + slat + " " + slon + " " + smag + " " + scomment;
            int west = slon.indexOf("W");
            int south = slat.indexOf("S");
            slon = west >= 0 ? slon.replace('W', '\u0000') : slon.replace('E', '\u0000');
            slat = south >= 0 ? slat.replace('S', '\u0000') : slat.replace('N', '\u0000');
            slon = slon.trim();
            slat = slat.trim();
            float flat = 0.0f;
            float flon = 0.0f;
            try {
                flat = new Float(slat).floatValue();
                flon = new Float(slon).floatValue();
            }
            catch (NumberFormatException e) {
                Debug.error("EarthquakeLayer.parseData(): " + e + " line: " + line);
            }
            if (south >= 0) {
                flat = -flat;
            }
            if (west >= 0) {
                flon = -flon;
            }
            this.llData[k++] = flat;
            this.llData[k++] = flon;
        }
    }

    protected Vector getEarthquakeData() {
        Vector<String> linesOfData = new Vector<String>();
        Socket quakefinger = null;
        PrintWriter output = null;
        BufferedReader input = null;
        for (int i = 0; i < this.activeSites.length; ++i) {
            if (!this.activeSites[i]) continue;
            try {
                if (Debug.debugging("earthquake")) {
                    Debug.output("Opening socket connection to " + this.fingerSites[i]);
                }
                quakefinger = new Socket(this.fingerSites[i], 79);
                quakefinger.setSoTimeout(120000);
                output = new PrintWriter((Writer)new OutputStreamWriter(quakefinger.getOutputStream()), true);
                input = new BufferedReader(new InputStreamReader(quakefinger.getInputStream()), 1);
                output.println("/W quake");
            }
            catch (IOException e) {
                Debug.error("EarthquakeLayer.getEarthquakeData(): can't open or write to socket: " + e);
                continue;
            }
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    if (Debug.debugging("earthquake")) {
                        Debug.output("EarthquakeLayer.getEarthQuakeData(): " + line);
                    }
                    if (line.length() == 0 || !Character.isDigit(line.charAt(0)) || (line = this.hackY2K(line)) == null) continue;
                    linesOfData.addElement(line);
                }
            }
            catch (IOException e) {
                Debug.error("EarthquakeLayer.getEarthquakeData(): can't read from the socket: " + e);
            }
            try {
                if (quakefinger == null) continue;
                quakefinger.close();
                continue;
            }
            catch (IOException e) {
                Debug.error("EarthquakeLayer.getEarthquakeData(): error closing socket: " + e);
            }
        }
        return linesOfData;
    }

    private String hackY2K(String date) {
        String day;
        String month;
        String year;
        StringTokenizer tok = new StringTokenizer(date, "/");
        try {
            year = tok.nextToken();
            month = tok.nextToken();
            day = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            Debug.error("EarthquakeLayer: unparsable date: " + date);
            return null;
        }
        if (year.length() == 2) {
            int y;
            try {
                y = Integer.parseInt(year);
            }
            catch (NumberFormatException e) {
                Debug.error("EarthquakeLayer: invalid year: " + year);
                return null;
            }
            date = y > 70 ? "19" : "20";
        } else if (year.length() != 4) {
            Debug.error("EarthquakeLayer: unparsable year: " + year);
            return null;
        }
        date = date + year + "/" + month + "/" + day;
        return date;
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = PaletteHelper.createVerticalPanel("Earthquakes");
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.gui.setLayout(gridbag);
            constraints.fill = 2;
            constraints.gridwidth = 0;
            constraints.anchor = 13;
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = Integer.parseInt(e.getActionCommand(), 10);
                    EarthquakeLayer.this.activeSites[index] = !EarthquakeLayer.this.activeSites[index];
                }
            };
            JPanel p = PaletteHelper.createCheckbox("Sites", this.fingerSites, this.activeSites, al);
            gridbag.setConstraints(p, constraints);
            this.gui.add(p);
            JButton b = new JButton("Query Now");
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EarthquakeLayer.this.lastDataFetchTime = 0L;
                    EarthquakeLayer.this.doPrepare();
                }
            });
            gridbag.setConstraints(p, constraints);
            this.gui.add(b);
        }
        return this.gui;
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{"Gestures"};
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        OMGraphic obj;
        OMGraphicList omgraphics = this.getList();
        if (omgraphics != null && this.drillData != null && (obj = (OMGraphic)omgraphics.findClosest(e.getX(), e.getY(), 4.0f)) != null) {
            int id = (Integer)obj.getAppObject();
            this.fireRequestInfoLine(this.drillData[id]);
            this.showingInfoLine = true;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.showingInfoLine) {
            this.showingInfoLine = false;
            this.fireRequestInfoLine("");
        }
        return false;
    }

    public void mouseMoved() {
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String sites = props.getProperty(prefix + fingerSitesProperty);
        if (sites != null) {
            Vector<String> v = new Vector<String>();
            StringTokenizer tok = new StringTokenizer(sites);
            while (tok.hasMoreTokens()) {
                String str = tok.nextToken();
                v.addElement(str);
            }
            int len = v.size();
            this.fingerSites = new String[len];
            this.activeSites = new boolean[len];
            this.activeSites[0] = true;
            for (int i = 0; i < len; ++i) {
                this.fingerSites[i] = (String)v.elementAt(i);
            }
        }
        this.fetchIntervalMillis = PropUtils.intFromProperties(props, prefix + queryIntervalProperty, 300) * 1000;
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        return this.getProperties(this.propertyPrefix, props);
    }

    public Properties getProperties(String prefix, Properties props) {
        props = super.getProperties(props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        StringBuffer sitesToFinger = new StringBuffer("");
        for (int i = 0; i < this.fingerSites.length; ++i) {
            sitesToFinger.append(this.fingerSites[i]);
            sitesToFinger.append(" ");
        }
        sitesToFinger.deleteCharAt(sitesToFinger.length() - 1);
        props.put(prefix + fingerSitesProperty, sitesToFinger.toString());
        props.put(prefix + queryIntervalProperty, Long.toString(this.fetchIntervalMillis));
        return props;
    }

    public Properties getPropertyInfo(Properties info) {
        info = super.getPropertyInfo(info);
        info.put(fingerSitesProperty, "WWW sites to finger");
        info.put(queryIntervalProperty, "Query interval in seconds");
        return info;
    }
}

