/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.GeoRegion;
import com.bbn.openmap.geo.GeoSegment;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.geo.MatchCollector;
import com.bbn.openmap.geo.MatchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BoundaryCrossing {
    protected Geo geo;
    protected GeoRegion in;
    protected GeoRegion out;

    protected BoundaryCrossing(Geo p, GeoRegion r, boolean goinin) {
        this.geo = p;
        if (goinin) {
            this.in = r;
        } else {
            this.out = r;
        }
    }

    public Geo getGeo() {
        return this.geo;
    }

    public GeoRegion getIn() {
        return this.in;
    }

    public GeoRegion getOut() {
        return this.out;
    }

    public static Collector getCrossings(GeoPath path, Collection regions) {
        Collector collector = new Collector();
        CrossingIntersection crossings = new CrossingIntersection(collector);
        crossings.consider(path, regions);
        return collector;
    }

    public static class CrossingIntersection
    extends Intersection {
        public CrossingIntersection(Collector collector) {
            super(new MatchFilter.ExactMF(), collector);
        }

        public boolean considerSegmentXRegion(GeoSegment segment, GeoRegion region) {
            List hits = Intersection.segmentNearPoly(segment, region.getPoints(), 0.0);
            if (hits != null) {
                ((Collector)this.collector).addCrossing(hits, segment, region);
                return true;
            }
            return false;
        }
    }

    public static class Collector
    extends MatchCollector.SetMatchCollector {
        List crossings = new ArrayList(10);
        List lastSegmentCrossingList;
        Geo lastSegmentStartingPoint;

        protected void addCrossing(BoundaryCrossing bc) {
            this.crossings.add(bc);
        }

        protected void addCrossing(Collection c, GeoSegment segment, GeoRegion region) {
            Geo start = segment.getSeg()[0];
            if (this.lastSegmentCrossingList != null && this.lastSegmentStartingPoint.distance(start) > 0.0) {
                this.crossings.addAll(this.lastSegmentCrossingList);
                this.lastSegmentCrossingList.clear();
            } else if (this.lastSegmentCrossingList == null) {
                this.lastSegmentCrossingList = new ArrayList(10);
            }
            LinkedList<BoundaryCrossing> orderedList = new LinkedList<BoundaryCrossing>();
            orderedList.addAll(this.lastSegmentCrossingList);
            this.lastSegmentCrossingList.clear();
            for (Geo current : c) {
                double curDist = start.distance(current);
                BoundaryCrossing currentBC = new BoundaryCrossing(current, region, true);
                int lastCheckedIndex = 0;
                BoundaryCrossing lastChecked2 = null;
                for (BoundaryCrossing lastChecked2 : orderedList) {
                    if (curDist < start.distance(lastChecked2.geo)) break;
                    lastChecked2 = null;
                    ++lastCheckedIndex;
                }
                if (lastChecked2 != null) {
                    orderedList.add(lastCheckedIndex, currentBC);
                    continue;
                }
                orderedList.add(currentBC);
            }
            boolean goinin = !Intersection.isPointInPolygon(start, region.getPoints());
            for (BoundaryCrossing bc : orderedList) {
                boolean sameRegion;
                boolean bl = sameRegion = bc.in == region;
                if (sameRegion) {
                    if (!goinin) {
                        bc.out = bc.in;
                    }
                    goinin = !goinin;
                }
                this.lastSegmentCrossingList.add(bc);
            }
            this.lastSegmentStartingPoint = start;
        }

        protected void compact() {
            if (this.lastSegmentCrossingList != null && !this.lastSegmentCrossingList.isEmpty()) {
                this.crossings.addAll(this.lastSegmentCrossingList);
                this.lastSegmentCrossingList.clear();
                this.lastSegmentCrossingList = null;
            }
            Object[] bc = this.crossings.toArray();
            this.crossings = new ArrayList(bc.length);
            BoundaryCrossing previous = null;
            for (int i = 0; i < bc.length; ++i) {
                BoundaryCrossing current = (BoundaryCrossing)bc[i];
                if (previous != null && previous.geo.distance(current.geo) == 0.0) {
                    if (previous.out != null) {
                        previous.in = current.in;
                    }
                    if (current.out == null) continue;
                    previous.out = current.out;
                    continue;
                }
                if (current.out != null) {
                    current.in = null;
                }
                this.crossings.add(current);
                previous = current;
            }
        }

        public Iterator getCrossings() {
            this.compact();
            return this.crossings.iterator();
        }
    }
}

