/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.I18n;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BasicI18n
implements I18n,
Serializable {
    public static final String DEBUG = "i18n";
    public static final String DEBUG_CREATE = "i18n.create";
    public static final String DEBUG_CREATE_DEFAULT = "i18n.default";
    public static final String ResourceFileNamePrefix = "I18N";
    private Locale loc;
    protected transient Hashtable createHash = null;

    public BasicI18n() {
        this(Locale.getDefault());
    }

    public BasicI18n(Locale loc) {
        this.loc = loc;
    }

    public String get(Object requestor, String field, String defaultString) {
        return this.get(requestor, field, 1, defaultString);
    }

    public String get(Object requestor, String field, int type, String defaultString) {
        return this.get(requestor.getClass(), field, type, defaultString);
    }

    public String get(Class requestor, String field, String defaultString) {
        return this.get(requestor, field, 1, defaultString);
    }

    public String get(Class requestor, String field, int type, String defaultString) {
        String ret = this.getInternal(requestor, field, type);
        if (Debug.debugging(DEBUG_CREATE)) {
            this.setForBundleCreation(requestor, field, type, defaultString);
        }
        if (ret == null) {
            return defaultString;
        }
        return ret;
    }

    protected Hashtable getCreateHash() {
        if (this.createHash == null) {
            this.createHash = new Hashtable();
        }
        return this.createHash;
    }

    public String get(Object requestor, String field, String defaultString, Object param1) {
        return this.get(requestor.getClass(), field, 1, defaultString, new Object[]{param1});
    }

    public String get(Object requestor, String field, int type, String defaultString, Object param1) {
        return this.get(requestor.getClass(), field, type, defaultString, new Object[]{param1});
    }

    public String get(Class requestor, String field, String defaultString, Object param1) {
        return this.get(requestor, field, 1, defaultString, new Object[]{param1});
    }

    public String get(Class requestor, String field, int type, String defaultString, Object param1) {
        return this.get(requestor, field, type, defaultString, new Object[]{param1});
    }

    public String get(Object requestor, String field, String defaultString, Object param1, Object param2) {
        return this.get(requestor.getClass(), field, 1, defaultString, new Object[]{param1, param2});
    }

    public String get(Object requestor, String field, int type, String defaultString, Object param1, Object param2) {
        return this.get(requestor.getClass(), field, type, defaultString, new Object[]{param1, param2});
    }

    public String get(Class requestor, String field, String defaultString, Object param1, Object param2) {
        return this.get(requestor, field, 1, defaultString, new Object[]{param1, param2});
    }

    public String get(Class requestor, String field, int type, String defaultString, Object param1, Object param2) {
        return this.get(requestor, field, type, defaultString, new Object[]{param1, param2});
    }

    public String get(Object requestor, String field, String defaultString, Object[] params) {
        return this.get(requestor.getClass(), field, 1, defaultString, params);
    }

    public String get(Object requestor, String field, int type, String defaultString, Object[] params) {
        return this.get(requestor.getClass(), field, type, defaultString, params);
    }

    public String get(Class requestor, String field, String defaultString, Object[] params) {
        return this.get(requestor, field, 1, defaultString, params);
    }

    public String get(Class requestor, String field, int type, String defaultString, Object[] params) {
        return MessageFormat.format(this.get(requestor, field, type, defaultString), params);
    }

    public void set(Object requestor, String field, JLabel comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setDisplayedMnemonic(this.getMNEMONIC(requestor, field, comp.getDisplayedMnemonic(), false));
    }

    public void set(Object requestor, String field, JButton comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setMnemonic(this.getMNEMONIC(requestor, field, comp.getMnemonic(), false));
    }

    public void set(Object requestor, String field, JMenu comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setMnemonic(this.getMNEMONIC(requestor, field, comp.getMnemonic(), true));
    }

    public void set(Object requestor, String field, JMenuItem comp) {
        this.set(requestor, field, (JComponent)comp);
        comp.setText(this.getTEXT(requestor, field, comp.getText()));
        comp.setMnemonic(this.getMNEMONIC(requestor, field, comp.getMnemonic(), true));
    }

    public void set(Object requestor, String field, JDialog comp) {
        comp.setTitle(this.getTITLE(requestor, field, comp.getTitle()));
    }

    public void set(Object requestor, String field, JFrame comp) {
        comp.setTitle(this.getTITLE(requestor, field, comp.getTitle()));
    }

    public void set(Object requestor, String field, JComponent comp) {
        this.setTOOLTIP(requestor, field, comp);
        Border b = comp.getBorder();
        if (b instanceof TitledBorder) {
            TitledBorder t = (TitledBorder)b;
            t.setTitle(this.getTITLE(requestor, field, t.getTitle()));
        }
    }

    public void set(Object requestor, String field) {
        Class<?> c = requestor.getClass();
        Field f = null;
        try {
            f = c.getField(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException e) {
            MissingResourceException r = new MissingResourceException("SecurityException trying to reflect on field field", c.getName(), field);
            r.initCause(e);
            throw r;
        }
        if (f == null) {
            try {
                f = c.getDeclaredField(field);
            }
            catch (NoSuchFieldException e) {
                MissingResourceException r = new MissingResourceException("Can't find field via reflection", c.getName(), field);
                r.initCause(e);
                throw r;
            }
            catch (SecurityException e) {
                MissingResourceException r = new MissingResourceException("SecurityException trying to reflect on field field", c.getName(), field);
                r.initCause(e);
                throw r;
            }
        }
        try {
            f.setAccessible(true);
        }
        catch (SecurityException e) {
            Debug.message(DEBUG, "Couldn't set field " + field + " accessible");
        }
        Class<?> type = f.getType();
        Object fd = null;
        try {
            fd = f.get(requestor);
        }
        catch (IllegalArgumentException e) {
            MissingResourceException r = new MissingResourceException("Couldn't get field", c.getName(), field);
            r.initCause(e);
            throw r;
        }
        catch (IllegalAccessException e) {
            MissingResourceException r = new MissingResourceException("Couldn't access field", c.getName(), field);
            r.initCause(e);
            throw r;
        }
        if (JLabel.class.isInstance(type)) {
            this.set(requestor, field, (JLabel)fd);
        } else if (JButton.class.isInstance(type)) {
            this.set(requestor, field, (JButton)fd);
        } else if (JMenu.class.isInstance(type)) {
            this.set(requestor, field, (JMenu)fd);
        } else if (JMenuItem.class.isInstance(type)) {
            this.set(requestor, field, (JMenuItem)fd);
        } else if (JDialog.class.isInstance(type)) {
            this.set(requestor, field, (JDialog)fd);
        } else if (JFrame.class.isInstance(type)) {
            this.set(requestor, field, (JFrame)fd);
        } else if (JComponent.class.isInstance(type)) {
            this.set(requestor, field, (JComponent)fd);
        } else {
            Debug.message(DEBUG, "Couldn't assign data for unknown type: " + type);
        }
    }

    public void fill(Object requestor) {
    }

    protected void setTOOLTIP(Object requestor, String field, JComponent comp) {
        String tooltip = this.get(requestor, field, 3, comp.getToolTipText());
        if (tooltip != null) {
            comp.setToolTipText(tooltip);
        } else {
            Debug.message(DEBUG, "No tooltip for: " + BasicI18n.getKeyRef(requestor, field));
        }
    }

    protected String getTEXT(Object requestor, String field, String defaultString) {
        String text = this.get(requestor, field, 1, defaultString);
        if (text == null) {
            throw new MissingResourceException("No TEXT resource", requestor.getClass().getName(), field);
        }
        return text;
    }

    protected String getTITLE(Object requestor, String field, String defaultString) {
        String title = this.get(requestor, field, 2, defaultString);
        if (title == null) {
            throw new MissingResourceException("No TITLE resource", requestor.getClass().getName(), field);
        }
        return title;
    }

    protected int getMNEMONIC(Object requestor, String field, int defaultInt, boolean verbose) {
        String mn = this.get(requestor, field, 4, Character.toString((char)defaultInt));
        if (mn == null) {
            if (verbose) {
                Debug.message(DEBUG, "No MNEMONIC resource for " + BasicI18n.getKeyRef(requestor, field));
            }
            return defaultInt;
        }
        return Character.getNumericValue(mn.charAt(0));
    }

    protected String getInternal(Class requestor, String field, int type) {
        ResourceBundle bundle = null;
        Package pckg = requestor.getPackage();
        String bString = (pckg == null ? "" : requestor.getPackage().getName() + ".") + ResourceFileNamePrefix;
        try {
            bundle = ResourceBundle.getBundle(bString, this.loc);
        }
        catch (MissingResourceException e) {
            Debug.message(DEBUG, "Could not locate resource: " + bString.replace('.', '/') + ".properties");
            return null;
        }
        String key = BasicI18n.shortClassName(requestor) + "." + field;
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                key = key + ".title";
                break;
            }
            case 3: {
                key = key + ".tooltip";
                break;
            }
            case 4: {
                key = key + ".mnemonic";
            }
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            Debug.message(DEBUG, "Could not locate string in resource: " + (pckg == null ? "" : requestor.getPackage().getName().replace('.', '/') + ".") + "properties for key: " + key);
            return null;
        }
    }

    protected void setForBundleCreation(Class requestor, String field, int type, String defaultString) {
        ResourceBundle bundle = null;
        Package pckg = requestor.getPackage();
        String bString = (pckg == null ? "" : requestor.getPackage().getName() + ".") + ResourceFileNamePrefix;
        String propertyFileNameKey = null;
        Properties propertyFileProperties = null;
        StringBuffer sbuf = new StringBuffer(bString.replace('.', '/'));
        if (!Debug.debugging(DEBUG_CREATE_DEFAULT)) {
            sbuf.append("_").append(this.loc.toString());
        }
        sbuf.append(".properties");
        propertyFileNameKey = sbuf.toString().intern();
        propertyFileProperties = (Properties)this.getCreateHash().get(propertyFileNameKey);
        if (propertyFileProperties == null) {
            propertyFileProperties = new Properties();
            this.getCreateHash().put(propertyFileNameKey, propertyFileProperties);
        }
        try {
            bundle = ResourceBundle.getBundle(bString, this.loc);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String resourceKey = BasicI18n.shortClassName(requestor) + "." + field;
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                resourceKey = resourceKey + ".title";
                break;
            }
            case 3: {
                resourceKey = resourceKey + ".tooltip";
                break;
            }
            case 4: {
                resourceKey = resourceKey + ".mnemonic";
            }
        }
        try {
            if (bundle != null) {
                String resourceValue = bundle.getString(resourceKey);
                propertyFileProperties.put(resourceKey, resourceValue);
            } else {
                propertyFileProperties.put(resourceKey, defaultString);
            }
        }
        catch (MissingResourceException e) {
            propertyFileProperties.put(resourceKey, defaultString);
        }
    }

    public void dumpCreatedResourceBundles() {
        String location = FileUtils.getFilePathToSaveFromUser("Choose Location");
        if (location != null) {
            this.dumpCreatedResourceBundles(location);
        }
    }

    public void dumpCreatedResourceBundles(String location) {
        Hashtable bundleHash = this.getCreateHash();
        Enumeration enumeration = bundleHash.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Properties props = (Properties)bundleHash.get(key);
            try {
                File propFile = new File(location + "/" + key);
                File parentDir = new File(propFile.getParent());
                parentDir.mkdirs();
                propFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(propFile);
                props.store(fos, "I18N Resource File");
                fos.close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String shortClassName(Class c) {
        String name = c.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private static String getKeyRef(Object requestor, String field) {
        return requestor.getClass().getName() + "." + field;
    }
}

