/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Projection;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class ProjMath {
    public static final transient float NORTH_POLE_F = 1.5707964f;
    public static final transient float SOUTH_POLE_F = -1.5707964f;
    public static final transient double NORTH_POLE_D = 1.5707963267948966;
    public static final transient double NORTH_POLE_DEG_D = 90.0;
    public static final transient double SOUTH_POLE_D = -1.5707963267948966;
    public static final transient double SOUTH_POLE_DEG_D = -90.0;
    public static final transient float DATELINE_F = (float)Math.PI;
    public static final transient double DATELINE_D = Math.PI;
    public static final transient double DATELINE_DEG_D = 180.0;
    public static final transient float LON_RANGE_F = (float)Math.PI * 2;
    public static final transient double LON_RANGE_D = Math.PI * 2;
    public static final transient double LON_RANGE_DEG_D = 360.0;

    private ProjMath() {
    }

    public static final double roundAdjust(double x) {
        return ProjMath.qint_old(x);
    }

    public static final double qint(double x) {
        return ProjMath.qint_new(x);
    }

    private static final double qint_old(double x) {
        return (int)x < 0 ? x - 0.5 : x + 0.5;
    }

    private static final double qint_new(double x) {
        return x <= 0.0 ? x - 1.0 : x + 1.0;
    }

    public static final float lonDistance(float lon1, float lon2) {
        return (float)Math.min((double)Math.abs(lon1 - lon2), (lon1 < 0.0f ? (double)lon1 + Math.PI : Math.PI - (double)lon1) + (lon2 < 0.0f ? (double)lon2 + Math.PI : Math.PI - (double)lon2));
    }

    public static final long DEG_TO_SC(double deg) {
        return (long)(deg * 3600000.0);
    }

    public static final double SC_TO_DEG(int sc) {
        return (double)sc / 3600000.0;
    }

    public static final double radToDeg(double rad) {
        return Math.toDegrees(rad);
    }

    public static final float radToDeg(float rad) {
        return (float)Math.toDegrees(rad);
    }

    public static final double degToRad(double deg) {
        return Math.toRadians(deg);
    }

    public static final float degToRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static final int hashLatLon(float lat, float lon) {
        if (lat == -0.0f) {
            lat = 0.0f;
        }
        if (lon == -0.0f) {
            lon = 0.0f;
        }
        int tmp = Float.floatToIntBits(lat);
        int hash = tmp << 5 | tmp >> 27;
        return hash ^ Float.floatToIntBits(lon);
    }

    public static final float[] arrayDegToRad(float[] degs) {
        for (int i = 0; i < degs.length; ++i) {
            degs[i] = ProjMath.degToRad(degs[i]);
        }
        return degs;
    }

    public static final float[] arrayRadToDeg(float[] rads) {
        for (int i = 0; i < rads.length; ++i) {
            rads[i] = ProjMath.radToDeg(rads[i]);
        }
        return rads;
    }

    public static final double[] arrayDegToRad(double[] degs) {
        for (int i = 0; i < degs.length; ++i) {
            degs[i] = ProjMath.degToRad(degs[i]);
        }
        return degs;
    }

    public static final double[] arrayRadToDeg(double[] rads) {
        for (int i = 0; i < rads.length; ++i) {
            rads[i] = ProjMath.radToDeg(rads[i]);
        }
        return rads;
    }

    public static final float normalize_latitude(float lat, float epsilon) {
        return ProjMath.normalizeLatitude(lat, epsilon);
    }

    public static final float normalizeLatitude(float lat, float epsilon) {
        if (lat > 1.5707964f - epsilon) {
            return 1.5707964f - epsilon;
        }
        if (lat < -1.5707964f + epsilon) {
            return -1.5707964f + epsilon;
        }
        return lat;
    }

    public static final double normalize_latitude(double lat, double epsilon) {
        return ProjMath.normalizeLatitude(lat, epsilon);
    }

    public static final double normalizeLatitude(double lat, double epsilon) {
        if (lat > 1.5707963267948966 - epsilon) {
            return 1.5707963267948966 - epsilon;
        }
        if (lat < -1.5707963267948966 + epsilon) {
            return -1.5707963267948966 + epsilon;
        }
        return lat;
    }

    public static final float wrap_longitude(float lon) {
        return ProjMath.wrapLongitude(lon);
    }

    public static final float wrapLongitude(float lon) {
        if (lon < (float)(-Math.PI) || lon > (float)Math.PI) {
            lon += (float)Math.PI;
            lon += (lon %= (float)Math.PI * 2) < 0.0f ? (float)Math.PI : (float)(-Math.PI);
        }
        return lon;
    }

    public static final double wrap_longitude(double lon) {
        return ProjMath.wrapLongitude(lon);
    }

    public static final double wrapLongitude(double lon) {
        if (lon < -Math.PI || lon > Math.PI) {
            lon += Math.PI;
            lon += (lon %= Math.PI * 2) < 0.0 ? Math.PI : -Math.PI;
        }
        return lon;
    }

    public static final double wrapLongitudeDeg(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            lon += 180.0;
            lon += (lon %= 360.0) < 0.0 ? 180.0 : -180.0;
        }
        return lon;
    }

    public static final float sphericalUnitsToDeg(float u, float uCircumference) {
        return 360.0f * (u / uCircumference);
    }

    public static final float sphericalUnitsToRad(float u, float uCircumference) {
        return (float)Math.PI * 2 * (u / uCircumference);
    }

    public static final float geocentric_latitude(float lat, float lon) {
        return ProjMath.geocentricLatitude(lat, lon);
    }

    public static final float geocentricLatitude(float lat, float flat) {
        float f = 1.0f - flat;
        return (float)Math.atan(f * f * (float)Math.tan(lat));
    }

    public static final float geographic_latitude(float lat, float lon) {
        return ProjMath.geographicLatitude(lat, lon);
    }

    public static final float geographicLatitude(float lat, float flat) {
        float f = 1.0f - flat;
        return (float)Math.atan((float)Math.tan(lat) / (f * f));
    }

    public static float getScale(Point2D ll1, Point2D ll2, Projection projection) {
        if (projection == null) {
            return Float.MAX_VALUE;
        }
        Point2D point1 = projection.forward(ll1);
        Point2D point2 = projection.forward(ll2);
        return ProjMath.getScale(ll1, ll2, point1, point2, projection);
    }

    public static float getScale(Point point1, Point point2, Projection projection) {
        return ProjMath.getScaleFromProjected(point1, point2, projection);
    }

    public static float getScaleFromProjected(Point2D point1, Point2D point2, Projection projection) {
        if (projection == null) {
            return Float.MAX_VALUE;
        }
        Point2D.Double upperLeft = new Point2D.Double(Math.min(point1.getX(), point2.getX()), Math.min(point1.getY(), point2.getY()));
        Point2D.Double lowerRight = new Point2D.Double(Math.max(point1.getX(), point2.getX()), Math.max(point1.getY(), point2.getY()));
        Object ll1 = projection.inverse(upperLeft);
        Object ll2 = projection.inverse(lowerRight);
        return ProjMath.getScale(ll1, ll2, upperLeft, lowerRight, projection);
    }

    protected static float getScale(Point2D ll1, Point2D ll2, Point2D point1, Point2D point2, Projection projection) {
        return projection.getScale(ll1, ll2, point1, point2);
    }

    public static boolean isCrossingDateline(double leftLon, double rightLon, float projScale) {
        return leftLon > rightLon || MoreMath.approximately_equal(leftLon, rightLon, (double)0.001f) && projScale > 1000000.0f;
    }

    public static Point getRatioPoint(Projection proj, Point pt1, Point pt2) {
        float mapRatio = (float)proj.getHeight() / (float)proj.getWidth();
        float boxHeight = pt1.y - pt2.y;
        float boxWidth = pt1.x - pt2.x;
        float boxRatio = Math.abs(boxHeight / boxWidth);
        int isNegative = -1;
        if (boxRatio > mapRatio) {
            if (boxHeight < 0.0f) {
                isNegative = 1;
            }
            boxHeight = Math.abs(mapRatio * boxWidth);
            pt2.y = pt1.y + isNegative * (int)boxHeight;
        } else if (boxRatio < mapRatio) {
            if (boxWidth < 0.0f) {
                isNegative = 1;
            }
            boxWidth = Math.abs(boxHeight / mapRatio);
            pt2.x = pt1.x + isNegative * (int)boxWidth;
        }
        return pt2;
    }

    public static Rectangle2D getRatioBox(Projection proj, Point2D pt1, Point2D pt2, boolean zoomOnCenter) {
        double boxWidth;
        double mapRatio = (double)proj.getHeight() / (double)proj.getWidth();
        double boxHeight = Math.abs(pt1.getY() - pt2.getY());
        double boxRatio = Math.abs(boxHeight / (boxWidth = Math.abs(pt1.getX() - pt2.getX())));
        if (boxRatio > mapRatio) {
            boxHeight = Math.abs(mapRatio * boxWidth);
        } else if (boxRatio < mapRatio) {
            boxWidth = Math.abs(boxHeight / mapRatio);
        }
        if (zoomOnCenter) {
            double anchorx = pt1.getX() - boxWidth;
            double anchory = pt1.getY() - boxHeight;
            return new Rectangle2D.Double(anchorx, anchory, 2.0 * boxWidth, 2.0 * boxHeight);
        }
        double anchorx = pt1.getX();
        if (pt2.getX() < anchorx) {
            anchorx -= boxWidth;
        }
        double anchory = pt1.getY();
        if (pt2.getY() < anchory) {
            anchory -= boxHeight;
        }
        return new Rectangle2D.Double(anchorx, anchory, boxWidth, boxHeight);
    }

    public static double[] getProjectionScreenOutlineCoords(Projection sourceMapProjection) {
        Point2D.Double tmpllp;
        int i;
        if (sourceMapProjection == null) {
            return null;
        }
        ArrayList<Point2D.Double> l = new ArrayList<Point2D.Double>();
        int width = sourceMapProjection.getWidth();
        int height = sourceMapProjection.getHeight();
        double xinc = (double)width / 10.0;
        double yinc = (double)height / 10.0;
        Point2D.Double center = sourceMapProjection.getCenter(new Point2D.Double());
        for (i = 0; i <= 10; ++i) {
            tmpllp = sourceMapProjection.inverse(xinc * (double)i, 0.0, new Point2D.Double());
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        for (i = 0; i <= 10; ++i) {
            tmpllp = sourceMapProjection.inverse(width, yinc * (double)i, new Point2D.Double());
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        for (i = 10; i >= 0; --i) {
            tmpllp = sourceMapProjection.inverse(xinc * (double)i, height, new Point2D.Double());
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        for (i = 10; i >= 0; --i) {
            tmpllp = sourceMapProjection.inverse(0.0, yinc * (double)i, new Point2D.Double());
            if (tmpllp.equals(center)) continue;
            l.add(tmpllp);
        }
        double[] llarr = new double[l.size() * 2];
        int i2 = 0;
        for (Point2D point2D : l) {
            llarr[i2] = point2D.getY();
            llarr[i2 + 1] = point2D.getX();
            i2 += 2;
        }
        return llarr;
    }

    public static boolean isVisible(Projection sourceMapProjection, Point2D llp) {
        boolean ret = false;
        if (sourceMapProjection != null && sourceMapProjection.isPlotable(llp)) {
            Point2D p = sourceMapProjection.forward(llp);
            double x = p.getX();
            double y = p.getY();
            if (x >= 0.0 && x <= (double)sourceMapProjection.getWidth() && y >= 0.0 && y <= (double)sourceMapProjection.getWidth()) {
                ret = true;
            }
        }
        return ret;
    }
}

