/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.awt;

import com.bbn.openmap.omGraphics.awt.LineUtil;
import com.bbn.openmap.omGraphics.awt.Revertable;
import com.bbn.openmap.omGraphics.awt.ShapeDecoration;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeDecorator
implements Revertable {
    private List<ShapeDecoration> decorations = new ArrayList<ShapeDecoration>();
    public static double FLATNESS = 0.1;

    public List<ShapeDecoration> getDecorations() {
        return this.decorations;
    }

    public void insertDecoration(int index, ShapeDecoration decoration) {
        this.decorations.add(index, decoration);
    }

    public void addDecoration(ShapeDecoration decoration) {
        this.decorations.add(decoration);
    }

    public ShapeDecoration removeDecoration(int index) {
        return this.decorations.remove(index);
    }

    public boolean removeDecoration(ShapeDecoration decoration) {
        return this.decorations.remove(decoration);
    }

    @Override
    public void revert() {
        for (ShapeDecoration shapeDecoration : this.decorations) {
            shapeDecoration.revert();
        }
    }

    public void draw(Graphics g, Shape s) {
        if (this.decorations.isEmpty()) {
            return;
        }
        PathIterator pi = s.getPathIterator(null, FLATNESS);
        double[] segCoords = new double[6];
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        Point2D.Double firstPoint = null;
        do {
            int segType = pi.currentSegment(segCoords);
            Point2D.Double point = new Point2D.Double(segCoords[0], segCoords[1]);
            switch (segType) {
                case 0: {
                    if (firstPoint == null) {
                        firstPoint = point;
                    }
                    if (!points.isEmpty()) {
                        this.draw(g, points);
                    }
                    points.clear();
                    points.add(point);
                    break;
                }
                case 1: {
                    points.add(point);
                    break;
                }
                case 4: {
                    points.add(firstPoint);
                }
            }
            pi.next();
        } while (!pi.isDone());
        if (!points.isEmpty()) {
            this.draw(g, points);
        }
    }

    public void draw(Graphics g, float[] xcoords, float[] ycoords) {
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        for (int i = 0; i < xcoords.length; ++i) {
            points.add(new Point2D.Double(xcoords[i], ycoords[i]));
        }
        this.draw(g, points);
    }

    public void draw(Graphics g, int[] xcoords, int[] ycoords) {
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        for (int i = 0; i < xcoords.length; ++i) {
            points.add(new Point2D.Double(xcoords[i], ycoords[i]));
        }
        this.draw(g, points);
    }

    public void draw(Graphics g, Point2D[] points) {
        LinkedList<Point2D> pointlist = new LinkedList<Point2D>();
        for (int i = 0; i < points.length; ++i) {
            pointlist.add(points[i]);
        }
        this.draw(g, pointlist);
    }

    protected void draw(Graphics g, LinkedList points) {
        if (this.decorations.isEmpty()) {
            throw new NullPointerException("No decorations");
        }
        ListIterator<ShapeDecoration> decorationIterator = this.decorations.listIterator();
        LinkedList polysegment = new LinkedList();
        Point2D.Double[] point2DArrayType = new Point2D.Double[1];
        while (!points.isEmpty()) {
            if (!decorationIterator.hasNext()) {
                decorationIterator = this.decorations.listIterator();
            }
            ShapeDecoration decor = (ShapeDecoration)decorationIterator.next();
            boolean complete = LineUtil.retrievePoints(decor.getLength(), points, polysegment);
            decor.draw(g, polysegment.toArray(point2DArrayType), complete);
        }
    }
}

