/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMBitmap;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkBitmap
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float lt, float ln, int w, int h, byte[] bytes, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<B>".getBytes());
        dos.writeByte(1);
        dos.writeByte(1);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(bytes.length);
        dos.write(bytes, 0, bytes.length);
        properties.write(dos);
    }

    public static void write(int x1, int y1, int w, int h, byte[] bytes, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<B>".getBytes());
        dos.writeByte(1);
        dos.writeByte(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(bytes.length);
        dos.write(bytes, 0, bytes.length);
        properties.write(dos);
    }

    public static void write(float lt, float ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<B>".getBytes());
        dos.writeByte(1);
        dos.writeByte(3);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(bytes.length);
        dos.write(bytes, 0, bytes.length);
        properties.write(dos);
    }

    public static void write(OMBitmap bitmap, Link link, LinkProperties props) throws IOException {
        switch (bitmap.getRenderType()) {
            case 1: {
                LinkBitmap.write((float)bitmap.getLat(), (float)bitmap.getLon(), bitmap.getWidth(), bitmap.getHeight(), bitmap.getBits(), props, (DataOutputStream)link.dos);
                break;
            }
            case 2: {
                LinkBitmap.write(bitmap.getX(), bitmap.getY(), bitmap.getWidth(), bitmap.getHeight(), bitmap.getBits(), props, (DataOutputStream)link.dos);
                break;
            }
            case 3: {
                LinkBitmap.write((float)bitmap.getLat(), (float)bitmap.getLon(), bitmap.getX(), bitmap.getY(), bitmap.getBits(), props, (DataOutputStream)link.dos);
                break;
            }
            default: {
                Debug.error("LinkBitmap.write: bitmap rendertype not handled.");
            }
        }
    }

    public static OMBitmap read(DataInputStream dis) throws IOException {
        return LinkBitmap.read(dis, null);
    }

    public static OMBitmap read(DataInputStream dis, LinkProperties propertiesBuffer) throws IOException {
        OMBitmap bitmap = null;
        float lat = 0.0f;
        float lon = 0.0f;
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        byte renderType = dis.readByte();
        switch (renderType) {
            case 3: {
                lat = dis.readFloat();
                lon = dis.readFloat();
            }
            case 2: {
                x = dis.readInt();
                y = dis.readInt();
                break;
            }
            default: {
                lat = dis.readFloat();
                lon = dis.readFloat();
            }
        }
        w = dis.readInt();
        h = dis.readInt();
        int length = dis.readInt();
        byte[] bytes = new byte[length];
        dis.readFully(bytes);
        switch (renderType) {
            case 3: {
                bitmap = new OMBitmap(lat, lon, x, y, w, h, bytes);
                break;
            }
            case 2: {
                bitmap = new OMBitmap(x, y, w, h, bytes);
                break;
            }
            default: {
                bitmap = new OMBitmap(lat, lon, w, h, bytes);
            }
        }
        if (bitmap != null) {
            LinkProperties properties = LinkProperties.loadPropertiesIntoOMGraphic(dis, bitmap, propertiesBuffer);
            bitmap.setRotationAngle(ProjMath.degToRad(PropUtils.floatFromProperties(properties, "rot", 0.0f)));
        }
        return bitmap;
    }
}

