/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.netmap;

import com.bbn.openmap.graphicLoader.netmap.Node;
import java.util.Enumeration;
import java.util.Hashtable;

public class NodeCache {
    private Hashtable nodeTable = null;

    NodeCache() {
        this.nodeTable = new Hashtable();
    }

    NodeCache(int initialCapacity) {
        this.nodeTable = new Hashtable(initialCapacity);
    }

    public void flush() {
        Enumeration list = this.elements();
        while (list.hasMoreElements()) {
            this.delete((Node)list.nextElement());
        }
    }

    public Enumeration elements() {
        return this.nodeTable.elements();
    }

    public Node add(String label, int index, int shape, int menu, int color) {
        Node node = null;
        node = this.get(label);
        if (node != null) {
            return node;
        }
        node = new Node(label, index, shape, menu, color);
        this.nodeTable.put(label, node);
        return node;
    }

    public Node get(int index) {
        Enumeration list = this.nodeTable.elements();
        if (list == null) {
            return null;
        }
        while (list.hasMoreElements()) {
            Node node = (Node)list.nextElement();
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    public Node get(String label) {
        return (Node)this.nodeTable.get(label);
    }

    public void del(String label) {
        this.delete(this.get(label));
    }

    public void del(int index) {
        this.delete(this.get(index));
    }

    public void del(Node node) {
        this.delete(node);
    }

    private void delete(Node node) {
        if (node == null) {
            return;
        }
        this.nodeTable.remove(node.getLabel());
    }
}

