/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.ListenerSupport;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerSupport
extends ListenerSupport<LayerListener> {
    static Logger logger = Logger.getLogger("com.bbn.openmap.event.LayerSupport");
    protected boolean synchronous = true;
    protected Thread t;
    protected Vector<SetLayerRunnable> events = new Vector();

    public LayerSupport(Object sourceBean) {
        super(sourceBean);
        logger.fine("LayerSupport created");
    }

    public void fireLayer(int type, Layer[] layers) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("calling setLayers on " + this.size() + " objects");
        }
        if (this.isEmpty()) {
            return;
        }
        LayerEvent evt = new LayerEvent(this.source, type, layers);
        for (LayerListener listener : this) {
            listener.setLayers(evt);
        }
    }

    public synchronized void pushLayerEvent(int layerEventType, Layer[] layers) {
        if (this.synchronous) {
            this.fireLayer(layerEventType, layers);
        } else {
            SetLayerRunnable runnable;
            this.events.add(new SetLayerRunnable(layerEventType, layers));
            if (!(this.t != null && this.t.isAlive() || (runnable = this.popLayerEvent()) == null)) {
                this.t = new Thread(runnable);
                this.t.start();
            }
        }
    }

    public synchronized SetLayerRunnable popLayerEvent() {
        try {
            return this.events.remove(0);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    protected class SetLayerRunnable
    implements Runnable {
        protected int layerEventType;
        protected Layer[] layers;

        public SetLayerRunnable(int let, Layer[] lrs) {
            this.layerEventType = let;
            this.layers = lrs;
        }

        public int getEventType() {
            return this.layerEventType;
        }

        public Layer[] getLayers() {
            return this.layers;
        }

        public void run() {
            this.doIt(this.getEventType(), this.getLayers());
            SetLayerRunnable runnable = LayerSupport.this.popLayerEvent();
            while (runnable != null) {
                this.doIt(runnable.getEventType(), runnable.getLayers());
                runnable = LayerSupport.this.popLayerEvent();
            }
        }

        public void doIt(int eventType, Layer[] layers) {
            logger.fine("firing LayerEvent on LayerListeners");
            LayerSupport.this.fireLayer(eventType, layers);
        }
    }
}

