/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.Command;
import java.io.DataInputStream;
import java.io.IOException;

public class PolylineElement
extends Command {
    int[] X;
    int[] Y;
    int[] X0;
    int[] Y0;

    public PolylineElement(int ec, int eid, int l, DataInputStream in) throws IOException {
        super(ec, eid, l, in);
        int n = this.args.length / 4;
        this.X = new int[n];
        this.Y = new int[n];
        for (int i = 0; i < n; ++i) {
            this.X[i] = this.makeInt(2 * i);
            this.Y[i] = this.makeInt(2 * i + 1);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Polyline");
        for (int i = 0; i < this.X.length; ++i) {
            s.append(" [").append(this.X[i]).append(",").append(this.Y[i]).append("]");
        }
        return s.toString();
    }

    public void scale(CGMDisplay d) {
        this.X0 = new int[this.X.length];
        this.Y0 = new int[this.X.length];
        for (int i = 0; i < this.X.length; ++i) {
            this.X0[i] = d.x(this.X[i]);
            this.Y0[i] = d.y(this.Y[i]);
        }
    }

    public void paint(CGMDisplay d) {
        d.graphics().setColor(d.getLineColor());
        d.graphics().drawPolyline(this.X0, this.Y0, this.X0.length);
    }
}

