/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.ISwingWorker;
import com.bbn.openmap.util.TaskService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PooledSwingWorker<T>
implements ISwingWorker<T> {
    private T value;
    private boolean interrupted;
    private boolean completed;
    private Exception executionException;
    private final Runnable task;
    private final Object lock = new Object();
    private Future<T> futureList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledSwingWorker() {
        final Callable doWork = new Callable<T>(){

            @Override
            public T call() {
                return PooledSwingWorker.this.construct();
            }
        };
        Object object = this.lock;
        synchronized (object) {
            this.task = new Runnable(){

                public void run() {
                    PooledSwingWorker.this.completed = false;
                    if (!PooledSwingWorker.this.interrupted) {
                        PooledSwingWorker.this.futureList = TaskService.singleton().spawn(doWork);
                        try {
                            PooledSwingWorker.this.value = PooledSwingWorker.this.futureList.get();
                            PooledSwingWorker.this.completed = !PooledSwingWorker.this.interrupted;
                        }
                        catch (ExecutionException ee) {
                            PooledSwingWorker.this.interrupted = true;
                        }
                        catch (InterruptedException e) {
                            PooledSwingWorker.this.interrupted = true;
                        }
                        catch (CancellationException ce) {
                            PooledSwingWorker.this.interrupted = true;
                        }
                    }
                    PooledSwingWorker.this.finished();
                }
            };
        }
    }

    @Override
    public abstract T construct();

    @Override
    public void execute() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.interrupted) {
                TaskService.singleton().spawn(this.task);
            }
        }
    }

    public Exception getExecutionException() {
        return this.executionException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.interrupted && !this.completed) {
                try {
                    this.lock.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        Object object = this.lock;
        synchronized (object) {
            this.interrupted = true;
            this.lock.notifyAll();
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void finished() {
    }
}

