/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.meteo;

import com.bbn.openmap.omGraphics.awt.AbstractShapeDecoration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;

public class ColdFrontShapeDecoration
extends AbstractShapeDecoration {
    public static Color COLOR = Color.blue;
    private boolean filled = true;

    public ColdFrontShapeDecoration(int length, int width, int orientation) {
        super(length, width, orientation);
        this.setPaint(COLOR);
    }

    public void draw(Graphics g, Point2D[] points, boolean complete) {
        this.setGraphics(g);
        int nbpts = points.length;
        int[] xcoord = new int[nbpts + 2];
        int[] ycoord = new int[nbpts + 2];
        for (int i = 0; i < nbpts; ++i) {
            xcoord[i] = (int)points[i].getX();
            ycoord[i] = (int)points[i].getY();
        }
        if (complete) {
            int orient = this.getOrientation() == 2 ? -1 : 1;
            double dx = points[nbpts - 1].getX() - points[0].getX();
            double dy = points[nbpts - 1].getY() - points[0].getY();
            double norm = Math.sqrt(dx * dx + dy * dy);
            double rcos = dx / norm;
            double rsin = dy / norm;
            double r = (double)this.getLength() / 2.0;
            double w = (float)orient * this.getWidth();
            xcoord[nbpts] = (int)(points[0].getX() + r * rcos - w * rsin);
            ycoord[nbpts++] = (int)(points[0].getY() + r * rsin + w * rcos);
            xcoord[nbpts] = (int)points[0].getX();
            ycoord[nbpts++] = (int)points[0].getY();
            if (this.filled) {
                g.fillPolygon(xcoord, ycoord, nbpts);
            }
        }
        g.drawPolyline(xcoord, ycoord, nbpts);
        this.restoreGraphics(g);
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }
}

