/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.DeepCopyUtil;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class OMRangeRings
extends OMCircle {
    protected transient OMCircle[] subCircles = null;
    protected transient OMText[] labels = null;
    public static final int DEFAULT_INTERVAL = 4;
    protected int interval = 4;
    protected Length intervalUnits = null;
    protected transient DrawingAttributes drawingAttributes = new DrawingAttributes();
    protected OMPoint centerPoint;
    public static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat();
    protected NumberFormat form = DEFAULT_FORMAT;
    protected boolean drawLabels = true;

    public OMRangeRings() {
    }

    public OMRangeRings(double latPoint, double lonPoint, double radius) {
        this(new LatLonPoint.Double(latPoint, lonPoint), radius, Length.DECIMAL_DEGREE, -1);
    }

    public OMRangeRings(double latPoint, double lonPoint, double radius, Length units) {
        this(new LatLonPoint.Double(latPoint, lonPoint), radius, units, -1);
    }

    public OMRangeRings(double latPoint, double lonPoint, double radius, Length units, int nverts) {
        this(new LatLonPoint.Double(latPoint, lonPoint), radius, units, nverts);
    }

    public OMRangeRings(LatLonPoint center, double radius, Length units, int nverts) {
        super(center, radius, units, nverts);
        this.centerPoint = this.createCenterPoint();
        this.form.setMaximumFractionDigits(2);
    }

    protected OMPoint createCenterPoint() {
        return new OMPoint(this.center.getY(), this.center.getX());
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.setNeedToRegenerate(true);
    }

    public void setInterval(int interval, Length units) {
        this.setInterval(interval);
        this.setIntervalUnits(units);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setIntervalUnits(Length units) {
        this.intervalUnits = units;
        this.setNeedToRegenerate(true);
    }

    public Length getIntervalUnits() {
        return this.intervalUnits;
    }

    public void setDrawLabels(boolean dl) {
        this.drawLabels = dl;
    }

    public boolean getDrawLabels() {
        return this.drawLabels;
    }

    public void setFormat(NumberFormat nf) {
        this.form = nf != null ? nf : DEFAULT_FORMAT;
    }

    public NumberFormat getFormat() {
        return this.form;
    }

    public void setRadius(float radius) {
        this.setRadius(radius, Length.DECIMAL_DEGREE);
    }

    public void setRadius(float radius, Length units) {
        this.radius = units.toRadians(radius);
        this.setNeedToRegenerate(true);
    }

    public OMCircle[] createCircles() {
        OMText[] t;
        OMCircle[] circles;
        if (this.intervalUnits == null) {
            int noUnitInterval = this.interval - 1;
            circles = new OMCircle[noUnitInterval];
            t = new OMText[noUnitInterval];
            for (int i = 0; i < noUnitInterval; ++i) {
                double rad = (double)(i + 1) * this.radius / (double)(noUnitInterval + 1);
                circles[i] = new OMCircle(this.center, rad, Length.RADIAN, -1);
                String value = i + 1 + "/" + (noUnitInterval + 1);
                t[i] = new OMText(this.center.getY() + Length.DECIMAL_DEGREE.fromRadians(rad), this.center.getX(), value, 1);
            }
        } else {
            String value;
            double realDistanceInterval = this.intervalUnits.toRadians(this.interval);
            int number = (int)(this.radius / realDistanceInterval);
            circles = new OMCircle[number];
            t = new OMText[number + 1];
            for (int i = 0; i < number; ++i) {
                double rad = (double)(i + 1) * realDistanceInterval;
                circles[i] = new OMCircle(this.center, rad, Length.RADIAN, -1);
                value = this.form.format((double)(i + 1) * (double)this.interval) + " " + this.intervalUnits.getAbbr();
                t[i] = new OMText(this.center.getY() + Length.DECIMAL_DEGREE.fromRadians(rad), this.center.getX(), value, 1);
            }
            value = this.form.format(this.intervalUnits.fromRadians(this.radius)) + " " + this.intervalUnits.getAbbr();
            t[i] = new OMText(this.center.getY() + Length.DECIMAL_DEGREE.fromRadians(this.radius), this.center.getX(), value, 1);
        }
        this.labels = t;
        return circles;
    }

    public boolean generate(Projection proj) {
        if (this.getNeedToRegenerate()) {
            this.subCircles = this.interval > 0 ? this.createCircles() : null;
        }
        this.centerPoint = this.createCenterPoint();
        this.centerPoint.generate(proj);
        this.setRenderType(1);
        if (this.subCircles != null) {
            int i;
            for (i = 0; i < this.subCircles.length; ++i) {
                this.subCircles[i].generate(proj);
                this.labels[i].generate(proj);
            }
            if (this.labels.length > i) {
                this.labels[i].generate(proj);
            }
        }
        return super.generate(proj);
    }

    public void render(Graphics g) {
        super.render(g);
        this.drawingAttributes.setFrom(this);
        if (this.subCircles != null) {
            for (int i = this.subCircles.length - 1; i >= 0; --i) {
                this.drawingAttributes.setTo(this.subCircles[i]);
                this.drawingAttributes.setTo(this.labels[i]);
                this.labels[i].setLinePaint(this.drawingAttributes.getLinePaint());
                this.subCircles[i].render(g);
                if (!this.drawLabels) continue;
                this.labels[i].render(g);
            }
            if (this.labels.length > this.subCircles.length && this.drawLabels) {
                this.drawingAttributes.setTo(this.labels[this.subCircles.length]);
                this.labels[this.subCircles.length].setLinePaint(this.drawingAttributes.getLinePaint());
                this.labels[this.subCircles.length].render(g);
            }
        }
        if (this.centerPoint != null) {
            this.drawingAttributes.setTo(this.centerPoint);
            this.centerPoint.render(g);
        }
    }

    public float distance(double x, double y) {
        float dist = this.normalizeDistanceForLineWidth(super.distance(x, y));
        float tmpDist = this.centerPoint.distance(x, y);
        if (tmpDist < dist) {
            dist = tmpDist;
        }
        return dist;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMRangeRings) {
            OMRangeRings rings = (OMRangeRings)source;
            this.subCircles = DeepCopyUtil.deepCopy(rings.subCircles);
            this.labels = DeepCopyUtil.deepCopy(rings.labels);
            this.interval = rings.interval;
            this.intervalUnits = rings.intervalUnits;
            this.centerPoint = DeepCopyUtil.deepCopy(rings.centerPoint);
            this.form = (NumberFormat)rings.form.clone();
            this.drawLabels = true;
        }
    }
}

