/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMSpline;
import com.bbn.openmap.omGraphics.awt.Revertable;
import com.bbn.openmap.omGraphics.awt.ShapeDecorator;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;

public class OMDecoratedSpline
extends OMSpline
implements Revertable {
    private ShapeDecorator decorator = new ShapeDecorator();

    public OMDecoratedSpline() {
        this.initDecorations();
    }

    public OMDecoratedSpline(double[] llPoints, int units, int lType) {
        super(llPoints, units, lType);
        this.initDecorations();
    }

    public OMDecoratedSpline(double[] llPoints, int units, int lType, int nsegs) {
        super(llPoints, units, lType, nsegs);
        this.initDecorations();
    }

    public OMDecoratedSpline(int[] xypoints) {
        super(xypoints);
        this.initDecorations();
    }

    public OMDecoratedSpline(int[] xPoints, int[] yPoints) {
        super(xPoints, yPoints);
        this.initDecorations();
    }

    public OMDecoratedSpline(double latPoint, double lonPoint, int[] xypoints, int cMode) {
        super(latPoint, lonPoint, xypoints, cMode);
        this.initDecorations();
    }

    public OMDecoratedSpline(double latPoint, double lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(latPoint, lonPoint, xPoints, yPoints, cMode);
        this.initDecorations();
    }

    public void render(Graphics g) {
        if (this.decorator == null) {
            super.render(g);
            return;
        }
        if (this.shape != null) {
            this.decorator.draw(g, this.shape);
            return;
        }
        if (this.getNeedToRegenerate() || !this.isVisible()) {
            return;
        }
        float[][] xpts = this.xpoints;
        float[][] ypts = this.ypoints;
        int len = xpts.length;
        Paint displayPaint = this.getDisplayPaint();
        Paint fillPaint = this.getFillPaint();
        boolean isFillClear = this.isClear(fillPaint);
        boolean isLineClear = this.isClear(displayPaint);
        try {
            for (int i = 0; i < len; ++i) {
                float[] _x = xpts[i];
                float[] _y = ypts[i];
                if (this.isPolygon) {
                    if (!isFillClear) {
                        this.setGraphicsForFill(g);
                        GeneralPath poly = new GeneralPath();
                        for (int j = 0; j < _x.length; ++j) {
                            if (j == 0) {
                                poly.moveTo(_x[0], _y[0]);
                                continue;
                            }
                            poly.lineTo(_x[j], _y[j]);
                        }
                        ((Graphics2D)g).fill(poly);
                    }
                    if (isLineClear && this.edgeMatchesFill) continue;
                    this.setGraphicsForEdge(g);
                    this.decorator.draw(g, _x, _y);
                    continue;
                }
                this.setGraphicsForEdge(g);
                this.decorator.draw(g, _x, _y);
            }
        }
        catch (Exception e) {
            Debug.output("OMDecoratedSpline: caught Java rendering exception\n" + e.getMessage());
        }
    }

    public ShapeDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(ShapeDecorator decorator) {
        this.decorator = decorator;
    }

    protected void initDecorations() {
    }

    public void revert() {
        this.decorator.revert();
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMDecoratedSpline) {
            OMDecoratedSpline spline = (OMDecoratedSpline)source;
            this.decorator = spline.decorator;
        }
    }
}

