/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.TilingAdapter;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaTable
extends PrimitiveTable {
    private final DcwRecordFile rings;
    private final EdgeTable edges;
    private final boolean privateEdgeTable;
    private final int ringIDColumn = this.whatColumn("ring_ptr");
    private final int faceIDColumn;
    private final int ringStartColumn;
    private final TilingAdapter edgeRightFaceAdapter;
    private final TilingAdapter edgeLeftFaceAdapter;
    private final TilingAdapter edgeRightEdgeAdapter;
    private final TilingAdapter edgeLeftEdgeAdapter;

    public AreaTable(CoverageTable cov, EdgeTable edg, TileDirectory tile) throws FormatException {
        super(cov, tile, "fac");
        this.privateEdgeTable = edg == null;
        this.edges = this.privateEdgeTable ? new EdgeTable(cov, tile) : edg;
        this.edgeRightFaceAdapter = this.edges.getRightFaceTilingAdapter();
        this.edgeLeftFaceAdapter = this.edges.getLeftFaceTilingAdapter();
        this.edgeRightEdgeAdapter = this.edges.getRightEdgeTilingAdapter();
        this.edgeLeftEdgeAdapter = this.edges.getLeftEdgeTilingAdapter();
        if (this.edges.topologyLevel() != 3) {
            throw new FormatException("AreaTable: need level 3 topology: " + this.edges.topologyLevel());
        }
        this.rings = new DcwRecordFile(cov.getDataPath() + tile.getPath() + "rng" + (cov.appendDot ? "." : ""));
        this.ringStartColumn = this.rings.whatColumn("start_edge");
        if (this.ringStartColumn == -1) {
            throw new FormatException("ring has no start edge: " + this.rings.filename);
        }
        this.faceIDColumn = this.rings.whatColumn("face_id");
        if (this.faceIDColumn == -1) {
            throw new FormatException("ring has no face_id: " + this.rings.filename);
        }
    }

    @Override
    public void close() {
        if (this.privateEdgeTable) {
            this.edges.close();
        }
        this.rings.close();
        super.close();
    }

    public int computeEdgePoints(List<Object> facevec, List<CoordFloatString> allLLPoints) throws FormatException {
        int ring_ptr = ((Number)facevec.get(this.ringIDColumn)).intValue();
        ArrayList<Object> ring1 = new ArrayList<Object>(this.rings.getColumnCount());
        this.rings.getRow(ring1, ring_ptr);
        int fac_id = ((Number)ring1.get(this.faceIDColumn)).intValue();
        int startedgeid = ((Number)ring1.get(this.ringStartColumn)).intValue();
        if (startedgeid <= 0) {
            return 0;
        }
        int nextedgeid = startedgeid;
        boolean firsttime = true;
        allLLPoints.clear();
        int polySize = 0;
        int prev_node = -1;
        ArrayList<Object> edge = new ArrayList<Object>(this.edges.getColumnCount());
        do {
            this.edges.getRow(edge, nextedgeid);
            int start_node = this.edges.getStartNode(edge);
            int end_node = this.edges.getEndNode(edge);
            int rht_face = this.edgeRightFaceAdapter.getPrimId(edge);
            int lft_face = this.edgeLeftFaceAdapter.getPrimId(edge);
            int right_edge = this.edgeRightEdgeAdapter.getPrimId(edge);
            int left_edge = this.edgeLeftEdgeAdapter.getPrimId(edge);
            if (firsttime) {
                prev_node = start_node;
                firsttime = false;
            }
            CoordFloatString cfs = this.edges.getCoordinates(edge);
            if (fac_id == rht_face && fac_id == lft_face) {
                if (start_node == prev_node) {
                    nextedgeid = right_edge;
                    prev_node = end_node;
                    continue;
                }
                if (end_node == prev_node) {
                    nextedgeid = left_edge;
                    prev_node = start_node;
                    continue;
                }
                throw new FormatException(" node matching assertion failed ");
            }
            if (fac_id == rht_face) {
                nextedgeid = right_edge;
                prev_node = end_node;
                polySize += cfs.tcount;
                allLLPoints.add(cfs);
                continue;
            }
            if (fac_id == lft_face) {
                nextedgeid = left_edge;
                prev_node = start_node;
                polySize += cfs.tcount;
                cfs.tcount *= -1;
                allLLPoints.add(cfs);
                continue;
            }
            throw new FormatException("Node Assertion failed");
        } while (nextedgeid != startedgeid);
        return polySize;
    }

    @Override
    public void drawTile(VPFGraphicWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2) {
        try {
            ArrayList<Object> area = new ArrayList<Object>(this.getColumnCount());
            while (this.parseRow(area)) {
                warehouse.createArea(this.covtable, this, area, ll1, ll2, dpplat, dpplon);
            }
        }
        catch (FormatException f) {
            System.out.println("Exception: " + f.getClass() + " " + f.getMessage());
        }
    }

    @Override
    public OMGraphic drawFeature(VPFFeatureWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2, List<Object> area, String featureType) {
        if (warehouse == null) {
            return null;
        }
        return warehouse.createArea(this.covtable, this, area, ll1, ll2, dpplat, dpplon, featureType);
    }
}

