/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.test;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.geo.OMGeo;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import java.awt.Color;

public class GeoTestLayer
extends OMGraphicHandlerLayer {
    private static double[] _Polygon = new double[]{73.0, 46.0, 73.0, 121.0, 73.0, 155.0, 46.4317, 155.0, 39.625, 150.482, 37.2, 150.5, 35.2, 146.0, 32.0, 146.0, 25.0, 144.343, 21.0, 145.2, 17.42, 146.5, 16.5367, 147.925, 14.875, 148.982, 12.215, 148.962, 7.0, 155.0, -45.2333, 155.233, -38.3117, 75.0, -35.0, 26.0, -35.2167, 10.0, -18.0, 10.0, -9.66667, 11.4, -4.79833, 6.58333, 0.391667, -7.745, 4.57167, -12.165, 6.96, -14.72, 12.2833, -17.3667, 13.0, -18.0, 20.9167, -18.0, 25.0, -19.8117, 35.9667, -11.45, 36.7617, -13.6733, 38.0, -15.0, 42.0, -15.0, 43.0, -13.0, 45.0, -13.0, 45.0, -9.0, 46.0, -8.75, 48.0, -8.75, 48.5983, -9.0, 49.0667, -11.745, 49.0, -15.0, 57.0, -15.0, 57.0, -10.0, 61.0, -10.0, 61.0, 0.001667, 63.0, 3.71667, 68.0967, 10.9583, 69.7033, 18.9967, 70.3667, 32.0, 73.0, 46.0};

    public OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = this.getGeos();
        }
        if (list != null) {
            list.generate(this.getProjection());
        }
        return list;
    }

    protected OMGraphicList getGeos() {
        OMGraphicList ret = new OMGraphicList();
        GeoArray.Double thePolygon = GeoArray.Double.createFromLatLonDegrees(_Polygon);
        Geo x = new Geo(38.75, -27.6, true);
        boolean bInside = Intersection.isPointInPolygon(x, thePolygon);
        System.out.println("The point " + x.getLatitude() + "," + x.getLongitude() + " is " + (bInside ? "INSIDE" : "OUTSIDE") + " the polygon");
        System.out.println("self intersecting: " + (Intersection.isSelfIntersectingPoly(_Polygon) ? "TRUE" : "FALSE"));
        OMPoly poly = new OMPoly(_Polygon, 0, 3);
        poly.setFillPaint(new Color(-1426128896, true));
        Geo centerGeo = Intersection.center(thePolygon);
        OMPoint center = new OMPoint(centerGeo.getLatitude(), centerGeo.getLongitude());
        center.putAttribute("Label", new OMTextLabeler("CENTER"));
        center.setLinePaint(Color.yellow);
        center.setFillPaint(Color.green);
        ret.add(center);
        x = new Geo(39.0, -90.0, true);
        bInside = Intersection.isPointInPolygon(x, thePolygon);
        System.out.println("The point " + x.getLatitude() + "," + x.getLongitude() + " is " + (bInside ? "INSIDE" : "OUTSIDE") + " the polygon");
        OMPoint point = new OMPoint(39.0, -90.0);
        point.putAttribute("Label", new OMTextLabeler(bInside ? "1 INSIDE" : "1 OUTSIDE"));
        point.setLinePaint(Color.yellow);
        point.setFillPaint(Color.red);
        ret.add(point);
        OMGeo.Pt g1 = new OMGeo.Pt(0.0, 0.0, true);
        g1.setLinePaint(Color.green);
        OMGeo.Pt g2 = new OMGeo.Pt(10.0, 10.0, true);
        g2.setLinePaint(Color.green);
        OMGeo.Pt g3 = new OMGeo.Pt(g1.getPoint().add(g2.getPoint(), new Geo()));
        g3.setLinePaint(Color.yellow);
        ret.add(g1);
        ret.add(g2);
        ret.add(g3);
        return ret;
    }
}

