/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.imageTile;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.mapTile.MapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.StandardMapTileFactory;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.BufferedImageRenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import java.awt.Container;
import java.util.Properties;
import java.util.logging.Logger;

public class MapTileLayer
extends OMGraphicHandlerLayer {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.imageTile.TileLayer");
    public static final String TILE_FACTORY_CLASS_PROPERTY = "tileFactory";
    public static final String INCREMENTAL_UPDATES_PROPERTY = "incrementalUpdates";
    public static final String ZOOM_LEVEL_PROPERTY = "zoomLevel";
    protected MapTileFactory tileFactory;
    protected boolean incrementalUpdates = false;
    protected int zoomLevel = -1;

    public MapTileLayer() {
        this.setRenderPolicy(new BufferedImageRenderPolicy(this));
        this.setTileFactory(new StandardMapTileFactory());
    }

    public MapTileLayer(MapTileFactory tileFactory) {
        this();
        this.tileFactory = tileFactory;
    }

    public synchronized OMGraphicList prepare() {
        Projection projection = this.getProjection();
        if (projection == null) {
            return null;
        }
        if (this.tileFactory != null) {
            OMGraphicList newList = new OMGraphicList();
            this.setList(newList);
            return this.tileFactory.getTiles(projection, this.zoomLevel, newList);
        }
        return null;
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String tileFactoryClassString = props.getProperty(prefix + TILE_FACTORY_CLASS_PROPERTY);
        if (tileFactoryClassString != null) {
            MapTileFactory itf = (MapTileFactory)ComponentFactory.create(tileFactoryClassString, prefix, props);
            if (itf != null) {
                this.setTileFactory(itf);
            }
        } else if (this.tileFactory instanceof PropertyConsumer) {
            ((PropertyConsumer)((Object)this.tileFactory)).setProperties(prefix, props);
        }
        this.incrementalUpdates = PropUtils.booleanFromProperties(props, prefix + INCREMENTAL_UPDATES_PROPERTY, this.incrementalUpdates);
        this.setZoomLevel(PropUtils.intFromProperties(props, prefix + ZOOM_LEVEL_PROPERTY, this.zoomLevel));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.tileFactory != null) {
            props.put(prefix + TILE_FACTORY_CLASS_PROPERTY, this.tileFactory.getClass().getName());
            if (this.tileFactory instanceof PropertyConsumer) {
                ((PropertyConsumer)((Object)this.tileFactory)).getProperties(props);
            }
        }
        props.put(prefix + INCREMENTAL_UPDATES_PROPERTY, Boolean.toString(this.incrementalUpdates));
        props.put(prefix + ZOOM_LEVEL_PROPERTY, Integer.toString(this.zoomLevel));
        return props;
    }

    public void removed(Container cont) {
        MapTileFactory tileFactory = this.getTileFactory();
        if (tileFactory != null) {
            tileFactory.reset();
        }
    }

    public MapTileFactory getTileFactory() {
        return this.tileFactory;
    }

    public void setTileFactory(MapTileFactory tileFactory) {
        logger.fine("setting tile factory to: " + tileFactory.getClass().getName());
        if (this.incrementalUpdates) {
            tileFactory.setRepaintCallback(this);
        }
        this.tileFactory = tileFactory;
    }

    public boolean isIncrementalUpdates() {
        return this.incrementalUpdates;
    }

    public void setIncrementalUpdates(boolean incrementalUpdates) {
        this.incrementalUpdates = incrementalUpdates;
        if (this.tileFactory != null) {
            if (!incrementalUpdates) {
                this.tileFactory.setRepaintCallback(null);
            } else {
                this.tileFactory.setRepaintCallback(this);
            }
        }
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }
}

