/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.OMEvent;
import com.bbn.openmap.event.OMEventSelectionCoordinator;
import com.bbn.openmap.gui.event.AbstractEventPresenter;
import com.bbn.openmap.gui.event.EventPresenter;
import com.bbn.openmap.gui.time.TimePanel;
import com.bbn.openmap.gui.time.TimeSliderLayer;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.NullProjectionChangePolicy;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Cartesian;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.time.Clock;
import com.bbn.openmap.time.TimeBounds;
import com.bbn.openmap.time.TimeBoundsEvent;
import com.bbn.openmap.time.TimeBoundsListener;
import com.bbn.openmap.time.TimeEvent;
import com.bbn.openmap.time.TimeEventListener;
import com.bbn.openmap.time.TimerStatus;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.OMIconFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineLayer
extends OMGraphicHandlerLayer
implements ActionListener,
DrawingToolRequestor,
PropertyChangeListener,
MapMouseListener,
ComponentListener,
TimeBoundsListener,
TimeEventListener {
    public static final String PlayFilterProperty = "playfilter";
    public static final String MouseTimeProperty = "mouseTime";
    public static final String EventDetailsProperty = "eventDetails";
    public static final String TimeParametersProperty = "timeParameters";
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.time.TimelineLayer");
    protected I18n i18n = Environment.getI18n();
    protected OMGraphicList eventGraphicList = null;
    protected OMGraphicList timeLinesList = null;
    protected PlayFilter playFilter = new PlayFilter();
    protected OMGraphicList ratingAreas = new OMGraphicList();
    protected SelectionArea selectionRect;
    protected TimeSliderLayer.TimeDrape drape;
    protected CenterSupport centerDelegate;
    private TimeSliderLayer timeSliderLayer;
    long currentTime = 0L;
    long gameStartTime = 0L;
    long gameEndTime = 0L;
    protected EventPresenter eventPresenter;
    protected OMEventSelectionCoordinator aesc;
    protected static Color tint = new Color(-1728053248, true);
    protected Clock clock;
    private boolean realTimeMode;
    private boolean isNoTime = true;
    private Timer scrollTimer = new Timer();
    private ScrollTask scrollTask = null;
    protected TimeHashFactory timeHashFactory;
    protected OMGraphicList currentTimeMarker;
    protected SelectionArea.PreTime preTime;
    protected SelectionArea.PostTime postTime;
    protected static final String ATT_KEY_EVENT = "att_key_event";
    protected Box palette = null;
    double downLon;
    boolean doubleClick = false;

    public TimelineLayer() {
        this.setName("Timeline");
        this.setProjectionChangePolicy(new NullProjectionChangePolicy());
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
        this.centerDelegate = new CenterSupport(this);
        this.addComponentListener(this);
        this.drape = new TimeSliderLayer.TimeDrape(0, 0, -1, -1);
        this.drape.setFillPaint(Color.gray);
        this.drape.setVisible(true);
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof Clock) {
            this.clock = (Clock)someObj;
            this.clock.addTimeEventListener(this);
            this.clock.addTimeBoundsListener(this);
            this.setTimeBounds(this.clock.getStartTime(), this.clock.getEndTime());
        }
        if (someObj instanceof CenterListener) {
            this.centerDelegate.add((CenterListener)someObj);
        }
        if (someObj instanceof EventPresenter) {
            this.eventPresenter = (EventPresenter)someObj;
            this.selectionRect = null;
            this.eventPresenter.addPropertyChangeListener(this);
        }
        if (someObj instanceof OMEventSelectionCoordinator) {
            this.aesc = (OMEventSelectionCoordinator)someObj;
            this.aesc.addPropertyChangeListener(this);
        }
        if (someObj instanceof TimePanel.Wrapper) {
            TimePanel tp = ((TimePanel.Wrapper)someObj).getTimePanel();
            tp.addPropertyChangeListener(this);
            this.addPropertyChangeListener(tp);
            this.timeSliderLayer = tp.getTimeSliderPanel().getTimeSliderLayer();
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj == this.clock) {
            this.clock.removeTimeEventListener(this);
            this.clock.removeTimeBoundsListener(this);
        }
        if (someObj instanceof CenterListener) {
            this.centerDelegate.remove((CenterListener)someObj);
        }
        if (someObj == this.eventPresenter) {
            this.eventPresenter.removePropertyChangeListener(this);
            this.eventPresenter = null;
        }
        if (someObj == this.aesc) {
            this.aesc.removePropertyChangeListener(this);
            this.aesc = null;
        }
        if (someObj instanceof TimePanel.Wrapper) {
            TimePanel tp = ((TimePanel.Wrapper)someObj).getTimePanel();
            this.removePropertyChangeListener(tp);
            tp.removePropertyChangeListener(this);
        }
    }

    public static double forwardProjectMillis(long time) {
        return (double)time / 60000.0;
    }

    public static long inverseProjectMillis(double timef) {
        return (long)(timef * 60000.0);
    }

    @Override
    public synchronized OMGraphicList prepare() {
        Projection proj = this.getProjection();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Updating projection with " + proj);
        }
        OMGraphicList graphicList = this.getList();
        if (this.getHeight() > 0) {
            OMGraphicList eventGraphicList;
            if (graphicList == null) {
                graphicList = new OMGraphicList();
            } else {
                graphicList.clear();
            }
            this.drape = new TimeSliderLayer.TimeDrape(0, 0, -1, -1);
            this.drape.setFillPaint(Color.gray);
            this.drape.setVisible(this.isNoTime);
            this.drape.generate(proj);
            graphicList.add(this.drape);
            graphicList.add(this.constructTimeLines(proj));
            graphicList.add(this.getCurrentTimeMarker(proj));
            OMGraphicList oMGraphicList = eventGraphicList = this.realTimeMode ? null : this.getEventGraphicList();
            if (eventGraphicList == null || eventGraphicList.isEmpty()) {
                eventGraphicList = this.getEventList(proj);
                this.setEventGraphicList(eventGraphicList);
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("don't need to re-create event lines, haven't changed with (" + eventGraphicList.size() + ") events");
                }
                eventGraphicList.generate(proj);
            }
            this.ratingAreas.generate(proj);
            this.playFilter.generate(proj);
            graphicList.add(this.playFilter);
            graphicList.add(eventGraphicList);
            SelectionArea selectionRenderRect = this.getSelectionRectangle(proj);
            if (selectionRenderRect != null) {
                graphicList.add(selectionRenderRect);
            }
            graphicList.add(this.ratingAreas);
        }
        return graphicList;
    }

    public synchronized OMGraphicList getEventGraphicList() {
        return this.eventGraphicList;
    }

    public synchronized void setEventGraphicList(OMGraphicList eventGraphicList) {
        this.eventGraphicList = eventGraphicList;
    }

    protected OMGraphicList constructTimeLines(Projection projection) {
        OMGraphicList tll = new OMGraphicList();
        this.timeHashFactory = new TimeHashFactory();
        tll.add(this.timeHashFactory.getHashMarks(projection, this.realTimeMode, this.gameStartTime));
        if (!this.isNoTime) {
            this.preTime = new SelectionArea.PreTime(0L);
            this.preTime.generate(projection);
            tll.add(this.preTime);
            this.postTime = new SelectionArea.PostTime(this.gameEndTime - this.gameStartTime);
            this.postTime.generate(projection);
            tll.add(this.postTime);
        }
        this.timeLinesList = tll;
        return tll;
    }

    public SelectionArea getSelectionRectangle(Projection proj) {
        if (this.selectionRect == null) {
            this.selectionRect = new SelectionArea();
            if (this.eventPresenter != null) {
                this.selectionRect.setFillPaint(this.eventPresenter.getSelectionDrawingAttributes().getSelectPaint());
            }
        }
        if (this.selectionRect.isVisible()) {
            SelectionArea selectionRectToRender = new SelectionArea();
            if (this.eventPresenter != null) {
                selectionRectToRender.setFillPaint(this.eventPresenter.getSelectionDrawingAttributes().getSelectPaint());
            }
            selectionRectToRender.setLocation(this.selectionRect.getWestLon(), this.selectionRect.getEastLon());
            selectionRectToRender.generate(proj);
            return selectionRectToRender;
        }
        return null;
    }

    protected OMGraphic getCurrentTimeMarker(Projection proj) {
        this.currentTimeMarker = new CurrentTimeMarker();
        this.currentTimeMarker.generate(proj);
        return this.currentTimeMarker;
    }

    protected OMGraphicList getEventList(Projection projection) {
        OMGraphicList eventGraphicList;
        if (this.eventPresenter != null) {
            if (this.eventPresenter instanceof AbstractEventPresenter) {
                Rectangle bounds = this.getBounds(null);
                Object minutesPnt0 = projection.inverse(0.0, 0.0);
                Object minutesPnt1 = projection.inverse(1.0, 0.0);
                double leftX = bounds.getMinX();
                double rightX = bounds.getMaxX();
                Object minutesPntLeft = projection.inverse(leftX, 0.0);
                Object minutesPntRight = projection.inverse(rightX, 0.0);
                double minutesPerPixel = ((Point2D)minutesPnt1).getX() - ((Point2D)minutesPnt0).getX();
                long step = (long)(minutesPerPixel * 60.0 * 1000.0);
                long start = this.gameStartTime + (long)(((Point2D)minutesPntLeft).getX() * 60.0 * 1000.0);
                long end = this.gameStartTime + (long)(((Point2D)minutesPntRight).getX() * 60.0 * 1000.0);
                eventGraphicList = this.getEventList(((AbstractEventPresenter)this.eventPresenter).getActiveEvents(start, end, step), projection);
            } else {
                eventGraphicList = this.getEventList(this.eventPresenter.getActiveEvents(), projection);
            }
            this.evaluateEventAttributes();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating event lines with (" + eventGraphicList.size() + ") events");
            }
        } else {
            logger.fine("Can't create event list for timeline display, no event presenter");
            eventGraphicList = new OMGraphicList();
        }
        return eventGraphicList;
    }

    protected OMGraphicList getEventList(Iterator<OMEvent> it, Projection projection) {
        OMGraphicList eventGraphicList = new OMGraphicList();
        if (projection != null) {
            BasicStroke symbolStroke = new BasicStroke(2.0f);
            while (it.hasNext()) {
                OMEvent event = it.next();
                long time = event.getTimeStamp() - this.gameStartTime;
                float lon = (float)TimelineLayer.forwardProjectMillis(time);
                EventMarkerLine currentLine = new EventMarkerLine(0.0, lon, 6);
                currentLine.setLinePaint(Color.black);
                currentLine.setStroke(symbolStroke);
                currentLine.generate(projection);
                currentLine.putAttribute(ATT_KEY_EVENT, event);
                eventGraphicList.add(currentLine);
            }
        }
        return eventGraphicList;
    }

    @Override
    public Component getGUI() {
        if (this.palette == null) {
            logger.fine("creating Palette.");
            this.palette = Box.createVerticalBox();
            JPanel subbox3 = new JPanel(new GridLayout(0, 1));
            JButton setProperties = new JButton(this.i18n.get(TimelineLayer.class, "setProperties", "Preferences"));
            setProperties.setActionCommand("displayPropertiesCmd");
            setProperties.addActionListener(this);
            subbox3.add(setProperties);
            this.palette.add(subbox3);
        }
        return this.palette;
    }

    @Override
    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (!this.doAction(omg, action)) {
            this.setList(new OMGraphicList());
            this.doAction(omg, action);
        }
        this.repaint();
    }

    @Override
    public boolean isSelectable(OMGraphic omg) {
        return false;
    }

    @Override
    public String getName() {
        return "TimelineLayer";
    }

    protected void setTimeBounds(long start, long end) {
        if (this.gameStartTime != start || this.gameEndTime != end) {
            this.gameStartTime = start;
            this.gameEndTime = end;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("gst: " + this.gameStartTime + ", get: " + this.gameEndTime + ", bounds of " + this.postTime);
            }
            if (this.realTimeMode) {
                this.setEventGraphicList(null);
            }
            if (!this.realTimeMode || !this.timeSliderLayer.getUserHasChangedScale()) {
                this.setMapBeanMaxScale(true);
            }
        }
    }

    @Override
    public void updateTimeBounds(TimeBoundsEvent tbe) {
        TimeBounds tb = tbe.getNewTimeBounds();
        if (tb != null) {
            long oldStartTime = this.gameStartTime;
            this.setTimeBounds(tb.getStartTime(), tb.getEndTime());
            if (this.realTimeMode) {
                long boundsStartOffset = tb.getStartTime() - oldStartTime;
                this.currentTime -= boundsStartOffset;
                ((Proj)this.getProjection()).setCenter(0.0, TimelineLayer.forwardProjectMillis(this.currentTime));
                this.centerDelegate.fireCenter(0.0, TimelineLayer.forwardProjectMillis(this.currentTime));
                this.timeLinesList = null;
            }
            if (this.realTimeMode && this.selectionRect != null && this.selectionRect.isVisible()) {
                long boundsWestDelta = tbe.getNewTimeBounds().getStartTime() - tbe.getOldTimeBounds().getStartTime();
                double selectionDelta = (double)boundsWestDelta / 60000.0;
                double newWest = this.selectionRect.getWestLon() - selectionDelta;
                double newEast = this.selectionRect.getEastLon() - selectionDelta;
                this.selectionRect.setLocation(newWest, newEast);
                this.getSelectionRectangle(this.getProjection());
            }
        } else {
            this.checkAndSetForNoTime(TimeEvent.NO_TIME);
            this.timeSliderLayer.setSelectionValid(false);
        }
        if (tbe.isInduceGraphicalUpdate()) {
            this.doPrepare();
        }
    }

    @Override
    public void updateTime(TimeEvent te) {
        if (this.checkAndSetForNoTime(te)) {
            return;
        }
        Clock clock = (Clock)te.getSource();
        this.setTimeBounds(clock.getStartTime(), clock.getEndTime());
        TimerStatus timerStatus = te.getTimerStatus();
        if (timerStatus.equals(TimerStatus.STEP_FORWARD) || timerStatus.equals(TimerStatus.STEP_BACKWARD) || timerStatus.equals(TimerStatus.UPDATE)) {
            this.currentTime = te.getSystemTime() - this.gameStartTime;
            ((Proj)this.getProjection()).setCenter(0.0, TimelineLayer.forwardProjectMillis(this.currentTime));
            this.centerDelegate.fireCenter(0.0, TimelineLayer.forwardProjectMillis(this.currentTime));
            this.timeLinesList = null;
            this.doPrepare();
        } else if (timerStatus.equals(TimerStatus.FORWARD) || timerStatus.equals(TimerStatus.BACKWARD) || timerStatus.equals(TimerStatus.STOPPED)) {
            long currentTime;
            if (clock.isRunning() && this.playFilter.reactToCurrentTime(currentTime = te.getSystemTime() - this.gameStartTime, clock, this.gameStartTime)) {
                this.currentTime = currentTime;
                this.timeLinesList = null;
                this.centerDelegate.fireCenter(0.0, TimelineLayer.forwardProjectMillis(currentTime));
                this.doPrepare();
            }
        } else {
            logger.info("none of the above: " + timerStatus.toString());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == "activeEvents") {
            this.setEventGraphicList(null);
            logger.fine("EventPresenter updated event list, calling doPrepare() " + evt.getNewValue());
            this.doPrepare();
        } else if (propertyName == "eventsSelected") {
            this.setSelectionRectangleToEvents();
        } else if (propertyName == "eventAttributesUpdated") {
            this.evaluateEventAttributes();
            this.doPrepare();
        } else if (propertyName == PlayFilterProperty) {
            boolean inUse = (Boolean)evt.getNewValue();
            this.playFilter.setInUse(inUse);
            this.firePropertyChange(PlayFilterProperty, null, new Boolean(!inUse || !this.playFilter.isEmpty()));
        } else {
            logger.finer("AAGGH: " + propertyName);
        }
    }

    protected boolean checkAndSetForNoTime(TimeEvent te) {
        this.isNoTime = te == TimeEvent.NO_TIME;
        return this.isNoTime;
    }

    double snapToEvent(double lon) {
        if (this.realTimeMode) {
            return lon;
        }
        double retVal = lon;
        double minDiff = Double.MAX_VALUE;
        if (this.eventPresenter != null) {
            Iterator<OMEvent> it = this.eventPresenter.getAllEvents();
            while (it.hasNext()) {
                OMEvent event = it.next();
                long time = event.getTimeStamp() - this.gameStartTime;
                float timeMinutes = (float)TimelineLayer.forwardProjectMillis(time);
                if (!(Math.abs((double)timeMinutes - lon) < minDiff)) continue;
                minDiff = Math.abs((double)timeMinutes - lon);
                retVal = timeMinutes;
            }
        }
        return retVal;
    }

    @Override
    public MapMouseListener getMapMouseListener() {
        return this;
    }

    @Override
    public String[] getMouseModeServiceList() {
        return this.getMouseModeIDsForEvents();
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        this.doubleClick = false;
        this.updateMouseTimeDisplay(e);
        Projection projection = this.getProjection();
        Object latLong = projection.inverse(e.getPoint());
        Object ul = projection.getUpperLeft();
        Object lr = projection.getLowerRight();
        double lon = ((Point2D)latLong).getX();
        float up = (float)((Point2D)ul).getY();
        float down = (float)((Point2D)lr).getY();
        lon = this.snapToEvent(lon);
        this.selectionRect.setVisible(false);
        this.selectionRect.setLocation(up, (float)lon, down, (float)lon, 1);
        this.selectionRect.generate(projection);
        this.timeSliderLayer.setSelectionValid(false);
        this.downLon = lon;
        return true;
    }

    protected void selectEventForMouseEvent(MouseEvent e) {
        OMEvent sourceEvent;
        OMGraphic omg;
        OMGraphicList eventGraphicList = this.getEventGraphicList();
        if (e != null && eventGraphicList != null && (omg = (OMGraphic)eventGraphicList.findClosest(e.getX(), e.getY(), 4.0f)) != null && (sourceEvent = (OMEvent)omg.getAttribute(ATT_KEY_EVENT)) != null) {
            sourceEvent.putAttribute("SELECTED", "SELECTED");
            if (this.aesc != null) {
                Vector<OMEvent> eventList = new Vector<OMEvent>();
                eventList.add(sourceEvent);
                this.aesc.eventsSelected(eventList);
            }
        }
        this.doubleClick = false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        this.handleEventSelection();
        if (this.scrollTask != null) {
            this.scrollTask.cancel();
            this.scrollTask = null;
        }
        return true;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.selectEventForMouseEvent(e);
            this.doubleClick = true;
            return true;
        }
        double lon = this.updateMouseTimeDisplay(e);
        if (this.clock != null) {
            this.clock.setTime(this.gameStartTime + TimelineLayer.inverseProjectMillis(lon));
        }
        this.timeSliderLayer.clearFixedRenderRange();
        this.selectionRect.setLocation(lon, lon);
        this.selectionRect.setVisible(false);
        this.timeSliderLayer.setSelectionValid(false);
        return true;
    }

    protected double updateMouseTimeDisplay(MouseEvent e) {
        Projection proj = this.getProjection();
        Object latLong = proj.inverse(e.getPoint());
        double lon = ((Point2D)latLong).getX();
        double endTime = TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime);
        if (lon < 0.0) {
            lon = -1.0;
        } else if (lon > endTime) {
            lon = endTime;
        }
        long offsetMillis = TimelineLayer.inverseProjectMillis(lon);
        this.updateMouseTimeDisplay(new Long(offsetMillis));
        return lon < 0.0 ? 0.0 : lon;
    }

    public void updateMouseTimeDisplay(Long offsetMillis) {
        this.firePropertyChange(MouseTimeProperty, null, offsetMillis);
    }

    protected void updateEventDetails(MouseEvent e) {
        OMEvent sourceEvent;
        OMGraphic omg;
        String details = "";
        OMGraphicList eventGraphicList = this.getEventGraphicList();
        if (e != null && eventGraphicList != null && (omg = (OMGraphic)eventGraphicList.findClosest(e.getX(), e.getY(), 4.0f)) != null && (sourceEvent = (OMEvent)omg.getAttribute(ATT_KEY_EVENT)) != null) {
            details = sourceEvent.getDescription();
        }
        this.firePropertyChange(EventDetailsProperty, null, details);
    }

    protected void updateEventDetails() {
        this.updateEventDetails(null);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.firePropertyChange(MouseTimeProperty, null, new Long(-1L));
        this.updateEventDetails();
    }

    private void adjustSelection(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        this.updateEventDetails(e);
        this.timeSliderLayer.clearFixedRenderRange();
        Projection proj = this.getProjection();
        Object latLong = proj.inverse(e.getPoint());
        double lon = this.snapToEvent(((Point2D)latLong).getX());
        float west = (float)Math.min(this.downLon, lon);
        float east = (float)Math.max(this.downLon, lon);
        this.selectionRect.setVisible(true);
        this.selectionRect.setLocation(west, east);
        this.selectionRect.generate(proj);
        this.timeSliderLayer.setSelectionValid(east != west);
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        this.adjustSelection(e);
        Projection proj = this.getProjection();
        long scrollPeriod = 50L;
        float baseScrollMultiplier = 0.001f;
        int x = e.getPoint().x;
        if (this.scrollTask != null) {
            this.scrollTask.cancel();
            this.scrollTask = null;
        }
        float scale = proj.getScale();
        if (x < 0) {
            if (this.clock != null) {
                float multiplier = baseScrollMultiplier * (float)x;
                long delta = (long)(multiplier * scale);
                this.scrollTask = new ScrollTask(delta, e);
                this.scrollTimer.schedule((TimerTask)this.scrollTask, 0L, 50L);
            }
        } else if (x > this.getWidth() && this.clock != null) {
            float multiplier = baseScrollMultiplier * (float)(x - this.getWidth());
            long delta = (long)(multiplier * scale);
            this.scrollTask = new ScrollTask(delta, e);
            this.scrollTimer.schedule((TimerTask)this.scrollTask, 0L, 50L);
        }
        this.doPrepare();
        return true;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        this.updateEventDetails(e);
        return true;
    }

    @Override
    public void mouseMoved() {
        this.updateEventDetails();
    }

    protected List<OMEvent> handleEventSelection() {
        Vector<OMEvent> eventList = null;
        if (this.aesc != null && this.selectionRect != null) {
            long upperTimeStamp;
            boolean goodDrag = this.selectionRect.isVisible();
            double lowerTime = this.selectionRect.getWestLon();
            double upperTime = this.selectionRect.getEastLon();
            long lowerTimeStamp = TimelineLayer.inverseProjectMillis((float)lowerTime);
            boolean sameTime = lowerTimeStamp == (upperTimeStamp = TimelineLayer.inverseProjectMillis((float)upperTime));
            goodDrag = goodDrag && !sameTime;
            boolean labeledRangeStart = false;
            OMEvent lastEventLabeled = null;
            Iterator<OMEvent> it = this.eventPresenter.getAllEvents();
            while (it.hasNext()) {
                if (eventList == null) {
                    eventList = new Vector<OMEvent>();
                }
                OMEvent event = it.next();
                double timeStamp = event.getTimeStamp() - this.gameStartTime;
                event.putAttribute("SELECTED", null);
                if (goodDrag && timeStamp >= (double)lowerTimeStamp && timeStamp <= (double)upperTimeStamp) {
                    eventList.add(event);
                    if (!labeledRangeStart && lowerTimeStamp != upperTimeStamp) {
                        event.putAttribute("SELECTED", "AVSSR");
                        labeledRangeStart = true;
                    } else {
                        event.putAttribute("SELECTED", "SELECTED");
                    }
                    lastEventLabeled = event;
                    continue;
                }
                if (sameTime && timeStamp != (double)lowerTimeStamp) continue;
            }
            if (labeledRangeStart && lastEventLabeled != null) {
                lastEventLabeled.putAttribute("SELECTED", "AVSER");
            }
            this.aesc.eventsSelected(eventList);
        }
        return eventList;
    }

    protected void evaluateEventAttributes() {
        if (this.realTimeMode) {
            return;
        }
        this.ratingAreas.clear();
        this.playFilter.clear();
        SelectionArea.RatingArea currentRatingArea = null;
        SelectionArea.PlayFilterSection currentPlayFilter = null;
        if (this.eventPresenter != null) {
            Iterator<OMEvent> it = this.eventPresenter.getAllEvents();
            while (it.hasNext()) {
                OMEvent aare = it.next();
                String rating = (String)aare.getAttribute("RATING");
                Object playFilterObj = aare.getAttribute("PLAY_FILTER");
                long timeStamp = aare.getTimeStamp() - this.gameStartTime;
                if (rating != null) {
                    if (currentRatingArea != null && !currentRatingArea.isRating(rating)) {
                        currentRatingArea = null;
                    }
                    if (currentRatingArea == null) {
                        currentRatingArea = new SelectionArea.RatingArea(timeStamp, rating);
                        this.ratingAreas.add(currentRatingArea);
                    }
                    currentRatingArea.addTime(timeStamp);
                } else if (currentRatingArea != null) {
                    currentRatingArea = null;
                }
                if (playFilterObj != null) {
                    if (currentPlayFilter != null) {
                        currentPlayFilter.addTime(timeStamp);
                        continue;
                    }
                    currentPlayFilter = new SelectionArea.PlayFilterSection(timeStamp);
                    this.playFilter.add(currentPlayFilter);
                    continue;
                }
                currentPlayFilter = null;
            }
            OMGraphicList list = this.getList();
            if (list != null && list.isVisible()) {
                this.firePropertyChange(PlayFilterProperty, null, new Boolean(!this.playFilter.isInUse() || !this.playFilter.isEmpty()));
            }
        }
    }

    protected void setSelectionRectangleToEvents() {
        if (this.aesc != null) {
            this.selectionRect = this.getSelectionRectangle(this.getProjection());
            double lowerTime = Double.POSITIVE_INFINITY;
            double upperTime = Double.NEGATIVE_INFINITY;
            Iterator<OMEvent> it = this.eventPresenter.getAllEvents();
            while (it.hasNext()) {
                OMEvent event = it.next();
                if (event.getAttribute("SELECTED") == null) continue;
                double timeStamp = TimelineLayer.forwardProjectMillis(event.getTimeStamp() - this.gameStartTime);
                if (timeStamp < lowerTime) {
                    lowerTime = timeStamp;
                }
                if (!(timeStamp > upperTime)) continue;
                upperTime = timeStamp;
            }
            if (upperTime != Double.NEGATIVE_INFINITY && lowerTime != Double.POSITIVE_INFINITY) {
                this.selectionRect.setLocation((float)lowerTime, (float)upperTime);
                this.selectionRect.setVisible(true);
                this.selectionRect.generate(this.getProjection());
            } else {
                this.selectionRect.setVisible(false);
            }
        }
        this.doPrepare();
    }

    protected void setMapBeanMaxScale(boolean setScaleToMax) {
        float scale = (float)(TimeSliderLayer.magicScaleFactor * TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime) / (double)this.getProjection().getWidth());
        MapBean mb = ((MapHandler)this.getBeanContext()).get(MapBean.class);
        ((Cartesian)mb.getProjection()).setMaxScale(scale);
        if (setScaleToMax) {
            mb.setScale(scale);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setMapBeanMaxScale(false);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        block2: {
            try {
                super.paint(g);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void setRealTimeMode(boolean realTimeMode) {
        this.realTimeMode = realTimeMode;
    }

    public long getDuration() {
        return this.gameEndTime - this.gameStartTime;
    }

    public long getEndTime() {
        return this.gameEndTime;
    }

    public void setUserHasChangedScale(boolean userHasChangedScale) {
        this.timeSliderLayer.setUserHasChangedScale(userHasChangedScale);
    }

    public void adjustZoomFromMouseWheel(int rot) {
        this.timeSliderLayer.adjustZoomFromMouseWheel(rot);
        this.doPrepare();
    }

    long getSelectionStart() {
        long upperTimeStamp;
        boolean goodDrag = this.selectionRect.isVisible();
        double lowerTime = this.selectionRect.getWestLon();
        double upperTime = this.selectionRect.getEastLon();
        long lowerTimeStamp = TimelineLayer.inverseProjectMillis((float)lowerTime);
        boolean sameTime = lowerTimeStamp == (upperTimeStamp = TimelineLayer.inverseProjectMillis((float)upperTime));
        goodDrag = goodDrag && !sameTime;
        return goodDrag ? lowerTimeStamp + this.gameStartTime : -1L;
    }

    long getSelectionEnd() {
        long upperTimeStamp;
        boolean goodDrag = this.selectionRect.isVisible();
        double lowerTime = this.selectionRect.getWestLon();
        double upperTime = this.selectionRect.getEastLon();
        long lowerTimeStamp = TimelineLayer.inverseProjectMillis((float)lowerTime);
        boolean sameTime = lowerTimeStamp == (upperTimeStamp = TimelineLayer.inverseProjectMillis((float)upperTime));
        goodDrag = goodDrag && !sameTime;
        return goodDrag ? upperTimeStamp + this.gameStartTime : -1L;
    }

    public void clearSelection() {
        this.selectionRect.setLocation(0.0, 0.0);
        this.selectionRect.setVisible(false);
        this.timeSliderLayer.setSelectionValid(false);
        this.timeSliderLayer.clearFixedRenderRange();
    }

    public static abstract class TimeHashMarks
    extends OMGraphicList {
        protected String annotation;
        protected double unitPerMinute;
        protected DateFormat dateFormat;

        protected TimeHashMarks(String annotation, double unitPerMinute, DateFormat dateFormat) {
            this.annotation = annotation;
            this.unitPerMinute = unitPerMinute;
            this.dateFormat = dateFormat;
        }

        public abstract boolean passesThreshold(double var1);

        public boolean generate(Projection proj, boolean realTimeMode, double timeSpanMinutes, long gameStartTimeMillis) {
            Object ul = proj.getUpperLeft();
            Object lr = proj.getLowerRight();
            double left = ((Point2D)ul).getX() * this.unitPerMinute;
            double right = ((Point2D)lr).getX() * this.unitPerMinute;
            double timeSpan = timeSpanMinutes * this.unitPerMinute;
            double num = Math.floor(timeSpan);
            double heightStepSize = 1.0;
            double stepSize = 1.0;
            if (num < 2.0) {
                stepSize = 0.25;
            } else if (num < 5.0) {
                stepSize = 0.5;
            } else if (num > 30.0) {
                stepSize = 10.0;
                heightStepSize = 10.0;
            } else if (num > 15.0) {
                heightStepSize = 10.0;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("figure on needing " + num + this.annotation + ", " + stepSize + " stepsize for " + timeSpan / stepSize + " lines");
            }
            int height = (int)((double)proj.getHeight() * 0.2);
            double anchory = ((Point2D)lr).getY();
            if (realTimeMode) {
                double firstMarkerOffsetUnits;
                double millisPerUnit = (long)(60000.0 / this.unitPerMinute);
                double gameStartTimeUnits = (double)gameStartTimeMillis / millisPerUnit;
                double firstMarkerOffsetMillis = (double)gameStartTimeMillis % millisPerUnit;
                if (left < 0.0) {
                    for (firstMarkerOffsetUnits = firstMarkerOffsetMillis / millisPerUnit; firstMarkerOffsetUnits > left; firstMarkerOffsetUnits -= stepSize) {
                    }
                }
                while (firstMarkerOffsetUnits < left) {
                    firstMarkerOffsetUnits += stepSize;
                }
                double stepStart = Math.floor(firstMarkerOffsetUnits + gameStartTimeUnits);
                double stepEnd = Math.ceil(right + gameStartTimeUnits);
                int count = 0;
                double i = stepStart;
                while (i < stepEnd) {
                    double anchorx = (i - gameStartTimeUnits) / this.unitPerMinute;
                    int thisHeight = height;
                    boolean doLabel = true;
                    if ((double)count % heightStepSize != 0.0) {
                        thisHeight /= 2;
                        doLabel = false;
                    }
                    OMLine currentLine = new OMLine(anchory, anchorx, 0, 0, 0, -thisHeight);
                    currentLine.setLinePaint(tint);
                    currentLine.setStroke(new BasicStroke(2.0f));
                    this.add(currentLine);
                    if (doLabel) {
                        Date date = new Date((long)(i * millisPerUnit));
                        String labelString = this.dateFormat.format(date);
                        OMText label = new OMText((float)anchory, (float)anchorx, 2.0f, -5.0f, labelString, 0);
                        label.setLinePaint(tint);
                        this.add(label);
                    }
                    i += stepSize;
                    ++count;
                }
            } else {
                double start;
                if (left < 0.0) {
                    for (start = 0.0; start > left; start -= stepSize) {
                    }
                }
                while (start < left) {
                    start += stepSize;
                }
                double stepStart = Math.floor(start);
                double stepEnd = Math.ceil(right);
                for (double i = stepStart; i < stepEnd; i += stepSize) {
                    double anchorx = i / this.unitPerMinute;
                    int thisHeight = height;
                    boolean doLabel = true;
                    if (i % heightStepSize != 0.0) {
                        thisHeight /= 2;
                        doLabel = false;
                    }
                    OMLine currentLine = new OMLine(anchory, anchorx, 0, 0, 0, -thisHeight);
                    currentLine.setLinePaint(tint);
                    currentLine.setStroke(new BasicStroke(2.0f));
                    this.add(currentLine);
                    if (!doLabel) continue;
                    OMText label = new OMText((float)anchory, (float)anchorx, 2.0f, -5.0f, (int)i + this.annotation, 0);
                    label.setLinePaint(tint);
                    this.add(label);
                }
            }
            return super.generate(proj);
        }

        public static class Years
        extends TimeHashMarks {
            public Years() {
                super("y", 1.9025875190258753E-6, TimePanel.dayFormat);
            }

            public boolean passesThreshold(double minVisibleOnTimeLine) {
                return minVisibleOnTimeLine / 60.0 / 24.0 / 365.0 > 1.0;
            }
        }

        public static class Days
        extends TimeHashMarks {
            public Days() {
                super("d", 6.944444444444445E-4, TimePanel.dayFormat);
            }

            public boolean passesThreshold(double minVisibleOnTimeLine) {
                return minVisibleOnTimeLine / 60.0 / 24.0 > 2.0;
            }
        }

        public static class Hours
        extends TimeHashMarks {
            public Hours() {
                super("h", 0.016666666666666666, new SimpleDateFormat("HH:mm:ss"));
            }

            public boolean passesThreshold(double minVisibleOnTimeLine) {
                return minVisibleOnTimeLine / 60.0 > 3.0;
            }
        }

        public static class Minutes
        extends TimeHashMarks {
            public Minutes() {
                super("m", 1.0, new SimpleDateFormat("HH:mm:ss"));
            }

            public boolean passesThreshold(double minVisibleOnTimeLine) {
                return minVisibleOnTimeLine > 2.0;
            }
        }

        public static class Seconds
        extends TimeHashMarks {
            public Seconds() {
                super("s", 60.0, new SimpleDateFormat("HH:mm:ss.SS"));
            }

            public boolean passesThreshold(double minVisibleOnTimeLine) {
                return true;
            }
        }
    }

    public static class PlayFilter
    extends OMGraphicList {
        protected boolean inUse = false;
        String currentlyPlaying = null;

        public boolean reactToCurrentTime(long currentTime, Clock clock, long gameStartTime) {
            boolean ret;
            boolean bl = ret = !this.inUse;
            if (this.inUse) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    SelectionArea.PlayFilterSection pfs = (SelectionArea.PlayFilterSection)it.next();
                    int where = pfs.isWithin(currentTime);
                    if (where == 0) {
                        ret = true;
                        this.currentlyPlaying = pfs.toString();
                        break;
                    }
                    if (where > 0) {
                        if ((this.currentlyPlaying == null || !this.currentlyPlaying.equals(pfs.toString())) && it.hasNext()) continue;
                        clock.setTime(gameStartTime + TimelineLayer.inverseProjectMillis(pfs.getEastLon()));
                        clock.stopClock();
                        this.currentlyPlaying = null;
                        break;
                    }
                    clock.setTime(gameStartTime + TimelineLayer.inverseProjectMillis(pfs.getWestLon()));
                    break;
                }
            }
            return ret;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public void setInUse(boolean inUse) {
            this.inUse = inUse;
        }
    }

    public static class TimeHashFactory {
        List<TimeHashMarks> hashMarks = new ArrayList<TimeHashMarks>(5);
        TimeHashMarks current;

        public TimeHashFactory() {
            this.hashMarks.add(new TimeHashMarks.Seconds());
            this.hashMarks.add(new TimeHashMarks.Minutes());
            this.hashMarks.add(new TimeHashMarks.Hours());
            this.hashMarks.add(new TimeHashMarks.Days());
            this.hashMarks.add(new TimeHashMarks.Years());
        }

        public OMGraphicList getHashMarks(Projection proj, boolean realTimeMode, long gameStartTimeMillis) {
            Object ul = proj.getUpperLeft();
            Object lr = proj.getLowerRight();
            double timeSpan = ((Point2D)lr).getX() - ((Point2D)ul).getX();
            TimeHashMarks thm = null;
            for (TimeHashMarks cthm : this.hashMarks) {
                if (!cthm.passesThreshold(timeSpan)) break;
                thm = cthm;
            }
            if (this.current != null) {
                this.current.clear();
            }
            if (thm != this.current) {
                this.current = thm;
            }
            this.current.generate(proj, realTimeMode, timeSpan, gameStartTimeMillis);
            return this.current;
        }
    }

    public static class CurrentTimeMarker
    extends OMGraphicList {
        protected OMRaster upperMark;
        protected OMRaster lowerMark;
        protected OMLine startingLine;
        int iconSize = 16;
        int lastHeight = 0;
        int lastWidth = 0;

        public CurrentTimeMarker() {
            DrawingAttributes da = new DrawingAttributes();
            da.setFillPaint(tint);
            da.setLinePaint(tint);
            BasicIconPart ip = new BasicIconPart((Shape)new Polygon(new int[]{50, 90, 10, 50}, new int[]{10, 90, 90, 10}, 4), da);
            ImageIcon thumbsUpImage = OMIconFactory.getIcon(this.iconSize, this.iconSize, ip);
            this.lowerMark = new OMRaster(0, 0, thumbsUpImage);
            ip = new BasicIconPart((Shape)new Polygon(new int[]{10, 90, 50, 10}, new int[]{10, 10, 90, 10}, 4), da);
            ImageIcon thumbsDownImage = OMIconFactory.getIcon(this.iconSize, this.iconSize, ip);
            this.upperMark = new OMRaster(0, 0, thumbsDownImage);
            this.startingLine = new OMLine(0, 0, 0, 0);
            da.setTo(this.startingLine);
            this.add(this.startingLine);
            this.add(this.lowerMark);
            this.add(this.upperMark);
        }

        public boolean generate(Projection proj) {
            int height = proj.getHeight();
            int width = proj.getWidth();
            if (height != this.lastHeight || width != this.lastWidth) {
                this.lastHeight = height;
                this.lastWidth = width;
                int halfX = width / 2;
                this.upperMark.setX(halfX - this.iconSize / 2);
                this.upperMark.setY(0);
                this.lowerMark.setX(halfX - this.iconSize / 2);
                this.lowerMark.setY(height - this.iconSize);
                int[] pts = this.startingLine.getPts();
                pts[0] = halfX;
                pts[1] = 0 + this.iconSize;
                pts[2] = halfX;
                pts[3] = height - this.iconSize;
            }
            return super.generate(proj);
        }
    }

    public static class SelectionArea
    extends OMRect {
        public SelectionArea() {
            this.setRenderType(1);
        }

        public void setLocation(double left, double right) {
            super.setLocation(0.0, left, 0.0, right, 1);
        }

        public boolean generate(Projection proj) {
            this.updateY(proj);
            return super.generate(proj);
        }

        protected void updateY(Projection proj) {
            Object ul = proj.getUpperLeft();
            Object lr = proj.getLowerRight();
            this.lat1 = ((Point2D)ul).getY();
            this.lat2 = ((Point2D)lr).getY();
        }

        public static class PlayFilterSection
        extends SelectionArea {
            protected static Color color = new Color(-1728053248, true);
            protected String idString;

            public PlayFilterSection(long time) {
                double timef = TimelineLayer.forwardProjectMillis(time);
                this.setLocation(timef, timef);
                this.setLinePaint(color);
                this.setFillPaint(color);
            }

            public int isWithin(long timel) {
                double time = TimelineLayer.forwardProjectMillis(timel);
                int ret = -1;
                if (time >= this.getWestLon()) {
                    ++ret;
                }
                if (time > this.getEastLon()) {
                    ++ret;
                }
                return ret;
            }

            protected void updateY(Projection proj) {
                Object ul = proj.getUpperLeft();
                this.lat1 = ((Point2D)ul).getY();
                Object lrpt = proj.inverse(0.0, proj.getHeight() / 8);
                this.lat2 = ((Point2D)lrpt).getY();
                this.idString = null;
            }

            public void addTime(long timeToAdd) {
                double time = TimelineLayer.forwardProjectMillis(timeToAdd);
                double east = this.getEastLon();
                double west = this.getWestLon();
                boolean updated = false;
                if (time < west) {
                    west = time;
                    updated = true;
                }
                if (time > east) {
                    east = time;
                    updated = true;
                }
                if (updated) {
                    this.setLocation(west, east);
                    this.idString = null;
                }
            }

            public String toString() {
                if (this.idString == null) {
                    this.idString = "PlayFilterSection[" + this.getWestLon() + "," + this.getEastLon() + "]";
                }
                return this.idString;
            }
        }

        public static class RatingArea
        extends SelectionArea {
            protected String rating;
            protected static Color goodColor = new Color(-1727987968, true);
            protected static Color badColor = new Color(-1711341568, true);

            public RatingArea(long time, String rating) {
                this.rating = rating;
                double timef = TimelineLayer.forwardProjectMillis(time);
                this.setLocation(timef, timef);
                Color ratingColor = badColor;
                if (rating.equals("+")) {
                    ratingColor = goodColor;
                }
                this.setLinePaint(ratingColor);
                this.setFillPaint(ratingColor);
            }

            public boolean isRating(String rating) {
                return this.rating == rating || this.rating.equalsIgnoreCase(rating);
            }

            public void addTime(long timeToAdd) {
                double time = TimelineLayer.forwardProjectMillis(timeToAdd);
                double east = this.getEastLon();
                double west = this.getWestLon();
                boolean updated = false;
                if (time < west) {
                    west = time;
                    updated = true;
                }
                if (time > east) {
                    east = time;
                    updated = true;
                }
                if (updated) {
                    this.setLocation(west, east);
                }
            }
        }

        public static class PostTime
        extends SelectionArea {
            public PostTime(long time) {
                this.lon1 = TimelineLayer.forwardProjectMillis(time);
                this.setFillPaint(tint);
                this.setLinePaint(tint);
            }

            public void setLocation() {
            }

            public boolean generate(Projection proj) {
                Object lr = proj.getLowerRight();
                double lrx = ((Point2D)lr).getX();
                this.lon2 = lrx <= this.lon1 ? this.lon1 : lrx;
                return super.generate(proj);
            }
        }

        public static class PreTime
        extends SelectionArea {
            public PreTime(long time) {
                this.lon2 = TimelineLayer.forwardProjectMillis(time);
                this.setFillPaint(tint);
                this.setLinePaint(tint);
            }

            public void setLocation() {
            }

            public boolean generate(Projection proj) {
                Object ul = proj.getUpperLeft();
                double ulx = ((Point2D)ul).getX();
                this.lon1 = ulx >= this.lon2 ? this.lon2 : ulx;
                return super.generate(proj);
            }
        }
    }

    class ScrollTask
    extends TimerTask {
        private long delta;
        private MouseEvent mouseEvent;

        ScrollTask(long delta, MouseEvent mouseEvent) {
            this.delta = delta;
            this.mouseEvent = mouseEvent;
        }

        public void run() {
            if (TimelineLayer.this.clock != null) {
                long newTime = TimelineLayer.this.clock.getTime() + this.delta;
                newTime = Math.max(TimelineLayer.this.gameStartTime, newTime);
                newTime = Math.min(TimelineLayer.this.gameEndTime, newTime);
                TimelineLayer.this.clock.setTime(newTime);
                TimelineLayer.this.adjustSelection(this.mouseEvent);
                TimelineLayer.this.doPrepare();
            }
        }
    }

    public class EventMarkerLine
    extends OMLine {
        protected int heightRatioSetting;
        protected byte symbolHeight;

        public EventMarkerLine(double lat, double lon, int heightRatioSetting) {
            super(lat, lon, 0, 1, 0, -1);
            this.heightRatioSetting = heightRatioSetting;
        }

        public boolean generate(Projection proj) {
            byte testSH = (byte)(proj.getHeight() * 2 / this.heightRatioSetting);
            if (testSH != this.symbolHeight) {
                int symbolHeight;
                int[] pts = this.getPts();
                pts[1] = symbolHeight = proj.getHeight() / this.heightRatioSetting;
                pts[3] = -symbolHeight;
                this.symbolHeight = (byte)symbolHeight;
            }
            return super.generate(proj);
        }
    }
}

