/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.LightMapHandlerChild;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.MenuBarMenu;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public abstract class AbstractOpenMapMenu
extends JMenu
implements BeanContextChild,
BeanContextMembershipListener,
PropertyConsumer,
MenuBarMenu,
LightMapHandlerChild {
    protected I18n i18n = Environment.getI18n();
    protected BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport();
    protected String propertyPrefix = null;
    protected Hashtable items = null;
    public static final String ItemsProperty = "items";
    public static final String SeparatorProperty = "sep";
    public static final String PrettyNameProperty = "prettyName";
    public static final String MnemonicProperty = "mnemonic";
    protected String itemsPropertyContents = null;
    protected Hashtable itemsProperties = null;

    public AbstractOpenMapMenu() {
    }

    public AbstractOpenMapMenu(String title) {
        super(title);
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        this.beanContextChildSupport.setBeanContext(in_bc);
        if (in_bc == null) {
            return;
        }
        in_bc.addBeanContextMembershipListener(this);
        this.findAndInit(in_bc);
        this.findAndInit(in_bc.iterator());
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        this.findAndUndo(bcme.iterator());
    }

    public void findAndUndo(Iterator it) {
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        Component[] menuItems = this.getMenuComponents();
        for (int i = 0; i < menuItems.length; ++i) {
            Component item = menuItems[i];
            if (!(item instanceof LightMapHandlerChild)) continue;
            ((LightMapHandlerChild)((Object)item)).findAndUndo(someObj);
        }
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object someObj) {
        Component[] menuItems = this.getMenuComponents();
        for (int i = 0; i < menuItems.length; ++i) {
            Component item = menuItems[i];
            if (!(item instanceof LightMapHandlerChild)) continue;
            ((LightMapHandlerChild)((Object)item)).findAndInit(someObj);
        }
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    public MapHandler getMapHandler() {
        return (MapHandler)this.beanContextChildSupport.getBeanContext();
    }

    public void setProperties(Properties props) {
        this.setProperties(this.getPropertyPrefix(), props);
    }

    public void setProperties(String prefix, Properties props) {
        String mnemonicString;
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String prettyName = props.getProperty(realPrefix + PrettyNameProperty);
        if (prettyName != null) {
            this.setText(prettyName);
        }
        if ((mnemonicString = props.getProperty(realPrefix + MnemonicProperty)) != null) {
            this.setMnemonic((int)mnemonicString.charAt(0));
        }
        this.itemsPropertyContents = props.getProperty(realPrefix + ItemsProperty);
        Vector<String> menuItems = PropUtils.parseSpacedMarkers(this.itemsPropertyContents);
        if (!menuItems.isEmpty()) {
            int nMenuItems = menuItems.size();
            if (Debug.debugging("menu")) {
                Debug.output("Menu " + this.getText() + " created with " + nMenuItems + " item" + (nMenuItems == 1 ? "" : "s") + " in properties");
            }
            for (int i = 0; i < nMenuItems; ++i) {
                String itemPrefix = menuItems.elementAt(i);
                if (itemPrefix.equals(SeparatorProperty)) {
                    this.add(new JSeparator());
                    continue;
                }
                String classProperty = itemPrefix + ".class";
                String className = props.getProperty(classProperty);
                if (className == null) {
                    Debug.error("Menu " + this.getText() + ".setProperties(): Failed to locate property \"" + classProperty + "\"\n  Skipping menu item \"" + itemPrefix + "\"");
                    continue;
                }
                if (this.itemsProperties == null) {
                    this.itemsProperties = new Properties();
                }
                this.itemsProperties.put(classProperty, className);
                Object obj = ComponentFactory.create(className, itemPrefix, props);
                if (obj instanceof Component) {
                    this.add((Component)obj);
                    continue;
                }
                if (!(obj instanceof JMenuItem)) continue;
                this.add((JMenuItem)obj);
            }
        } else if (Debug.debugging("menu")) {
            Debug.output("Menu " + this.getText() + " created without items in properties");
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + PrettyNameProperty, this.getText());
        props.put(prefix + MnemonicProperty, "" + (char)this.getMnemonic());
        if (this.itemsPropertyContents != null) {
            props.put(prefix + ItemsProperty, this.itemsPropertyContents);
        }
        if (this.itemsProperties != null) {
            props.putAll((Map<?, ?>)this.itemsProperties);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }
}

