/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.input;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicFactory;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPoint;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.LittleEndianInputStream;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ShpInputStream
implements ShapeConstants {
    private LittleEndianInputStream _leis = null;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();

    public ShpInputStream(InputStream is) {
        BufferedInputStream bis = new BufferedInputStream(is);
        this._leis = new LittleEndianInputStream(bis);
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public EsriGraphicList getGeometry(int[][] indexData) throws Exception {
        return this.getGeometry();
    }

    public EsriGraphicList getGeometry() throws Exception {
        return this.getGeometry(new EsriGraphicFactory());
    }

    public EsriGraphicList getGeometry(EsriGraphicFactory factory) throws Exception {
        return (EsriGraphicList)factory.getEsriGraphics(this._leis, this.drawingAttributes, (Object)null, (Projection)null, (OMGraphicList)null);
    }

    protected int[] getPartOffsets(OMGraphicList sublist) {
        int pos = 0;
        int[] offsets = new int[sublist.size()];
        for (int j = 0; j < sublist.size(); ++j) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(j);
            double[] data = poly.getLatLonArray();
            offsets[j] = pos / 2;
            pos += data.length;
        }
        return offsets;
    }

    public EsriGraphicList getPointGeometry(int[][] indexData) throws Exception {
        EsriPointList list = new EsriPointList();
        int numShapes = indexData[1].length;
        for (int i = 0; i < numShapes; ++i) {
            int shpRecord = this._leis.readInt();
            this._leis.readInt();
            int shpType = this._leis.readLEInt();
            if (shpType == 0) continue;
            double lambda = this._leis.readLEDouble();
            double phi = this._leis.readLEDouble();
            float f1 = (float)lambda;
            float f2 = (float)phi;
            EsriPoint point = new EsriPoint(f2, f1);
            point.putAttribute("SHAPE_INDEX_ATTRIBUTE", new Integer(shpRecord - 1));
            if (this.drawingAttributes != null) {
                this.drawingAttributes.setTo(point);
            } else {
                DrawingAttributes.DEFAULT.setTo(point);
            }
            ((EsriGraphicList)list).add(point);
        }
        return list;
    }

    protected int getPointsPerShape(OMGraphicList sublist) {
        int numPoints = 0;
        for (int i = 0; i < sublist.size(); ++i) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(i);
            double[] data = poly.getLatLonArray();
            numPoints += data.length;
        }
        return numPoints /= 2;
    }

    public EsriGraphicList getPolyGeometry(int[][] indexData, int shapeType) throws Exception {
        EsriGraphicList list = null;
        if (shapeType == 3) {
            list = new EsriPolylineList();
        } else if (shapeType == 5) {
            list = new EsriPolygonList();
        }
        int numShapes = indexData[1].length;
        for (int t = 0; t < numShapes; ++t) {
            Integer shpRecordIndex = new Integer(this._leis.readInt() - 1);
            this._leis.readInt();
            int shpType = this._leis.readLEInt();
            if (shpType == 0) continue;
            this._leis.readLEDouble();
            this._leis.readLEDouble();
            this._leis.readLEDouble();
            this._leis.readLEDouble();
            int numParts = this._leis.readLEInt();
            int numPoints = this._leis.readLEInt();
            int[] offsets = new int[numParts];
            for (int n = 0; n < numParts; ++n) {
                offsets[n] = this._leis.readLEInt();
            }
            OMPoly poly = null;
            EsriGraphicList sublist = null;
            if (numParts > 1) {
                if (shapeType == 3) {
                    sublist = new EsriPolylineList();
                } else if (shapeType == 5) {
                    sublist = new EsriPolygonList();
                }
                if (sublist != null) {
                    sublist.setVague(true);
                    sublist.putAttribute("SHAPE_INDEX_ATTRIBUTE", shpRecordIndex);
                }
            }
            for (int j = 0; j < numParts; ++j) {
                double[] points;
                int numVertices;
                int i = 0;
                if (j != numParts - 1) {
                    numVertices = offsets[j + 1] - offsets[j];
                    points = new double[numVertices * 2];
                } else {
                    numVertices = numPoints - offsets[j];
                    points = new double[numVertices * 2];
                }
                for (int n = 0; n < numVertices; ++n) {
                    double lambda = this._leis.readLEDouble();
                    double phi = this._leis.readLEDouble();
                    points[i++] = (float)Math.toRadians(phi);
                    points[i++] = (float)Math.toRadians(lambda);
                }
                if (shapeType == 3) {
                    poly = new EsriPolyline(points, 1, 3);
                } else if (shapeType == 5) {
                    poly = new EsriPolygon(points, 1, 3);
                }
                if (this.drawingAttributes != null) {
                    this.drawingAttributes.setTo(poly);
                } else {
                    DrawingAttributes.DEFAULT.setTo(poly);
                }
                if (poly instanceof EsriPolyline) {
                    poly.setFillPaint(OMColor.clear);
                }
                if (sublist != null) {
                    sublist.addOMGraphic(poly);
                    continue;
                }
                if (poly == null) continue;
                poly.putAttribute("SHAPE_INDEX_ATTRIBUTE", shpRecordIndex);
            }
            if (list == null) continue;
            if (sublist != null) {
                list.add(sublist);
            } else {
                list.add(poly);
            }
            if (!Debug.debugging("esri")) continue;
            EsriGraphic eg = null;
            eg = sublist == null ? (EsriGraphic)((Object)poly) : sublist;
            if (eg == null) continue;
            double[] ex1 = eg.getExtents();
            Debug.output("extents of list: xmin=" + ex1[1] + ", ymin=" + ex1[0] + ", xmax=" + ex1[3] + ", ymax=" + ex1[2]);
            Debug.output("list.size=" + list.size());
        }
        if (Debug.debugging("esri") && list != null) {
            double[] ex = list.getExtents();
            Debug.output("extents of list: xmin=" + ex[1] + ", ymin=" + ex[0] + ", xmax=" + ex[3] + ", ymax=" + ex[2]);
        }
        return list;
    }

    public int readHeader() throws IOException {
        this._leis.readInt();
        this._leis.skipBytes(20);
        this._leis.readInt();
        this._leis.readLEInt();
        int shapeType = this._leis.readLEInt();
        this._leis.readLEDouble();
        this._leis.readLEDouble();
        this._leis.readLEDouble();
        this._leis.readLEDouble();
        this._leis.readLEDouble();
        this._leis.readLEDouble();
        this._leis.readLEDouble();
        this._leis.readLEDouble();
        return shapeType;
    }
}

