/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.mapTile.MapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.StandardMapTileFactory;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ImageIcon;

public class ServerMapTileFactory
extends StandardMapTileFactory
implements MapTileFactory,
PropertyConsumer {
    public static final String LOCAL_CACHE_ROOT_DIR_PROPERTY = "localCacheRootDir";
    protected String localCacheDir = null;

    public ServerMapTileFactory() {
        this(null);
    }

    public ServerMapTileFactory(String rootDir) {
        this.rootDir = rootDir;
        this.fileExt = ".png";
        this.verbose = logger.isLoggable(Level.FINE);
    }

    public Object getFromCache(Object key, int x, int y, int zoomLevel) {
        String localLoc = null;
        if (this.localCacheDir != null && this.zoomLevelInfo != null) {
            localLoc = this.zoomLevelInfo.formatImageFilePath(this.localCacheDir, x, y) + this.fileExt;
            CacheObject ret = this.searchCache(localLoc);
            if (ret != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("found tile (" + x + ", " + y + ") in cache");
                }
                return ret.obj;
            }
            return null;
        }
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("found tile (" + x + ", " + y + ") in cache");
            }
            return ret.obj;
        }
        return null;
    }

    public CacheObject load(Object key, int x, int y, int zoomLevel, Projection proj) {
        if (key instanceof String) {
            String localLoc;
            block21: {
                CacheObject localVersion;
                String imagePath = (String)key;
                if (this.verbose) {
                    logger.fine("fetching file for cache: " + imagePath);
                }
                URL url = null;
                ImageIcon ii = null;
                localLoc = null;
                if (this.localCacheDir != null && this.zoomLevelInfo != null && (localVersion = super.load(localLoc = this.zoomLevelInfo.formatImageFilePath(this.localCacheDir, x, y) + this.fileExt, x, y, zoomLevel, proj)) != null) {
                    logger.fine("found version of tile in local cache: " + localLoc);
                    return localVersion;
                }
                try {
                    url = new URL(imagePath);
                    HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("url content type: " + urlc.getContentType());
                    }
                    if (urlc == null || urlc.getContentType() == null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("unable to connect to (tile might be unavailable): " + imagePath);
                        }
                        return this.getEmptyTile(localLoc, x, y, zoomLevel, proj);
                    }
                    if (urlc.getContentType().startsWith("text")) {
                        String st;
                        BufferedReader bin = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                        StringBuffer message = new StringBuffer();
                        while ((st = bin.readLine()) != null) {
                            message.append(st);
                        }
                        logger.fine(message.toString());
                    } else if (urlc.getContentType().startsWith("image")) {
                        InputStream in = urlc.getInputStream();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        int buflen = 2048;
                        byte[] buf = new byte[buflen];
                        int len = -1;
                        while ((len = in.read(buf, 0, buflen)) != -1) {
                            out.write(buf, 0, len);
                        }
                        out.flush();
                        out.close();
                        byte[] imageBytes = out.toByteArray();
                        ii = new ImageIcon(imageBytes);
                        if (this.localCacheDir != null) {
                            File localFile = new File(localLoc);
                            File parentDir = localFile.getParentFile();
                            parentDir.mkdirs();
                            FileOutputStream fos = new FileOutputStream(localFile);
                            fos.write(imageBytes);
                            fos.flush();
                            fos.close();
                        }
                    }
                }
                catch (MalformedURLException murle) {
                    logger.warning("WebImagePlugIn: URL \"" + imagePath + "\" is malformed.");
                }
                catch (IOException ioe) {
                    logger.fine("Couldn't connect to " + imagePath + ", connection problem");
                }
                if (ii != null && ii.getIconWidth() > 0) {
                    try {
                        BufferedImage rasterImage = this.preprocessImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
                        OMGraphic raster = this.createOMGraphicFromBufferedImage(rasterImage, x, y, zoomLevel, proj);
                        if (raster != null) {
                            if (localLoc != null) {
                                key = localLoc;
                            }
                            if (raster != null) {
                                return new CacheObject(key, raster);
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        if (!logger.isLoggable(Level.FINE)) break block21;
                        logger.fine("factory interrupted fetching " + imagePath);
                    }
                }
            }
            return this.getEmptyTile(localLoc, x, y, zoomLevel, proj);
        }
        return null;
    }

    public Properties getProperties(Properties getList) {
        getList = super.getProperties(getList);
        getList.put(this.prefix + LOCAL_CACHE_ROOT_DIR_PROPERTY, PropUtils.unnull(this.localCacheDir));
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        I18n i18n = Environment.getI18n();
        PropUtils.setI18NPropertyInfo(i18n, list, StandardMapTileFactory.class, LOCAL_CACHE_ROOT_DIR_PROPERTY, "Local Cache Tile Directory", "Root directory containing image tiles retrieved from image server.", "com.bbn.openmap.util.propertyEditor.DirectoryPropertyEditor");
        return list;
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.localCacheDir = setList.getProperty(prefix + LOCAL_CACHE_ROOT_DIR_PROPERTY, this.localCacheDir);
    }
}

