/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Azimuth;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Orthographic
extends Azimuth {
    public static final transient String OrthographicName = "Orthographic";
    protected double hy;
    protected double wx;
    protected double cosCtrLat;
    protected double sinCtrLat;
    public static final transient double epsilon = (double)1.0E-4f;
    protected static final double NORTH_BOUNDARY = 1.5706963705088128;
    protected static final double SOUTH_BOUNDARY = -1.5706963705088128;

    public Orthographic(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
        this.setMinScale(1000.0f);
    }

    @Override
    public String toString() {
        return "Orthographic[" + super.toString();
    }

    @Override
    protected void computeParameters() {
        Debug.message("proj", "Orthographic.computeParameters()");
        super.computeParameters();
        this.cosCtrLat = Math.cos(this.centerY);
        this.sinCtrLat = Math.sin(this.centerY);
        this.hy = this.height / 2;
        this.wx = this.width / 2;
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > 1.5706963705088128) {
            return 1.5706963705088128;
        }
        if (lat < -1.5706963705088128) {
            return -1.5706963705088128;
        }
        return lat;
    }

    public static final boolean hemisphere_clip(float phi1, float lambda0, float phi, float lambda) {
        return GreatCircle.sphericalDistance(phi1, lambda0, phi, lambda) <= 1.5707964f;
    }

    public static final boolean hemisphere_clip(double phi1, double lambda0, double phi, double lambda) {
        return GreatCircle.sphericalDistance(phi1, lambda0, phi, lambda) <= 1.5707963267948966;
    }

    private Point2D edge_point(Point2D p, double current_azimuth) {
        LatLonPoint tmpll = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, current_azimuth);
        double phi = tmpll.getRadLat();
        double lambda = tmpll.getRadLon();
        double cosPhi = Math.cos(phi);
        double lambdaMinusCtrLon = lambda - this.centerX;
        double x = this.scaled_radius * cosPhi * Math.sin(lambdaMinusCtrLon) + this.wx;
        double y = this.hy - this.scaled_radius * (this.cosCtrLat * Math.sin(phi) - this.sinCtrLat * cosPhi * Math.cos(lambdaMinusCtrLon));
        p.setLocation(x, y);
        return p;
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        lat = this.normalizeLatitude(ProjMath.degToRad(lat));
        lon = Orthographic.wrapLongitude(ProjMath.degToRad(lon));
        return Orthographic.hemisphere_clip(this.centerY, this.centerX, lat, lon);
    }

    @Override
    protected Point2D _forward(double phi, double lambda, Point2D p, Azimuth.AzimuthVar azVar) {
        double cosPhi = Math.cos(phi);
        double lambdaMinusCtrLon = lambda - this.centerX;
        if (!Orthographic.hemisphere_clip(this.centerY, this.centerX, phi, lambda)) {
            double az = GreatCircle.sphericalAzimuth(this.centerY, this.centerX, phi, lambda);
            if (azVar != null) {
                azVar.invalid_forward = true;
                azVar.current_azimuth = az;
            }
            return this.edge_point(p, az);
        }
        double x = this.scaled_radius * cosPhi * Math.sin(lambdaMinusCtrLon) + this.wx;
        double y = this.hy - this.scaled_radius * (this.cosCtrLat * Math.sin(phi) - this.sinCtrLat * cosPhi * Math.cos(lambdaMinusCtrLon));
        p.setLocation(x, y);
        return p;
    }

    @Override
    public <T extends Point2D> T inverse(double x, double y, T llp) {
        double rho;
        if (llp == null) {
            llp = new LatLonPoint.Double();
        }
        if ((rho = Math.sqrt((x -= this.wx) * x + (y = this.hy - y) * y)) == 0.0) {
            Debug.message("proj", "Orthographic.inverse: center!");
            ((Point2D)llp).setLocation(Math.toDegrees(this.centerX), Math.toDegrees(this.centerY));
            return (T)llp;
        }
        double sinC = rho / this.scaled_radius;
        double cosC = Math.sqrt(1.0 - sinC * sinC);
        double lat = Math.asin(cosC * this.sinCtrLat + y * sinC * (this.cosCtrLat / rho));
        double lon = this.centerY == 1.5707963705062866 ? this.centerX + Math.atan2(x, -y) : (this.centerY == -1.5707963705062866 ? this.centerX + Math.atan2(x, y) : this.centerX + Math.atan2(x * sinC, rho * this.cosCtrLat * cosC - y * this.sinCtrLat * sinC));
        if (Double.isNaN(lat) || Double.isNaN(lon)) {
            lat = this.centerY;
            lon = this.centerX;
        }
        ((Point2D)llp).setLocation(Math.toDegrees(Orthographic.wrapLongitude(lon)), Math.toDegrees(this.normalizeLatitude(lat)));
        return (T)llp;
    }

    @Override
    public LatLonPoint getUpperLeft() {
        double lon;
        double lat;
        LatLonPoint.Double tmp = new LatLonPoint.Double();
        if (this.overNorthPole()) {
            lat = 1.5707963705062866;
            lon = -3.1415927410125732;
        } else if (this.overSouthPole()) {
            lon = -3.1415927410125732;
            this.inverse(0.0, 0.0, tmp);
            lat = MoreMath.approximately_equal(((LatLonPoint)tmp).getRadLon(), this.centerX, (double)1.0E-4f) ? this.centerY + 1.5707963267948966 : ((Point2D)tmp).getY();
        } else if (this.centerY >= 0.0) {
            this.inverse(0.0, 0.0, tmp);
            if (MoreMath.approximately_equal(((LatLonPoint)tmp).getRadLon(), this.centerX, (double)1.0E-4f)) {
                this.inverse(this.width / 2, 0.0, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
                lon = -3.1415927410125732;
            } else {
                lon = ((LatLonPoint)tmp).getRadLon();
                this.inverse(this.width / 2, 0.0, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            }
        } else {
            this.inverse(0.0, 0.0, tmp);
            if (MoreMath.approximately_equal(((LatLonPoint)tmp).getRadLon(), this.centerX, (double)1.0E-4f)) {
                lat = this.centerY + 1.5707963267948966;
                lon = -3.1415927410125732;
            } else {
                lat = ((LatLonPoint)tmp).getRadLat();
                this.inverse(0.0, this.height - 1, tmp);
                lon = ((LatLonPoint)tmp).getRadLon();
            }
        }
        ((LatLonPoint)tmp).setLatLon(lat, lon, true);
        return tmp;
    }

    @Override
    public LatLonPoint getLowerRight() {
        double lat;
        double lon;
        LatLonPoint.Double tmp = new LatLonPoint.Double();
        if (this.overNorthPole()) {
            lon = 3.1415927410125732;
            this.inverse(this.width - 1, this.height - 1, tmp);
            lat = MoreMath.approximately_equal(((LatLonPoint)tmp).getRadLon(), this.centerX, (double)1.0E-4f) ? this.centerY - 1.5707963267948966 : ((LatLonPoint)tmp).getRadLat();
        } else if (this.overSouthPole()) {
            lat = -1.5707963705062866;
            lon = 3.1415927410125732;
        } else if (this.centerY >= 0.0) {
            this.inverse(this.width - 1, this.height - 1, tmp);
            if (MoreMath.approximately_equal(((LatLonPoint)tmp).getRadLon(), this.centerX, (double)1.0E-4f)) {
                lat = this.centerY - 1.5707963267948966;
                lon = 3.1415927410125732;
            } else {
                lat = ((LatLonPoint)tmp).getRadLat();
                this.inverse(this.width - 1, 0.0, tmp);
                lon = ((LatLonPoint)tmp).getRadLon();
            }
        } else {
            this.inverse(this.width - 1, this.height - 1, tmp);
            if (MoreMath.approximately_equal(((LatLonPoint)tmp).getRadLon(), this.centerX, (double)1.0E-4f)) {
                this.inverse(this.width / 2, this.height - 1, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
                lon = 3.1415927410125732;
            } else {
                lon = ((LatLonPoint)tmp).getRadLon();
                this.inverse(this.width / 2, this.height - 1, tmp);
                lat = ((LatLonPoint)tmp).getRadLat();
            }
        }
        ((LatLonPoint)tmp).setLatLon(lat, lon, true);
        return tmp;
    }

    @Override
    public String getName() {
        return OrthographicName;
    }
}

