/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.time;

import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.time.TemporalOMGraphic;
import com.bbn.openmap.omGraphics.time.TemporalPoint;
import com.bbn.openmap.omGraphics.time.TemporalPointSupport;
import com.bbn.openmap.omGraphics.time.TemporalRecord;
import com.bbn.openmap.proj.Projection;
import java.awt.geom.Point2D;

public class TemporalOMPoint
extends OMPoint
implements TemporalOMGraphic {
    protected Object id;
    protected TemporalPointSupport timeStamps;
    protected boolean interpolate = false;

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public TemporalOMPoint(Object id, int renderType, boolean interpolate) {
        this.id = id;
        this.interpolate = interpolate;
        this.setRenderType(renderType);
        this.timeStamps = new TemporalPointSupport(renderType);
    }

    public boolean thisIsYou(Object n) {
        return this.id.equals(n);
    }

    public void addTimeStamp(TemporalRecord timeStamp) {
        this.timeStamps.add(timeStamp);
        this.setNeedToRegenerate(true);
    }

    public boolean removeTimeStamp(TemporalRecord timeStamp) {
        return this.timeStamps.remove(timeStamp);
    }

    public void clearTimeStamps() {
        this.timeStamps.clear();
    }

    public TemporalPoint setPosition(long time) {
        return (TemporalPoint)this.timeStamps.getPosition(time, this.interpolate);
    }

    public void generate(Projection p, long time) {
        TemporalPoint tp = this.setPosition(time);
        if (tp == null) {
            return;
        }
        Point2D pt = tp.getLocation();
        switch (this.renderType) {
            case 2: {
                this.set((int)pt.getX(), (int)pt.getY());
                break;
            }
            default: {
                this.set(pt.getY(), pt.getX());
            }
        }
        super.generate(p);
    }
}

