/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.omGraphics.OMAbstractLine;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.DeepCopyUtil;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;

public class OMPoly
extends OMAbstractLine
implements Serializable {
    public static final int COORDMODE_ORIGIN = 0;
    public static final int COORDMODE_PREVIOUS = 1;
    protected int units = -1;
    protected double lat = 0.0;
    protected double lon = 0.0;
    protected int coordMode = 0;
    protected int[] xs = null;
    protected int[] ys = null;
    protected boolean isPolygon = false;
    protected double[] rawllpts = null;
    protected boolean doShapes = false;
    protected boolean geometryClosed = false;

    public OMPoly() {
        super(0, 0, 0);
    }

    public OMPoly(double[] llPoints, int units, int lType) {
        this(llPoints, units, lType, -1);
    }

    public OMPoly(double[] llPoints, int units, int lType, int nsegs) {
        super(1, lType, 0);
        this.setLocation(llPoints, units);
        this.nsegs = nsegs;
    }

    public OMPoly(int[] xypoints) {
        super(2, 0, 0);
        this.setLocation(xypoints);
    }

    public OMPoly(int[] xPoints, int[] yPoints) {
        super(2, 0, 0);
        this.setLocation(xPoints, yPoints);
    }

    public OMPoly(double latPoint, double lonPoint, int[] xypoints, int cMode) {
        super(3, 0, 0);
        this.setLocation(latPoint, lonPoint, 0, xypoints);
        this.coordMode = cMode;
    }

    public OMPoly(double latPoint, double lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(3, 0, 0);
        this.setLocation(latPoint, lonPoint, 0, xPoints, yPoints);
        this.coordMode = cMode;
    }

    public void setLocation(double[] llPoints, int units) {
        this.units = 1;
        if (units == 0) {
            ProjMath.arrayDegToRad(llPoints);
        }
        this.rawllpts = llPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(1);
    }

    public void setLocation(int[] xypoints) {
        int end = xypoints.length >> 1;
        this.xs = new int[end];
        this.ys = new int[end];
        int i = 0;
        int j = 0;
        while (i < end) {
            this.xs[i] = xypoints[j];
            this.ys[i] = xypoints[j + 1];
            ++i;
            j += 2;
        }
        this.setNeedToRegenerate(true);
        this.setRenderType(2);
    }

    public void setLocation(int[] xPoints, int[] yPoints) {
        this.xs = xPoints;
        this.ys = yPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(2);
    }

    public void setLocation(double latPoint, double lonPoint, int units, int[] xypoints) {
        this.units = 1;
        if (units == 0) {
            this.lat = ProjMath.degToRad(latPoint);
            this.lon = ProjMath.degToRad(lonPoint);
        } else {
            this.lat = latPoint;
            this.lon = lonPoint;
        }
        int end = xypoints.length >> 1;
        this.xs = new int[end];
        this.ys = new int[end];
        int i = 0;
        int j = 0;
        while (i < end) {
            this.xs[i] = xypoints[j];
            this.ys[i] = xypoints[j + 1];
            ++i;
            j += 2;
        }
        this.setNeedToRegenerate(true);
        this.setRenderType(3);
    }

    public void setLocation(double latPoint, double lonPoint, int units, int[] xPoints, int[] yPoints) {
        this.units = 1;
        if (units == 0) {
            this.lat = ProjMath.degToRad(latPoint);
            this.lon = ProjMath.degToRad(lonPoint);
        } else {
            this.lat = latPoint;
            this.lon = lonPoint;
        }
        this.xs = xPoints;
        this.ys = yPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(3);
    }

    public double[] getLatLonArray() {
        if (this.units == 0) {
            ProjMath.arrayDegToRad(this.rawllpts);
            this.units = 1;
        }
        return this.rawllpts;
    }

    public double[] getLatLonArrayCopy() {
        return DeepCopyUtil.deepCopy(this.getLatLonArray());
    }

    public void setLat(double lat) {
        this.lat = ProjMath.degToRad(lat);
        this.setNeedToRegenerate(true);
    }

    public double getLat() {
        return ProjMath.radToDeg(this.lat);
    }

    public void setLon(double lon) {
        this.lon = ProjMath.degToRad(lon);
        this.setNeedToRegenerate(true);
    }

    public double getLon() {
        return ProjMath.radToDeg(this.lon);
    }

    public void setXs(int[] x) {
        this.xs = x;
        this.setNeedToRegenerate(true);
    }

    public int[] getXs() {
        return this.xs;
    }

    public void setYs(int[] y) {
        this.ys = y;
        this.setNeedToRegenerate(true);
    }

    public int[] getYs() {
        return this.ys;
    }

    public void setFillPaint(Paint paint) {
        super.setFillPaint(paint);
        this.isPolygon = !this.isClear(paint);
    }

    public boolean isPolygon() {
        return this.isPolygon;
    }

    public void setIsPolygon(boolean set) {
        if (!set) {
            this.fillPaint = OMColor.clear;
        }
        this.isPolygon = set;
    }

    public void setNumSegs(int nsegs) {
        this.nsegs = nsegs;
    }

    public int getNumSegs() {
        return this.nsegs;
    }

    public void setCoordMode(int coordMode) {
        this.coordMode = coordMode;
    }

    public int getCoordMode() {
        return this.coordMode;
    }

    public void setDoShapes(boolean set) {
        this.doShapes = set;
    }

    public boolean getDoShapes() {
        return this.doShapes;
    }

    public boolean generate(Projection proj) {
        this.setNeedToRegenerate(true);
        if (proj == null) {
            Debug.message("omgraphic", "OMPoly: null projection in generate!");
            return false;
        }
        this.isGeometryClosed();
        switch (this.renderType) {
            case 2: {
                if (this.xs == null) {
                    Debug.message("omgraphic", "OMPoly x/y rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                this.xpoints = new float[1][0];
                this.ypoints = new float[1][0];
                float[] xfs = new float[this.xs.length];
                float[] yfs = new float[this.ys.length];
                for (int i = 0; i < this.xs.length; ++i) {
                    xfs[i] = this.xs[i];
                    yfs[i] = this.ys[i];
                }
                this.xpoints[0] = xfs;
                this.ypoints[0] = yfs;
                break;
            }
            case 3: {
                if (this.xs == null) {
                    Debug.message("omgraphic", "OMPoly offset rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                int npts = this.xs.length;
                float[] _x = new float[npts];
                float[] _y = new float[npts];
                Point origin = new Point();
                if (proj instanceof GeoProj) {
                    ((GeoProj)proj).forward(this.lat, this.lon, (Point2D)origin, true);
                } else {
                    proj.forward(Math.toDegrees(this.lat), Math.toDegrees(this.lon), (Point2D)origin);
                }
                if (this.coordMode == 0) {
                    for (int i = 0; i < npts; ++i) {
                        _x[i] = this.xs[i] + origin.x;
                        _y[i] = this.ys[i] + origin.y;
                    }
                } else {
                    _x[0] = this.xs[0] + origin.x;
                    _y[0] = this.ys[0] + origin.y;
                    for (int i = 1; i < npts; ++i) {
                        _x[i] = (float)this.xs[i] + _x[i - 1];
                        _y[i] = (float)this.ys[i] + _y[i - 1];
                    }
                }
                this.xpoints = new float[1][0];
                this.xpoints[0] = _x;
                this.ypoints = new float[1][0];
                this.ypoints[0] = _y;
                break;
            }
            case 1: {
                ArrayList<float[]> vector;
                if (proj instanceof GeoProj) {
                    if (this.units == 0) {
                        ProjMath.arrayDegToRad(this.rawllpts);
                        this.units = 1;
                    }
                    vector = ((GeoProj)proj).forwardPoly(this.rawllpts, this.lineType, this.nsegs, this.isPolygon);
                } else {
                    if (this.units == 1) {
                        ProjMath.arrayRadToDeg(this.rawllpts);
                        this.units = 0;
                    }
                    vector = proj.forwardPoly(this.rawllpts, this.isPolygon);
                }
                int size = vector.size();
                this.xpoints = new float[size / 2][0];
                this.ypoints = new float[this.xpoints.length][0];
                int i = 0;
                int j = 0;
                while (i < size) {
                    this.xpoints[j] = vector.get(i);
                    this.ypoints[j] = vector.get(i + 1);
                    i += 2;
                    ++j;
                }
                if (this.doShapes) break;
                if (size > 1) {
                    if (this.arrowhead != null) {
                        this.arrowhead.generate(this);
                    }
                    this.setNeedToRegenerate(false);
                    this.initLabelingDuringGenerate();
                    if (this.checkPoints(this.xpoints, this.ypoints)) {
                        this.setLabelLocation(this.xpoints[0], this.ypoints[0]);
                    }
                    return true;
                }
                return false;
            }
            case 0: {
                Debug.error("OMPoly.generate: invalid RenderType");
                this.setNeedToRegenerate(true);
                return false;
            }
        }
        if (this.arrowhead != null) {
            this.arrowhead.generate(this);
        }
        this.setNeedToRegenerate(false);
        this.setShape(this.createShape());
        return true;
    }

    protected boolean checkPoints(float[][] xpoints2, float[][] ypoints2) {
        return this.xpoints != null && this.ypoints != null && this.xpoints.length != 0 && this.ypoints.length != 0;
    }

    public boolean shouldRenderFill() {
        return !this.isClear(this.getFillPaint()) && this.isPolygon();
    }

    public void render(Graphics g) {
        block23: {
            if (this.getShape() != null) {
                super.render(g);
                if (this.arrowhead != null) {
                    this.arrowhead.render(g);
                }
                return;
            }
            if (this.getNeedToRegenerate() || !this.isVisible()) {
                return;
            }
            float[][] xpts = this.xpoints;
            float[][] ypts = this.ypoints;
            if (xpts == null || ypts == null) {
                this.setNeedToRegenerate(true);
                return;
            }
            int len = xpts.length;
            Paint displayPaint = this.getDisplayPaint();
            Paint fillPaint = this.getFillPaint();
            boolean isFillClear = this.isClear(fillPaint);
            boolean isLineClear = this.isClear(displayPaint);
            TexturePaint tm = this.getTextureMask();
            try {
                for (int i = 0; i < len; ++i) {
                    GeneralPath polyLine;
                    int j;
                    float[] _x = xpts[i];
                    float[] _y = ypts[i];
                    if (_x == null || _y == null) continue;
                    if (this.isPolygon) {
                        GeneralPath polyGon;
                        if (!isFillClear) {
                            this.setGraphicsForFill(g);
                            polyGon = new GeneralPath();
                            for (j = 0; j < _x.length; ++j) {
                                if (j == 0) {
                                    polyGon.moveTo(_x[j], _y[j]);
                                    continue;
                                }
                                polyGon.lineTo(_x[j], _y[j]);
                            }
                            ((Graphics2D)g).fill(polyGon);
                            if (tm != null && tm != fillPaint) {
                                this.setGraphicsColor(g, tm);
                                ((Graphics2D)g).fill(polyGon);
                            }
                        }
                        if (!this.matted && isLineClear && this.edgeMatchesFill) continue;
                        if (this.matted && g instanceof Graphics2D && this.stroke instanceof BasicStroke) {
                            ((Graphics2D)g).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
                            this.setGraphicsColor(g, this.mattingPaint);
                            polyLine = new GeneralPath();
                            for (j = 0; j < _x.length; ++j) {
                                if (j == 0) {
                                    polyLine.moveTo(_x[j], _y[j]);
                                    continue;
                                }
                                polyLine.lineTo(_x[j], _y[j]);
                            }
                            ((Graphics2D)g).draw(polyLine);
                        }
                        this.setGraphicsForEdge(g);
                        polyGon = new GeneralPath();
                        for (j = 0; j < _x.length; ++j) {
                            if (j == 0) {
                                polyGon.moveTo(_x[j], _y[j]);
                                continue;
                            }
                            polyGon.lineTo(_x[j], _y[j]);
                        }
                        ((Graphics2D)g).draw(polyGon);
                        continue;
                    }
                    if (this.matted && g instanceof Graphics2D && this.stroke instanceof BasicStroke) {
                        ((Graphics2D)g).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
                        if (this.arrowhead != null) {
                            this.setGraphicsColor(g, this.mattingPaint);
                            this.arrowhead.render(g);
                        }
                        this.setGraphicsColor(g, this.mattingPaint);
                        polyLine = new GeneralPath();
                        for (j = 0; j < _x.length; ++j) {
                            if (j == 0) {
                                polyLine.moveTo(_x[j], _y[j]);
                                continue;
                            }
                            polyLine.lineTo(_x[j], _y[j]);
                        }
                        ((Graphics2D)g).draw(polyLine);
                    }
                    this.setGraphicsForEdge(g);
                    polyLine = new GeneralPath();
                    for (j = 0; j < _x.length; ++j) {
                        if (j == 0) {
                            polyLine.moveTo(_x[j], _y[j]);
                            continue;
                        }
                        polyLine.lineTo(_x[j], _y[j]);
                    }
                    ((Graphics2D)g).draw(polyLine);
                    if (this.arrowhead == null) continue;
                    this.arrowhead.render(g);
                }
                this.renderLabel(g);
            }
            catch (Exception e) {
                Debug.output("OMPoly: caught Java rendering exception\n" + e.getMessage());
                if (!Debug.debugging("ompoly")) break block23;
                e.printStackTrace();
            }
        }
    }

    public float distance(double x, double y) {
        GeneralPath shape = this.getShape();
        if (shape != null) {
            return super.distance(x, y);
        }
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate()) {
            return distance;
        }
        float[][] xpts = this.xpoints;
        float[][] ypts = this.ypoints;
        int len = xpts.length;
        for (int i = 0; i < len; ++i) {
            float[] _x = xpts[i];
            float[] _y = ypts[i];
            if (this.isPolygon && DrawUtil.inside_polygon(_x, _y, x, y)) {
                return 0.0f;
            }
            float temp = DrawUtil.closestPolyDistance(_x, _y, x, y, false);
            if (!(temp < distance)) continue;
            distance = temp;
        }
        return this.normalizeDistanceForLineWidth(distance);
    }

    public GeneralPath getShape() {
        GeneralPath shape = super.getShape();
        if (shape == null) {
            shape = this.createShape();
            this.setShape(shape);
        }
        return shape;
    }

    protected GeneralPath createShape() {
        GeneralPath shape = null;
        if (this.getNeedToRegenerate() || !this.checkPoints(this.xpoints, this.ypoints)) {
            return shape;
        }
        this.initLabelingDuringGenerate();
        switch (this.renderType) {
            case 2: 
            case 3: {
                shape = OMPoly.createShape(this.xpoints[0], this.ypoints[0], this.isPolygon);
                break;
            }
            case 1: {
                int size = this.xpoints.length;
                for (int i = 0; i < size; ++i) {
                    GeneralPath gp = OMPoly.createShape(this.xpoints[i], this.ypoints[i], this.isPolygon);
                    shape = OMPoly.appendShapeEdge(shape, gp, false);
                }
                break;
            }
        }
        this.setLabelLocation(this.xpoints[0], this.ypoints[0]);
        return shape;
    }

    protected boolean isGeometryClosed() {
        this.geometryClosed = false;
        switch (this.renderType) {
            case 2: 
            case 3: {
                if (this.xs == null || this.xs.length <= 2) break;
                this.geometryClosed = this.xs[0] == this.xs[this.xs.length - 1] && this.ys[0] == this.ys[this.ys.length - 1];
                break;
            }
            case 1: {
                int l;
                if (this.rawllpts == null || (l = this.rawllpts.length) <= 4) break;
                this.geometryClosed = MoreMath.approximately_equal(this.rawllpts[0], this.rawllpts[l - 2]) && MoreMath.approximately_equal(this.rawllpts[1], this.rawllpts[l - 1]);
                break;
            }
            case 0: {
                Debug.error("OMPoly.generate: invalid RenderType");
            }
        }
        return this.geometryClosed;
    }

    public double[] getRawllpts() {
        return this.rawllpts;
    }

    public int getUnits() {
        return this.units;
    }

    public void insertRadians(double[] latlons, int coordPairIndex, boolean replaceEndsOfInsertedAtJoin) {
        int minPntsNeededForInsertion = 2;
        boolean atEnd = false;
        boolean isClosed = this.isGeometryClosed();
        int insertionPoint = coordPairIndex * 2;
        if (insertionPoint >= this.rawllpts.length) {
            if (isClosed) {
                insertionPoint = this.rawllpts.length - 2;
            } else {
                insertionPoint = this.rawllpts.length;
                atEnd = true;
            }
        } else if (insertionPoint <= 0) {
            if (isClosed) {
                insertionPoint = 2;
            } else {
                insertionPoint = 0;
                atEnd = true;
            }
        }
        int newCoordStart = 0;
        int newCoordLength = latlons.length;
        if (replaceEndsOfInsertedAtJoin) {
            newCoordStart = 2;
            minPntsNeededForInsertion = 6;
            if (atEnd) {
                minPntsNeededForInsertion -= 2;
                newCoordLength -= 2;
                if (insertionPoint == 0) {
                    newCoordStart = 0;
                }
            } else {
                newCoordLength -= 4;
            }
        }
        if (this.renderType == 1 && latlons.length >= minPntsNeededForInsertion && latlons.length % 2 == 0) {
            double[] oldrawllpnts = this.rawllpts;
            int oldCoordsRemaining = oldrawllpnts.length - insertionPoint;
            this.rawllpts = new double[oldrawllpnts.length + newCoordLength];
            System.arraycopy(oldrawllpnts, 0, this.rawllpts, 0, insertionPoint);
            System.arraycopy(latlons, newCoordStart, this.rawllpts, insertionPoint, newCoordLength);
            System.arraycopy(oldrawllpnts, insertionPoint, this.rawllpts, insertionPoint + newCoordLength, oldCoordsRemaining);
            this.setNeedToRegenerate(true);
        }
    }

    public int getIndexOfFirstNodeOfSegIntersect(double x, double y, double maxDist) {
        int ret;
        block5: {
            block6: {
                ret = -1;
                if (this.getNeedToRegenerate()) break block5;
                if (this.renderType != 1) break block6;
                Geo geo1 = new Geo();
                Geo geo2 = new Geo();
                Geo testGeom = new Geo(y, x);
                double[] ll = this.getLatLonArray();
                int index = 0;
                int i = 0;
                while (i < ll.length - 3) {
                    geo1.initializeRadians(ll[i], ll[i + 1]);
                    geo2.initializeRadians(ll[i + 2], ll[i + 3]);
                    if (Intersection.isOnSegment(geo1, geo2, testGeom)) {
                        return index;
                    }
                    i += 2;
                    ++index;
                }
                break block5;
            }
            if (this.renderType != 2 && this.renderType != 3 || this.xpoints == null) break block5;
            for (int copy = 0; copy < this.xpoints.length; ++copy) {
                int index = 0;
                int node = 0;
                while (node < this.xpoints[copy].length - 1) {
                    double startPntX = this.xpoints[copy][node];
                    double startPntY = this.ypoints[copy][node];
                    double endPntX = this.xpoints[copy][node + 1];
                    double endPntY = this.ypoints[copy][node + 1];
                    float dist = (float)Line2D.ptSegDist(startPntX, startPntY, endPntX, endPntY, x, y);
                    if ((double)dist <= maxDist) {
                        return index;
                    }
                    ++node;
                    ++index;
                }
            }
        }
        return ret;
    }

    public static void main(String[] argv) {
        int i;
        double[] origPoints = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        double[] insertionPoints = new double[]{1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8};
        OMPoly poly = new OMPoly(origPoints, 1, 3);
        poly.insertRadians(insertionPoints, 2, true);
        double[] pnts = poly.getLatLonArray();
        System.out.println("--------- in middle, replacing join points");
        for (i = 0; i < pnts.length; ++i) {
            System.out.println("pnt[" + i + "]: " + pnts[i]);
        }
        poly.setLocation(origPoints, 1);
        poly.insertRadians(insertionPoints, 0, true);
        pnts = poly.getLatLonArray();
        System.out.println("--------- at start, replacing join points");
        for (i = 0; i < pnts.length; ++i) {
            System.out.println("pnt[" + i + "]: " + pnts[i]);
        }
        poly.setLocation(origPoints, 1);
        poly.insertRadians(insertionPoints, origPoints.length / 2, true);
        pnts = poly.getLatLonArray();
        System.out.println("--------- at end, replacing join points");
        for (i = 0; i < pnts.length; ++i) {
            System.out.println("pnt[" + i + "]: " + pnts[i]);
        }
        poly.setLocation(origPoints, 1);
        poly.insertRadians(insertionPoints, 6, false);
        pnts = poly.getLatLonArray();
        System.out.println("--------- overrun end, not replacing join points");
        for (i = 0; i < pnts.length; ++i) {
            System.out.println("pnt[" + i + "]: " + pnts[i]);
        }
        poly.setLocation(origPoints, 1);
        poly.insertRadians(insertionPoints, -2, false);
        pnts = poly.getLatLonArray();
        System.out.println("--------- overrun start, not replacing join points");
        for (i = 0; i < pnts.length; ++i) {
            System.out.println("pnt[" + i + "]: " + pnts[i]);
        }
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMPoly) {
            OMPoly polySource = (OMPoly)source;
            this.units = polySource.units;
            this.lat = polySource.lat;
            this.lon = polySource.lon;
            this.coordMode = polySource.coordMode;
            this.xs = DeepCopyUtil.deepCopy(polySource.xs);
            this.ys = DeepCopyUtil.deepCopy(polySource.ys);
            this.isPolygon = polySource.isPolygon;
            this.rawllpts = DeepCopyUtil.deepCopy(polySource.getLatLonArray());
            this.doShapes = polySource.doShapes;
        }
    }
}

