/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.FeatureDrawingAttributes;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayerGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFFeatureGraphicWarehouse
extends VPFLayerGraphicWarehouse
implements VPFFeatureWarehouse {
    public static final String DEFAULT = "DEFAULT";
    protected Hashtable<String, DrawingAttributes> featureDrawingAttributes;
    protected String info = null;

    @Override
    protected void initDrawingAttributes() {
        this.drawingAttributes = new FeatureDrawingAttributes();
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.createFeatureDrawingAttributes(prefix, props, this.getFeatures());
    }

    public void createFeatureDrawingAttributes(String prefix, Properties props, List<String> features) {
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.featureDrawingAttributes = new Hashtable();
        if (this.drawingAttributes != null) {
            this.featureDrawingAttributes.put(DEFAULT, this.drawingAttributes);
        } else {
            this.drawingAttributes = new FeatureDrawingAttributes();
        }
        for (String feature : features) {
            FeatureDrawingAttributes da = (FeatureDrawingAttributes)this.drawingAttributes.clone();
            da.setStroke(this.drawingAttributes.cloneBasicStroke());
            da.setProperties(realPrefix + feature, props);
            this.featureDrawingAttributes.put(feature, da);
        }
    }

    public void setFeatureDrawingAttributes(Hashtable<String, DrawingAttributes> attributes) {
        this.featureDrawingAttributes = attributes;
    }

    public Hashtable<String, DrawingAttributes> getFeatureDrawingAttributes() {
        return this.featureDrawingAttributes;
    }

    @Override
    public Component getGUI(LibrarySelectionTable lst) {
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab(DEFAULT, null, this.drawingAttributes.getGUI(), "General Attributes");
        for (String currentFeature : this.getFeatures()) {
            FeatureDrawingAttributes da = this.getAttributesForFeature(currentFeature);
            if (da == null) continue;
            String desc = null;
            try {
                desc = lst.getDescription(currentFeature);
            }
            catch (FormatException fe) {
                // empty catch block
            }
            if (desc == null) {
                desc = "Feature Description Unavailable";
            }
            JPanel featurePanel = new JPanel();
            featurePanel.add(((DrawingAttributes)da).getGUI());
            jtp.addTab(currentFeature, null, featurePanel, desc);
        }
        return jtp;
    }

    public FeatureDrawingAttributes getAttributesForFeature(String featureType) {
        if (featureType != null) {
            FeatureDrawingAttributes ret;
            if (this.featureDrawingAttributes != null) {
                ret = (FeatureDrawingAttributes)this.featureDrawingAttributes.get(featureType);
                if (ret == null) {
                    ret = (FeatureDrawingAttributes)this.drawingAttributes;
                }
            } else {
                ret = (FeatureDrawingAttributes)this.drawingAttributes;
            }
            return ret;
        }
        return (FeatureDrawingAttributes)this.drawingAttributes;
    }

    @Override
    public OMGraphic createArea(CoverageTable covtable, AreaTable areatable, List<Object> facevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, String featureType, int primID) {
        ArrayList<CoordFloatString> ipts = new ArrayList<CoordFloatString>();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return null;
        }
        if (totalSize == 0) {
            return null;
        }
        OMPoly py = VPFFeatureGraphicWarehouse.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        this.setAttributesForFeature(py, covtable, featureType, primID);
        py.setLinePaint(OMColor.clear);
        py.setSelectPaint(OMColor.clear);
        this.addArea(py);
        return py;
    }

    @Override
    public OMGraphic createEdge(CoverageTable c, EdgeTable edgetable, List<Object> edgevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, CoordFloatString coords, String featureType, int primID) {
        OMPoly py = VPFFeatureGraphicWarehouse.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        this.setAttributesForFeature(py, c, featureType, primID);
        py.setFillPaint(OMColor.clear);
        py.setIsPolygon(false);
        this.addEdge(py);
        return py;
    }

    protected void setAttributesForFeature(OMGraphic omg, CoverageTable c, String featureType, int id) {
        FeatureDrawingAttributes fda = this.getAttributesForFeature(featureType);
        if (fda.getFci() == null) {
            fda.setFci(c.getFeatureClassInfo(featureType));
        }
        fda.setTo(omg, id);
    }

    @Override
    public OMGraphic createText(CoverageTable c, TextTable texttable, List<Object> textvec, double latitude, double longitude, String text, String featureType, int primID) {
        OMText txt = VPFFeatureGraphicWarehouse.createOMText(text, latitude, longitude);
        this.setAttributesForFeature(txt, c, featureType, primID);
        this.addText(txt);
        return txt;
    }

    @Override
    public OMGraphic createNode(CoverageTable c, NodeTable t, List<Object> nodeprim, double latitude, double longitude, boolean isEntityNode, String featureType, int primID) {
        OMPoint pt = VPFFeatureGraphicWarehouse.createOMPoint(latitude, longitude);
        this.setAttributesForFeature(pt, c, featureType, primID);
        this.addPoint(pt);
        return pt;
    }

    @Override
    public boolean needToFetchTileContents(String libraryName, String currentFeature, TileDirectory currentTile) {
        return true;
    }

    public static void main(String[] argv) {
        new VPFFeatureGraphicWarehouse();
    }
}

