/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.cgm.CGM;
import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.io.CSVFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.layer.vpf.GeoSymAttExpression;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureInfoHandler;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.omGraphics.OMScalingIcon;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFAutoFeatureGraphicWarehouse
implements VPFFeatureWarehouse,
PropertyConsumer {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.layer.vpf.VPFAutoFeatureGraphicWarehouse");
    public static final String CGM_DIR_PROPERTY = "cgmDirectory";
    public static final String SYMBOL_LOOKUP_FILE_PROPERTY = "faccLookupFile";
    public static final String PRIORITY_FILE_PROPERTY = "priorityFile";
    public static final String FEATURE_INFO_HANDLER_PROPERTY = "featureInfoHandler";
    public static final String FACC_DEBUG_PROPERTY = "debug";
    public static final String ICON_SIZE_PROPERTY = "iconSize";
    public static final int DEFAULT_ICON_SIZE = 20;
    protected List<FeaturePriorityHolder> priorities;
    protected Hashtable<String, List<FeaturePriorityHolder>> faccLookup;
    protected String priorityFilePath;
    protected String faccLookupFilePath;
    protected String geoSymDirectory;
    protected VPFFeatureInfoHandler featInfoHandler;
    protected int iconSize = 20;
    protected String[] compositeFeatureFaccs = new String[]{"BC010", "BC020", "BC040", "BC070"};
    protected String debugFacc = null;
    private List<String> useLibrary = null;
    protected String prefix;
    public static final String EV_ISDM = "isdm";
    public static final String EV_IDSM = "idsm";
    public static final String EV_SSDC = "ssdc";
    public static final String EV_MSDC = "msdc";
    public static final String EV_MSSC = "mssc";
    protected double isdm = 0.0;
    protected double idsm = 0.0;
    protected double ssdc = 5.0;
    protected double msdc = 30.0;
    protected double mssc = 1.0;
    protected String info = null;

    protected void init() {
        try {
            CSVFile symbolLookupFile = new CSVFile(this.faccLookupFilePath);
            symbolLookupFile.setHeadersExist(true);
            symbolLookupFile.loadData(true);
            CSVFile priorityFile = new CSVFile(this.priorityFilePath);
            priorityFile.setHeadersExist(true);
            priorityFile.loadData(true);
            this.faccLookup = new Hashtable();
            Hashtable<String, FeaturePriorityHolder.Compound> composites = new Hashtable<String, FeaturePriorityHolder.Compound>();
            int numPriorities = priorityFile.getNumberOfRecords();
            this.priorities = new ArrayList<FeaturePriorityHolder>();
            for (Vector<Object> row : priorityFile) {
                String lineCheck = null;
                String type = null;
                String facc = null;
                String conditions = null;
                try {
                    lineCheck = row.get(0).toString();
                    if (lineCheck.startsWith("#")) continue;
                    type = row.get(1).toString();
                    facc = row.get(2).toString();
                    conditions = row.get(3).toString();
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    logger.warning("Bad entry in priority file: " + lineCheck + "," + type + "," + facc + "," + conditions);
                    continue;
                }
                if (this.debugFacc != null && !this.debugFacc.equals(facc)) continue;
                boolean composite = false;
                if (type.charAt(0) == 'P') {
                    for (String compFacc : this.compositeFeatureFaccs) {
                        if (!compFacc.equals(facc)) continue;
                        composite = true;
                        break;
                    }
                }
                FeaturePriorityHolder.Basic ph = new FeaturePriorityHolder.Basic(type, facc, conditions, this);
                ph.setCGMPath(this.geoSymDirectory, ".cgm");
                if (composite) {
                    FeaturePriorityHolder.Compound compound = (FeaturePriorityHolder.Compound)composites.get(facc);
                    if (compound == null) {
                        compound = new FeaturePriorityHolder.Compound(type, facc, this);
                        composites.put(facc, compound);
                        this.priorities.add(compound);
                        ArrayList<FeaturePriorityHolder.Compound> list = new ArrayList<FeaturePriorityHolder.Compound>();
                        this.faccLookup.put(facc, list);
                        list.add(compound);
                    }
                    compound.addPart(ph);
                    continue;
                }
                this.priorities.add(ph);
                List<FeaturePriorityHolder> list = this.faccLookup.get(facc);
                if (list == null) {
                    list = new ArrayList<FeaturePriorityHolder>();
                    this.faccLookup.put(facc, list);
                }
                list.add(ph);
            }
            int numSymbols = symbolLookupFile.getNumberOfRecords();
            int foundRecords = 0;
            for (Vector<Object> row : symbolLookupFile) {
                List<FeaturePriorityHolder> faccList;
                int numArgs = row.size();
                String facc = row.get(0).toString();
                if (numArgs != 7) {
                    logger.warning("Problem with facc entry, not correct number of args in csv file:" + facc);
                    continue;
                }
                char type = VPFAutoFeatureGraphicWarehouse.getType(row.get(1).toString());
                String symbolCode = row.get(2).toString();
                String conditions = row.get(3).toString().trim();
                String size = row.get(4).toString().trim();
                String xoff = row.get(5).toString().trim();
                String yoff = row.get(6).toString().trim();
                if (conditions.length() > 0) {
                    conditions = conditions.replace(" ", "");
                }
                if ((faccList = this.faccLookup.get(facc)) != null) {
                    boolean found = false;
                    for (FeaturePriorityHolder ph : faccList) {
                        if (!ph.matches(facc, type, conditions, symbolCode, size, xoff, yoff)) continue;
                        found = true;
                        ++foundRecords;
                        break;
                    }
                    if (found || !logger.isLoggable(Level.FINE)) continue;
                    logger.fine("didn't find matching PriorityHolder for " + facc + "|" + type + "|" + symbolCode + "|" + conditions);
                    continue;
                }
                if (this.debugFacc != null || !logger.isLoggable(Level.FINE)) continue;
                logger.fine("can't find faccLookup for " + facc + " for" + type + "|" + symbolCode + "|" + conditions);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("matched up " + foundRecords + " of " + numSymbols + " symbols, " + numPriorities + " priority entries");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static char getType(String type) {
        if (type == null) {
            logger.warning("unknown type!");
        } else {
            switch (type.charAt(0)) {
                case 'P': {
                    return 'P';
                }
                case 'A': {
                    return 'A';
                }
                case 'L': {
                    return 'L';
                }
            }
        }
        return 'S';
    }

    @Override
    public void setUseLibraries(List<String> libNames) {
        this.useLibrary = libNames;
    }

    @Override
    public List<String> getUseLibraries() {
        return this.useLibrary;
    }

    @Override
    public boolean checkLibraryForUsage(String libName) {
        boolean useLibrary = true;
        List<String> libraryNames = this.getUseLibraries();
        if (libraryNames != null && !libraryNames.isEmpty()) {
            useLibrary = false;
            for (String libraryName : libraryNames) {
                if (!libName.startsWith(libraryName)) continue;
                useLibrary = true;
                break;
            }
        }
        return useLibrary;
    }

    @Override
    public OMGraphic createArea(CoverageTable covtable, AreaTable areatable, List<Object> facevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, String featureType, int primID) {
        ArrayList<CoordFloatString> ipts = new ArrayList<CoordFloatString>();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return null;
        }
        if (totalSize == 0) {
            return null;
        }
        OMPoly py = LayerGraphicWarehouseSupport.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        py.setIsPolygon(true);
        return py;
    }

    @Override
    public OMGraphic createEdge(CoverageTable c, EdgeTable edgetable, List<Object> edgevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, CoordFloatString coords, String featureType, int primID) {
        OMPoly py = LayerGraphicWarehouseSupport.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        py.setFillPaint(OMColor.clear);
        py.setIsPolygon(false);
        return py;
    }

    @Override
    public OMGraphic createText(CoverageTable c, TextTable texttable, List<Object> textvec, double latitude, double longitude, String text, String featureType, int primID) {
        OMText txt = LayerGraphicWarehouseSupport.createOMText(text, latitude, longitude);
        return txt;
    }

    @Override
    public OMGraphic createNode(CoverageTable c, NodeTable t, List<Object> nodeprim, double latitude, double longitude, boolean isEntityNode, String featureType, int primID) {
        OMScalingIcon pt = new OMScalingIcon(latitude, longitude, (Image)null);
        pt.setBaseScale(500000.0f);
        pt.setMinScale(500000.0f);
        pt.setMaxScale(2000000.0f);
        return pt;
    }

    @Override
    public boolean needToFetchTileContents(String libraryName, String currentFeature, TileDirectory currentTile) {
        return true;
    }

    public OMGraphicList getFeatures(LibrarySelectionTable lst, LatLonPoint ll1, LatLonPoint ll2, Projection proj, OMGraphicList omgList) throws FormatException {
        if (this.priorities == null) {
            this.init();
        }
        if (ll1.getX() > ll2.getX()) {
            omgList = this.getFeatures(lst, ll1, new LatLonPoint.Double(ll2.getY(), 179.99999), proj, omgList);
            omgList = this.getFeatures(lst, new LatLonPoint.Double(ll1.getY(), -180.0), ll2, proj, omgList);
            return omgList;
        }
        if (omgList == null) {
            omgList = new OMGraphicList();
        }
        omgList.setTraverseMode(0);
        int screenheight = proj.getHeight();
        int screenwidth = proj.getWidth();
        double dpplat = Math.abs((ll1.getY() - ll2.getY()) / (double)screenheight);
        double dpplon = Math.abs((ll1.getX() - ll2.getX()) / (double)screenwidth);
        DataBounds screenBounds = new DataBounds(ll1, ll2);
        for (String libraryName : lst.getLibraryNames()) {
            CoverageAttributeTable cat;
            if (!this.checkLibraryForUsage(libraryName)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("reading library: " + libraryName);
            }
            if ((cat = lst.getCAT(libraryName)) == null) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("no CoverageAttributeTable for " + libraryName + ", skipping...");
                continue;
            }
            DataBounds bounds = cat.getBounds();
            if (bounds != null && !screenBounds.intersects(bounds)) {
                logger.fine("CoverageAttributeTable for " + libraryName + " not on map, skipping...");
                continue;
            }
            for (String covname : cat.getCoverageNames()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("for coverage: " + covname + ", coverage topology level: " + cat.getCoverageTopologyLevel(covname));
                }
                CoverageTable coverageTable = cat.getCoverageTable(covname);
                coverageTable.getFeatures(this, ll1, ll2, dpplat, dpplon, omgList);
            }
        }
        for (FeaturePriorityHolder ph : this.priorities) {
            OMGraphicList list = ph.getList();
            if (list == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding features from " + ph.toString() + ": " + list.size() + " features");
            }
            list.generate(proj);
            omgList.addAll(list);
            list.setVisible(this.debugFacc == null || ph.getDebugFacc() != null);
            ph.resetList();
        }
        logger.fine("returning from prepare ************");
        return omgList;
    }

    @Override
    public boolean drawEdgeFeatures() {
        return true;
    }

    @Override
    public boolean drawTextFeatures() {
        return true;
    }

    @Override
    public boolean drawAreaFeatures() {
        return true;
    }

    @Override
    public boolean drawEPointFeatures() {
        return true;
    }

    @Override
    public boolean drawCPointFeatures() {
        return true;
    }

    public double getExternalAttribute(String rightSide) {
        double ret = -1.0;
        if (rightSide != null) {
            if (rightSide.equals(EV_IDSM)) {
                ret = this.idsm;
            } else if (rightSide.equals(EV_ISDM)) {
                ret = this.isdm;
            } else if (rightSide.equals(EV_MSDC)) {
                ret = this.msdc;
            } else if (rightSide.equals(EV_MSSC)) {
                ret = this.mssc;
            } else if (rightSide.equals(EV_SSDC)) {
                ret = this.ssdc;
            }
        }
        return ret;
    }

    public void handleInformationForOMGraphic(OMGraphic omg, FeatureClassInfo fci, List<Object> fcirow) {
        if (this.featInfoHandler != null) {
            this.featInfoHandler.updateInfoForOMGraphic(omg, fci, fcirow);
        }
    }

    @Override
    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        Object obj;
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.faccLookupFilePath = props.getProperty(prefix + SYMBOL_LOOKUP_FILE_PROPERTY, this.faccLookupFilePath);
        this.priorityFilePath = props.getProperty(prefix + PRIORITY_FILE_PROPERTY, this.priorityFilePath);
        this.debugFacc = props.getProperty(prefix + FACC_DEBUG_PROPERTY, this.debugFacc);
        this.geoSymDirectory = props.getProperty(prefix + CGM_DIR_PROPERTY, this.geoSymDirectory);
        this.iconSize = PropUtils.intFromProperties(props, prefix + ICON_SIZE_PROPERTY, this.iconSize);
        String fihString = props.getProperty(prefix + FEATURE_INFO_HANDLER_PROPERTY);
        if (fihString != null && (obj = ComponentFactory.create(fihString, prefix, props)) instanceof VPFFeatureInfoHandler) {
            this.featInfoHandler = (VPFFeatureInfoHandler)obj;
        }
        this.isdm = PropUtils.doubleFromProperties(props, prefix + EV_ISDM, this.isdm);
        this.idsm = PropUtils.doubleFromProperties(props, prefix + EV_IDSM, this.idsm);
        this.msdc = PropUtils.doubleFromProperties(props, prefix + EV_MSDC, this.msdc);
        this.mssc = PropUtils.doubleFromProperties(props, prefix + EV_MSSC, this.mssc);
        this.ssdc = PropUtils.doubleFromProperties(props, prefix + EV_SSDC, this.ssdc);
    }

    @Override
    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + SYMBOL_LOOKUP_FILE_PROPERTY, this.faccLookupFilePath);
        getList.put(prefix + PRIORITY_FILE_PROPERTY, this.priorityFilePath);
        getList.put(prefix + CGM_DIR_PROPERTY, this.geoSymDirectory);
        if (this.featInfoHandler != null) {
            getList.put(prefix + FEATURE_INFO_HANDLER_PROPERTY, this.featInfoHandler.getClass().getName());
            if (this.featInfoHandler instanceof PropertyConsumer) {
                ((PropertyConsumer)((Object)this.featInfoHandler)).getProperties(getList);
            }
        }
        getList.put(prefix + ICON_SIZE_PROPERTY, Integer.toString(this.iconSize));
        if (this.debugFacc != null && this.debugFacc.length() > 0) {
            getList.put(prefix + FACC_DEBUG_PROPERTY, this.debugFacc);
        }
        getList.put(prefix + EV_ISDM, Double.toString(this.isdm));
        getList.put(prefix + EV_IDSM, Double.toString(this.idsm));
        getList.put(prefix + EV_MSDC, Double.toString(this.msdc));
        getList.put(prefix + EV_MSSC, Double.toString(this.mssc));
        getList.put(prefix + EV_SSDC, Double.toString(this.ssdc));
        return getList;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        I18n i18n = Environment.getI18n();
        PropUtils.setI18NPropertyInfo(i18n, list, VPFAutoFeatureGraphicWarehouse.class, SYMBOL_LOOKUP_FILE_PROPERTY, "Symbol Lookup File", "The path to the file containing symbol lookup information", "com.bbn.openmap.util.propertyEditor.FilePropertyEditor");
        PropUtils.setI18NPropertyInfo(i18n, list, VPFAutoFeatureGraphicWarehouse.class, PRIORITY_FILE_PROPERTY, "Priority File", "The path to the file containing feature type and order to use for display", "com.bbn.openmap.util.propertyEditor.FilePropertyEditor");
        PropUtils.setI18NPropertyInfo(i18n, list, VPFAutoFeatureGraphicWarehouse.class, CGM_DIR_PROPERTY, "CGM Directory Path", "The path to the directory containing GeoSym CGM files", "com.bbn.openmap.util.propertyEditor.DirectoryPropertyEditor");
        PropUtils.setI18NPropertyInfo(i18n, list, VPFAutoFeatureGraphicWarehouse.class, FACC_DEBUG_PROPERTY, "FACC Debug", "A FACC code to use to debug problems with data set", null);
        PropUtils.setI18NPropertyInfo(i18n, list, VPFAutoFeatureGraphicWarehouse.class, ICON_SIZE_PROPERTY, "Icon Size", "The pixel size of icons for point features", null);
        return list;
    }

    @Override
    public void setPropertyPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getPropertyPrefix() {
        return this.prefix;
    }

    @Override
    public void resetForCAT() {
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    @Override
    public Component getGUI(LibrarySelectionTable lst) {
        return null;
    }

    @Override
    public List<String> getFeatures() {
        return Collections.emptyList();
    }

    public VPFFeatureInfoHandler getFeatInfoHandler() {
        return this.featInfoHandler;
    }

    public void setFeatInfoHandler(VPFFeatureInfoHandler featInfoHandler) {
        this.featInfoHandler = featInfoHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class FeaturePriorityHolder {
        protected char type;
        protected String facc;
        protected OMGraphicList list;
        protected int dim = 20;
        protected float sizePercent = 1.0f;
        protected float xoffPercent = 0.0f;
        protected float yoffPercent = 0.0f;
        protected String debugFacc = null;

        protected FeaturePriorityHolder(String type, String facc, VPFAutoFeatureGraphicWarehouse warehouse) {
            this.type = VPFAutoFeatureGraphicWarehouse.getType(type);
            this.facc = facc;
            this.dim = warehouse.getIconSize();
            if (warehouse.debugFacc != null && warehouse.debugFacc.equals(facc)) {
                this.debugFacc = warehouse.debugFacc;
            }
        }

        public OMGraphicList getList() {
            if (this.debugFacc != null && this.list != null && logger.isLoggable(Level.FINE)) {
                logger.fine(this.list.getDescription());
            }
            return this.list;
        }

        public String getFacc() {
            return this.facc;
        }

        String getDebugFacc() {
            return this.debugFacc;
        }

        public void resetList() {
            if (this.list != null) {
                this.list.clear();
            }
        }

        public void updateLocation(String size, String xoff, String yoff) {
            this.sizePercent = this.getValue(size, 1.0f);
            this.xoffPercent = this.getValue(xoff, 0.0f);
            this.yoffPercent = this.getValue(yoff, 0.0f);
        }

        protected float getValue(String s, float def) {
            float ret = def;
            if (s != null) {
                try {
                    ret = Float.parseFloat(s);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            return ret;
        }

        public abstract boolean matches(String var1, FeatureClassInfo var2, List<Object> var3);

        public abstract boolean matches(String var1, char var2, String var3, String var4, String var5, String var6, String var7);

        protected abstract void add(OMGraphic var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class Compound
        extends FeaturePriorityHolder
        implements ImageObserver {
            protected List<Basic> parts = new ArrayList<Basic>();
            protected BufferedImage icon;

            protected Compound(String type, String facc, VPFAutoFeatureGraphicWarehouse warehouse) {
                super(type, facc, warehouse);
            }

            public String toString() {
                return "Compound: " + this.type + "|" + this.facc;
            }

            public void addPart(Basic part) {
                this.parts.add(part);
            }

            @Override
            public boolean matches(String facc, FeatureClassInfo fci, List<Object> row) {
                boolean ret = false;
                int partCount = 0;
                char type = fci.getFeatureType();
                if (type == 'E' || type == 'N') {
                    type = 'P';
                }
                if (facc.equals(this.facc) && this.type == type) {
                    BufferedImage image = new BufferedImage(this.dim, this.dim, 2);
                    Graphics2D g = (Graphics2D)image.getGraphics();
                    for (Basic part : this.parts) {
                        if (part.expression != null) {
                            boolean partRet = part.expression.evaluate(fci, row);
                            if (!partRet) continue;
                            Image im = part.getIcon();
                            g.drawImage(im, (int)(part.xoffPercent * (float)this.dim), (int)(part.yoffPercent * (float)this.dim), this);
                            ret = true;
                            ++partCount;
                            continue;
                        }
                        Image im = part.getIcon();
                        g.drawImage(im, (int)(part.xoffPercent * (float)this.dim), (int)(part.yoffPercent * (float)this.dim), this);
                        ret = true;
                        ++partCount;
                    }
                    this.icon = image;
                }
                return ret;
            }

            @Override
            public boolean matches(String facc, char type, String conditions, String symbolFileName, String size, String xoff, String yoff) {
                Basic part;
                boolean basicMatch = this.facc.equals(facc) && type == this.type;
                boolean conditionMatch = false;
                Iterator<Basic> i$ = this.parts.iterator();
                while (i$.hasNext() && !(conditionMatch = (part = i$.next()).matches(facc, type, conditions, symbolFileName, size, xoff, yoff))) {
                }
                return basicMatch && conditionMatch;
            }

            @Override
            public void add(OMGraphic omg) {
                if (this.list == null) {
                    this.list = new OMGraphicList();
                }
                if (this.icon != null) {
                    if (omg instanceof OMPoint.Image) {
                        ((OMPoint.Image)omg).setImage(this.icon);
                        this.list.add(omg);
                    } else if (omg instanceof OMRasterObject) {
                        ((OMRasterObject)omg).setImage(this.icon);
                        this.list.add(omg);
                    }
                }
            }

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class Basic
        extends FeaturePriorityHolder {
            protected GeoSymAttExpression expression;
            protected String conditions;
            protected String symbolParentDir;
            protected String symbolExt;
            protected String[] cgmTitle;
            protected CGMDisplay[] cgmDisplay;
            protected BufferedImage icon;

            protected Basic(String type, String facc, String cond, VPFAutoFeatureGraphicWarehouse warehouse) {
                super(type, facc, warehouse);
                if (cond != null && cond.trim().length() > 0) {
                    this.conditions = cond.replace(" ", "");
                    this.expression = new GeoSymAttExpression(this.conditions, warehouse);
                }
            }

            public String toString() {
                return this.type + "|" + this.facc + "|" + this.conditions;
            }

            public void setCGMPath(String parent, String append) {
                this.symbolParentDir = parent;
                this.symbolExt = append;
            }

            public Image getIcon() {
                if (this.icon == null) {
                    try {
                        if (this.debugFacc != null) {
                            logger.info("initializing cgm for " + this.toString());
                        }
                        if (this.cgmTitle == null) {
                            logger.fine("no title for " + this.toString());
                        } else {
                            this.cgmDisplay = new CGMDisplay[this.cgmTitle.length];
                            for (int i = 0; i < this.cgmTitle.length; ++i) {
                                CGM cgm = new CGM(this.cgmTitle[i]);
                                if (this.debugFacc != null) {
                                    logger.info("  using " + this.cgmTitle[i]);
                                }
                                this.cgmDisplay[i] = new CGMDisplay(cgm);
                                this.icon = this.cgmDisplay[i].getBufferedImage((int)((float)this.dim * this.sizePercent), (int)((float)this.dim * this.sizePercent));
                            }
                        }
                    }
                    catch (IOException ioe) {
                        logger.fine("Couldn't load CGM files: " + this.cgmTitle[0] + "; first of " + this.cgmTitle.length);
                    }
                }
                return this.icon;
            }

            @Override
            public boolean matches(String facc, FeatureClassInfo fci, List<Object> row) {
                boolean ret = false;
                char type = fci.getFeatureType();
                if (type == 'E' || type == 'N') {
                    type = 'P';
                }
                if (facc.equals(this.facc) && this.type == type) {
                    ret = this.expression != null ? this.expression.evaluate(fci, row) : true;
                }
                return ret;
            }

            @Override
            public boolean matches(String facc, char type, String conditions, String symbolFileName, String size, String xoff, String yoff) {
                boolean ret;
                boolean basicMatch = this.facc.equals(facc) && type == this.type;
                boolean conditionMatch = (this.conditions == null || this.conditions.trim().length() == 0) && (conditions == null || conditions.trim().length() == 0) || this.conditions != null && this.conditions.equals(conditions);
                boolean bl = ret = basicMatch && conditionMatch;
                if (ret) {
                    Vector<String> names = PropUtils.parseSpacedMarkers(symbolFileName);
                    this.cgmTitle = new String[names.size()];
                    for (int i = 0; i < names.size(); ++i) {
                        this.cgmTitle[i] = this.symbolParentDir + "/" + names.get(i) + this.symbolExt;
                        this.updateLocation(size, xoff, yoff);
                    }
                }
                return ret;
            }

            @Override
            public void add(OMGraphic omg) {
                if (this.list == null) {
                    this.list = new OMGraphicList();
                }
                Image icon = this.getIcon();
                if (this.cgmDisplay != null) {
                    if (omg instanceof OMPoint.Image) {
                        ((OMPoint.Image)omg).setImage(icon);
                    } else if (omg instanceof OMRasterObject) {
                        ((OMRasterObject)omg).setImage(icon);
                    } else if (omg instanceof OMPoly) {
                        OMPoly omp = (OMPoly)omg;
                        if (!omp.isPolygon()) {
                            if (this.cgmDisplay[0] != null) {
                                omp.setLinePaint(this.cgmDisplay[0].getLineColor());
                                omp.setStroke(new BasicStroke(1.0f));
                                omp.setFillPaint(OMColor.clear);
                            }
                        } else if (this.cgmDisplay.length == 1 && this.cgmDisplay[0] != null) {
                            omp.setFillPaint(this.cgmDisplay[0].getFillColor());
                            omp.setLinePaint(this.cgmDisplay[0].getFillColor());
                        } else if (this.cgmDisplay.length > 1 && this.cgmDisplay[1] != null) {
                            omp.setFillPaint(this.cgmDisplay[1].getFillColor());
                            omp.setLinePaint(this.cgmDisplay[1].getFillColor());
                        }
                    }
                }
                this.list.add(omg);
            }

            public String getConditions() {
                return this.conditions;
            }
        }
    }
}

