/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.RenderingHintsRenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

public class BufferedImageRenderPolicy
extends RenderingHintsRenderPolicy {
    protected OMRaster buffer = null;
    protected String CURRENT_PROJECTION = "currentProjection";

    public BufferedImageRenderPolicy() {
    }

    public BufferedImageRenderPolicy(OMGraphicHandlerLayer layer) {
        super(layer);
    }

    public void prePrepare() {
        OMRaster buffer = this.getBuffer();
        Projection proj = this.layer.getProjection();
        if (proj instanceof Cylindrical && buffer != null) {
            buffer.setNeedToRegenerate(true);
            buffer.generate(proj);
        } else {
            this.setBuffer(null);
        }
    }

    public OMGraphicList prepare() {
        if (this.layer != null) {
            Projection proj = this.layer.getProjection();
            OMGraphicList list = this.layer.prepare();
            try {
                this.setBuffer(this.createAndPaintImageBuffer(list, proj));
            }
            catch (NullPointerException npe) {
                logger.fine("Caught NPE creating the image buffer for layer: " + this.layer.getName());
                if (logger.isLoggable(Level.FINE)) {
                    npe.printStackTrace();
                }
                this.setBuffer(null);
            }
            return list;
        }
        logger.warning("NULL layer, can't do anything.");
        return null;
    }

    public void paint(Graphics g) {
        if (this.layer == null) {
            logger.warning("NULL layer, skipping...");
            return;
        }
        OMGraphicList list = this.layer.getList();
        Projection proj = this.layer.getProjection();
        Graphics2D g2 = (Graphics2D)g.create();
        OMRaster bufferedImage = this.getBuffer();
        if (this.layer.isProjectionOK(proj)) {
            if (bufferedImage == null && list != null) {
                bufferedImage = this.createAndPaintImageBuffer(list, proj);
                this.setBuffer(bufferedImage);
                this.setCompositeOnGraphics(g2);
                if (bufferedImage != null) {
                    Object imageProj = bufferedImage.getAttribute(this.CURRENT_PROJECTION);
                    Projection newProj = this.layer.getProjection();
                    if (!newProj.equals(imageProj)) {
                        bufferedImage.generate(newProj);
                        bufferedImage.putAttribute(this.CURRENT_PROJECTION, newProj);
                    }
                    bufferedImage.render(g2);
                } else {
                    super.setRenderingHints(g2);
                    list.render(g2);
                }
            } else if (bufferedImage != null) {
                Object imageProj = bufferedImage.getAttribute(this.CURRENT_PROJECTION);
                Projection newProj = this.layer.getProjection();
                if (!newProj.equals(imageProj)) {
                    bufferedImage.generate(newProj);
                    bufferedImage.putAttribute(this.CURRENT_PROJECTION, newProj);
                }
                this.setCompositeOnGraphics(g2);
                bufferedImage.render(g2);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.layer.getName() + ".paint(): " + (list == null ? "NULL list, skipping..." : " skipping due to projection."));
        }
        g2.dispose();
    }

    protected OMRaster getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(OMRaster bi) {
        this.buffer = bi;
    }

    protected OMRaster createAndPaintImageBuffer(OMGraphicList list, Projection proj) {
        OMRaster omr = null;
        if (proj != null && list != null && this.layer != null) {
            int w = proj.getWidth();
            int h = proj.getHeight();
            Object llp1 = proj.getUpperLeft();
            Object llp2 = proj.inverse(w, h);
            Point2D pnt1 = proj.forward((Point2D)llp1);
            Point2D pnt2 = proj.forward((Point2D)llp2);
            if (pnt1.getX() < pnt2.getX() && proj instanceof Cylindrical) {
                double yOffset = 0.0;
                double pnt1y = Math.round(pnt1.getY());
                double pnt2y = Math.round(pnt2.getY());
                if (pnt1y > 0.0 || pnt2y < (double)(h - 1)) {
                    h = (int)Math.floor(pnt2y - pnt1y);
                    yOffset = pnt1y;
                }
                if (h > 0 && w > 0) {
                    BufferedImage bufferedImage = new BufferedImage(w, h, 2);
                    Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
                    super.setRenderingHints(g2d);
                    if (yOffset != 0.0) {
                        g2d.setTransform(AffineTransform.getTranslateInstance(0.0, -yOffset));
                    }
                    list.generate(proj);
                    list.render(g2d);
                    omr = new OMScalingRaster(((Point2D)llp1).getY(), ((Point2D)llp1).getX(), ((Point2D)llp2).getY(), ((Point2D)llp2).getX(), (Image)bufferedImage);
                }
            } else {
                BufferedImage bufferedImage = new BufferedImage(w, h, 2);
                Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
                super.setRenderingHints(g2d);
                list.render(g2d);
                omr = new OMRaster(0, 0, (Image)bufferedImage);
            }
            if (omr != null) {
                omr.generate(proj);
                omr.putAttribute(this.CURRENT_PROJECTION, proj);
            }
        }
        return omr;
    }
}

