/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.event.OMEventSelectionCoordinator;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.event.EventPresenter;
import com.bbn.openmap.gui.time.HotwashTimerControlButtonPanel;
import com.bbn.openmap.gui.time.ITimeBoundsUserActionsListener;
import com.bbn.openmap.gui.time.TimeSliderPanel;
import com.bbn.openmap.gui.time.TimelinePanel;
import com.bbn.openmap.gui.time.TimerRateComboBox;
import com.bbn.openmap.time.Clock;
import com.bbn.openmap.time.TimeEvent;
import com.bbn.openmap.time.TimeEventListener;
import com.bbn.openmap.time.TimerRateHolder;
import com.bbn.openmap.util.PropUtils;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.AbstractBorder;

public class TimePanel
extends OMComponentPanel
implements MapPanelChild,
PropertyChangeListener,
TimeEventListener {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.time.TimePanel");
    public static final String PlayFilterProperty = "playfilter";
    public static final String NO_TIME_STRING = "--:--:-- (--:--:--)";
    public static final String PanelTitleProperty = "panelTitle";
    private String defaultPanelTitle = "  Timeline Controls  ";
    public static final String RealTimeModeProperty = "realTimeMode";
    private boolean realTimeMode = false;
    public static final String ShowPlayFilterProperty = "showPlayFilter";
    private boolean showPlayFilter = true;
    protected Clock clock;
    protected JToggleButton timeWrapToggle;
    protected JLabel timeLabel;
    protected JLabel mouseTimeLabel;
    protected JLabel eventDetailLabel;
    protected JCheckBox playFilter;
    protected HotwashTimerControlButtonPanel timerControl;
    protected TimerRateComboBox timerRateControl;
    protected String preferredLocation = "South";
    protected boolean useTimeWrapToggle = false;
    public transient DecimalFormat df = new DecimalFormat("00");
    TimelinePanel timelinePanel;
    TimeSliderPanel timeSliderPanel;
    protected String parentName;
    public static final DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy (HH:mm:ss)");
    public static final DateFormat dateFormat_realTime = new SimpleDateFormat("MM/dd/yyyy  HH:mm:ss");
    public static final DateFormat dayFormat = new SimpleDateFormat("MM/dd/yyyy");

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.parentName = props.getProperty(prefix + "parent");
        this.defaultPanelTitle = props.getProperty(prefix + PanelTitleProperty, this.defaultPanelTitle);
        this.realTimeMode = PropUtils.booleanFromProperties(props, prefix + RealTimeModeProperty, this.realTimeMode);
        this.showPlayFilter = PropUtils.booleanFromProperties(props, prefix + ShowPlayFilterProperty, this.showPlayFilter);
        if (this.realTimeMode) {
            this.getTimeSliderPanel();
        }
    }

    public void createInterface() {
        this.removeAll();
        String internString = this.i18n.get(this.getClass(), "timeline_controls", this.defaultPanelTitle);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), internString));
        if (this.clock == null) {
            logger.info("No clock, not putting anything in interface.");
            return;
        }
        JPanel leftPanel = new JPanel();
        GridBagLayout lgridbag = new GridBagLayout();
        leftPanel.setLayout(lgridbag);
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(2, 4, 2, 4);
        c.weightx = 0.0;
        c.fill = 3;
        c.weighty = 1.0;
        c.gridx = 0;
        c.insets = insets;
        internString = this.i18n.get(this.getClass(), "play_selected", "Play Filter");
        if (this.showPlayFilter) {
            this.playFilter = new JCheckBox(internString);
            internString = this.i18n.get(this.getClass(), "play_selected", 3, "Jump clock to events with play filter markings.");
            this.playFilter.setToolTipText(internString);
            this.playFilter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox jcb = (JCheckBox)ae.getSource();
                    TimePanel.this.firePropertyChange(TimePanel.PlayFilterProperty, new Boolean(!jcb.isSelected()), new Boolean(jcb.isSelected()));
                }
            });
            lgridbag.setConstraints(this.playFilter, c);
            this.playFilter.setVisible(false);
            leftPanel.add(this.playFilter);
        }
        c.fill = 0;
        c.weighty = 0.0;
        JLabel dateTimeLabel = new JLabel("Date (Local Time)", 0);
        lgridbag.setConstraints(dateTimeLabel, c);
        leftPanel.add(dateTimeLabel);
        this.timeLabel = new JLabel(NO_TIME_STRING, 0);
        Font defaultFont = this.timeLabel.getFont();
        this.timeLabel.setFont(new Font(defaultFont.getName(), defaultFont.getStyle(), 12));
        internString = this.i18n.get(this.getClass(), "time", 3, "Time");
        this.timeLabel.setToolTipText(internString);
        lgridbag.setConstraints(this.timeLabel, c);
        leftPanel.add(this.timeLabel);
        this.timerControl = new HotwashTimerControlButtonPanel(this.clock);
        lgridbag.setConstraints(this.timerControl, c);
        leftPanel.add(this.timerControl);
        this.clock.addTimeEventListener(this.timerControl);
        this.timerRateControl = new TimerRateComboBox(this.clock);
        internString = this.i18n.get(this.getClass(), "timer_rate_control", 3, "Change Clock Rate For Timeline");
        this.timerRateControl.setToolTipText(internString);
        List<TimerRateHolder> timerRates = this.clock.getTimerRates();
        for (TimerRateHolder trh : timerRates) {
            this.timerRateControl.add(trh.getLabel(), (int)trh.getClockInterval(), (int)trh.getPace());
        }
        int si = timerRates.size() / 2;
        if (si > 0) {
            this.timerRateControl.setSelectedIndex(si);
        }
        insets = new Insets(0, 4, 0, 4);
        JPanel rightPanel = new JPanel();
        GridBagLayout rgridbag = new GridBagLayout();
        rightPanel.setLayout(rgridbag);
        c = new GridBagConstraints();
        c.insets = insets;
        c.fill = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridy = 0;
        c.anchor = 17;
        internString = this.i18n.get(this.getClass(), "mouse_time", "Mouse Time:");
        JLabel mouseTime = new JLabel(internString);
        rgridbag.setConstraints(mouseTime, c);
        rightPanel.add(mouseTime);
        this.mouseTimeLabel = new JLabel("");
        rgridbag.setConstraints(this.mouseTimeLabel, c);
        rightPanel.add(this.mouseTimeLabel);
        c.anchor = 13;
        c.fill = 2;
        c.weightx = 1.0;
        this.eventDetailLabel = new JLabel("", 4);
        rgridbag.setConstraints(this.eventDetailLabel, c);
        rightPanel.add(this.eventDetailLabel);
        TimelinePanel timelinePanel = this.getTimelinePanel();
        timelinePanel.addMapComponent(new Wrapper(this));
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridy = 1;
        rgridbag.setConstraints(timelinePanel, c);
        rightPanel.add(timelinePanel);
        TimeSliderPanel timeSliderPanel = this.getTimeSliderPanel();
        timeSliderPanel.addMapComponent(timelinePanel.getWrapper());
        c.fill = 2;
        c.weighty = 0.0;
        c.gridy = 2;
        rgridbag.setConstraints(timeSliderPanel, c);
        rightPanel.add(timeSliderPanel);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 3;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        gridbag.setConstraints(leftPanel, c);
        this.add(leftPanel);
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 4, 0);
        gridbag.setConstraints(rightPanel, c);
        this.add(rightPanel);
        this.revalidate();
    }

    public void updateEventDetailsDisplay(String details) {
        if (this.eventDetailLabel != null) {
            this.eventDetailLabel.setText(details);
        }
    }

    public void updateMouseTimeDisplay(long mouseOffsetTime) {
        String mtds = "--";
        if (this.realTimeMode) {
            if (mouseOffsetTime > this.timelinePanel.getTimelineLayer().getEndTime()) {
                mouseOffsetTime = this.timelinePanel.getTimelineLayer().getEndTime();
            }
        } else if (mouseOffsetTime < 0L) {
            mouseOffsetTime = 0L;
        }
        if (mouseOffsetTime >= 0L) {
            mtds = this.convertOffsetTimeToText(mouseOffsetTime);
        }
        if (this.mouseTimeLabel != null) {
            this.mouseTimeLabel.setText(mtds);
        }
    }

    public String convertOffsetTimeToText(long offsetTimeFromLeft) {
        long offsetTime = offsetTimeFromLeft;
        if (this.realTimeMode) {
            offsetTime -= this.timelinePanel.getTimelineLayer().getDuration();
        }
        String sign = "";
        if (offsetTime < 0L) {
            sign = "-";
            offsetTime = -offsetTime;
        }
        int hours = (int)(offsetTime / 3600000L);
        int minutes = (int)Math.abs(offsetTime % 3600000L / 60000L);
        int seconds = (int)Math.abs(offsetTime % 60000L / 1000L);
        String relativeTime = sign + this.df.format(hours) + ":" + this.df.format(minutes) + ":" + this.df.format(seconds);
        if (this.realTimeMode) {
            Date date = new Date(offsetTimeFromLeft + this.timeSliderPanel.getTimeSliderLayer().gameStartTime);
            return dateFormat_realTime.format(date) + "   (" + relativeTime + ")";
        }
        return relativeTime;
    }

    public void setPreferredLocation(String loc) {
        this.preferredLocation = loc;
    }

    public String getPreferredLocation() {
        return this.preferredLocation;
    }

    public void updateTime(TimeEvent te) {
        if (this.checkAndSetForNoTime(te)) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TimePanel received TIMER_STATUS property update: " + te);
        }
        this.updateTimeLabel(te.getSystemTime(), te.getOffsetTime());
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        Object newVal = pce.getNewValue();
        if (propertyName.equals(PlayFilterProperty)) {
            this.timerControl.enableForwardButton((Boolean)newVal);
        } else if (propertyName.equals("mouseTime")) {
            this.updateMouseTimeDisplay((Long)newVal);
        } else if (propertyName.equals("eventDetails")) {
            this.updateEventDetailsDisplay((String)newVal);
        }
        this.revalidate();
    }

    protected boolean checkAndSetForNoTime(TimeEvent te) {
        boolean isNoTime;
        boolean bl = isNoTime = te == TimeEvent.NO_TIME;
        if (isNoTime) {
            this.updateEventDetailsDisplay("");
            this.updateMouseTimeDisplay(0L);
            this.timeLabel.setText(NO_TIME_STRING);
        }
        return isNoTime;
    }

    public void updateTimeLabel(long sysTime, long offsetTime) {
        if (this.timeLabel != null) {
            if (sysTime != Long.MAX_VALUE) {
                if (this.realTimeMode) {
                    Date date = new Date(sysTime);
                    String timeText = dateFormat_realTime.format(date);
                    this.timeLabel.setText(timeText);
                } else {
                    Date date = new Date(sysTime);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
                    String sts = dateFormat.format(date);
                    this.timeLabel.setText(sts + " (" + this.convertOffsetTimeToText(offsetTime) + ")");
                }
            } else {
                this.timeLabel.setText(NO_TIME_STRING);
            }
        }
    }

    public void setClock(Clock cl) {
        logger.fine("found and setting clock: " + cl);
        if (this.clock != null) {
            this.clock.removeTimeEventListener(this);
        }
        this.clock = cl;
        this.createInterface();
        if (this.clock != null) {
            this.clock.addTimeEventListener(this);
        }
    }

    public void setPlayFilterVisible(boolean visible) {
        if (this.playFilter != null) {
            this.playFilter.setVisible(visible);
        }
    }

    public boolean isPlayFilterVisible() {
        return this.playFilter != null && this.playFilter.isVisible();
    }

    public Clock getClock() {
        return this.clock;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof Clock) {
            this.setClock((Clock)someObj);
            this.getTimelinePanel().getMapHandler().add(someObj);
            this.getTimeSliderPanel().getMapHandler().add(someObj);
        }
        if (someObj instanceof OMEventSelectionCoordinator) {
            this.getTimelinePanel().getMapHandler().add(someObj);
        }
        if (someObj instanceof EventPresenter) {
            this.getTimelinePanel().getMapHandler().add(someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof Clock && this.getClock() == someObj) {
            this.setClock(null);
        }
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String pName) {
        this.parentName = pName;
    }

    public TimelinePanel getTimelinePanel() {
        if (this.timelinePanel == null) {
            this.timelinePanel = new TimelinePanel();
            this.timelinePanel.setRealTimeMode(this.realTimeMode);
        }
        return this.timelinePanel;
    }

    public TimeSliderPanel getTimeSliderPanel() {
        if (this.timeSliderPanel == null) {
            this.timeSliderPanel = new TimeSliderPanel(this.realTimeMode);
        }
        return this.timeSliderPanel;
    }

    public void setUserHasChangedScale(boolean userHasChangedScale) {
        this.timeSliderPanel.setUserHasChangedScale(userHasChangedScale);
    }

    public void addTimeBoundsUserActionsListener(ITimeBoundsUserActionsListener timeBoundsUserActionsListener) {
        this.timeSliderPanel.addTimeBoundsUserActionsListener(timeBoundsUserActionsListener);
    }

    public void removeTimeBoundsUserActionsListener(ITimeBoundsUserActionsListener timeBoundsUserActionsListener) {
        this.timeSliderPanel.removeTimeBoundsUserActionsListener(timeBoundsUserActionsListener);
    }

    public static class Wrapper {
        TimePanel timePanel;

        public Wrapper(TimePanel panel) {
            this.timePanel = panel;
        }

        public TimePanel getTimePanel() {
            return this.timePanel;
        }
    }

    public class NoBorder
    extends AbstractBorder {
        NoBorder() {
        }
    }
}

