/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.NavMouseMode2;
import com.bbn.openmap.gui.OverviewMapHandler;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class DefaultOverviewMouseMode
extends NavMouseMode2 {
    OverviewMapHandler overviewMapHandler;

    public DefaultOverviewMouseMode(OverviewMapHandler omh) {
        super(true);
        this.overviewMapHandler = omh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            System.out.println(this.getID() + "|DefaultOverviewMouseMode.mouseReleased()");
        }
        Object obj = e.getSource();
        if (!this.mouseSupport.fireMapMouseReleased(e)) {
            if (!(obj instanceof MapBean) || !this.autoZoom || this.point1 == null) {
                return;
            }
            MapBean map = (MapBean)obj;
            Projection projection = map.getProjection();
            DefaultOverviewMouseMode defaultOverviewMouseMode = this;
            synchronized (defaultOverviewMouseMode) {
                int deltaPix;
                float deltaDegrees;
                this.point2 = this.getRatioPoint(map, this.point1, e.getPoint());
                int dx = Math.abs(this.point2.x - this.point1.x);
                int dy = Math.abs(this.point2.y - this.point1.y);
                if (dx < 5 || dy < 5) {
                    this.paintRectangle(map, this.point1, this.point2);
                    if (dx < 5 && dy < 5) {
                        Object llp = projection.inverse(e.getPoint());
                        this.overviewMapHandler.getControlledMapListeners().setCenter((Point2D)llp);
                    }
                    return;
                }
                Object ll1 = projection.inverse(this.point1);
                Object ll2 = projection.inverse(this.point2);
                dx = Math.abs(this.point2.x - this.point1.x);
                if (dx < (dy = Math.abs(this.point2.y - this.point1.y))) {
                    float dlat = (float)Math.abs(((Point2D)ll1).getY() - ((Point2D)ll2).getY());
                    deltaDegrees = dlat * 2.0f;
                    deltaPix = this.overviewMapHandler.getSourceMap().getProjection().getHeight();
                } else {
                    float lon2;
                    float lon1;
                    if (this.point1.x > this.point2.x) {
                        float lat1 = (float)((Point2D)ll1).getY();
                        lon1 = (float)((Point2D)ll1).getX();
                        ((Point2D)ll1).setLocation((Point2D)ll2);
                        ((Point2D)ll2).setLocation(lon1, lat1);
                    }
                    float dlon = (lon1 = (float)((Point2D)ll1).getX()) > (lon2 = (float)((Point2D)ll2).getX()) ? 180.0f - lon1 + (180.0f + lon2) : lon2 - lon1;
                    deltaDegrees = dlon * 2.0f;
                    deltaPix = this.overviewMapHandler.getSourceMap().getProjection().getWidth();
                }
                if (projection instanceof GeoProj) {
                    double pixPerDegree = ((GeoProj)projection).getPlanetPixelCircumference() / 360.0;
                    double newScale = pixPerDegree / (double)((float)deltaPix / deltaDegrees);
                    this.overviewMapHandler.getControlledMapListeners().setScale((float)newScale);
                }
                Object center = projection.inverse(this.point1.x, this.point1.y);
                this.overviewMapHandler.getControlledMapListeners().setCenter((Point2D)center);
            }
            this.point1 = null;
            this.point2 = null;
        }
    }

    protected Point getRatioPoint(MapBean map, Point pt1, Point pt2) {
        return ProjMath.getRatioPoint(this.overviewMapHandler.getSourceMap().getProjection(), pt1, pt2);
    }
}

