/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriIconPoint;
import com.bbn.openmap.dataAccess.shape.EsriPoint;
import com.bbn.openmap.dataAccess.shape.EsriTextPoint;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMScalingIcon;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import java.util.Iterator;

public class EsriPointList
extends EsriGraphicList {
    public boolean add(OMGraphic shape) {
        try {
            if (this.typeMatches(shape)) {
                this.addExtents(((EsriGraphic)((Object)shape)).getExtents());
                return this.graphics.add(shape);
            }
            if (shape instanceof OMPoint) {
                shape = EsriPoint.convert((OMPoint)shape);
            } else if (shape instanceof OMText) {
                shape = EsriTextPoint.convert((OMText)shape);
            } else if (shape instanceof OMScalingIcon) {
                shape = EsriIconPoint.convert((OMScalingIcon)shape);
            } else {
                if (shape instanceof OMGraphicList && !((OMGraphicList)shape).isVague()) {
                    Iterator it = ((OMGraphicList)shape).iterator();
                    while (it.hasNext()) {
                        this.add((OMGraphic)it.next());
                    }
                    return true;
                }
                Debug.message("esri", "EsriPointList.add()- graphic isn't an EsriGraphic with matching type, can't add.");
                return false;
            }
            if (shape instanceof EsriGraphic) {
                this.graphics.add(shape);
                this.addExtents(((EsriGraphic)((Object)shape)).getExtents());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public boolean typeMatches(OMGraphic omg) {
        return omg instanceof EsriGraphic && ((EsriGraphic)((Object)omg)).getType() == this.getType();
    }

    public EsriPointList() {
        this.setType(1);
    }

    public EsriPointList(int initialCapacity) {
        super(initialCapacity);
    }

    public EsriPointList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity);
    }

    public EsriGraphic shallowCopy() {
        EsriPointList ret = new EsriPointList(this.size());
        ret.setAttributes(this.getAttributes());
        for (EsriGraphic g : this) {
            ret.add((OMGraphic)((Object)g.shallowCopy()));
        }
        return ret;
    }
}

