/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.geom.Point2D;

public abstract class AbstractMapTileCoordinateTransform
implements MapTileCoordinateTransform {
    int tileSize = 256;

    public Point2D latLonToTileUV(Point2D latlon, int zoom) {
        return this.latLonToTileUV(latlon, zoom, null);
    }

    public Point2D tileUVToLatLon(Point2D tileUV, int zoom) {
        return this.tileUVToLatLon(tileUV, zoom, null);
    }

    public float getScaleForZoom(int zoom) {
        Mercator proj = new Mercator(new LatLonPoint.Double(), 1000000.0f, 256, 256);
        return this.getScaleForZoomAndProjection(proj, zoom);
    }

    public float getScaleForZoomAndProjection(Projection proj, int zoom) {
        OSMMapTileCoordinateTransform mtct = new OSMMapTileCoordinateTransform();
        Point2D originLLUL = mtct.tileUVToLatLon(new Point2D.Double(0.0, 0.0), zoom);
        Point2D originLLLR = mtct.tileUVToLatLon(new Point2D.Double(1.0, 1.0), zoom);
        return proj.getScale(originLLUL, originLLLR, UVUL, UVLR);
    }

    public float[] getScalesForZoomLevels(Projection proj, int highZoomLevel) {
        float[] ret = new float[highZoomLevel + 1];
        for (int i = 0; i <= highZoomLevel; ++i) {
            ret[i] = this.getScaleForZoomAndProjection(proj, i);
        }
        return ret;
    }

    public int getTileSize() {
        return this.tileSize;
    }
}

