/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.DatumShiftProjection;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.coords.DatumShiftGCT;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.util.Properties;

public class LLXYLoader
extends BasicProjectionLoader
implements ProjectionLoader {
    public LLXYLoader() {
        super(LLXY.class, "LLXY", "Equivalent projection, used for many web data sources.");
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            LatLonPoint llp = this.convertToLLP((Point2D)props.get("CENTER"));
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            GeoProj proj = new LLXY(llp, scale, width, height);
            Ellipsoid ellps = (Ellipsoid)props.get("DATUM");
            if (ellps != null && ellps != Ellipsoid.WGS_84) {
                proj = new DatumShiftProjection(proj, new DatumShiftGCT(ellps));
            }
            return proj;
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("LLXYLoader: problem creating LLXY projection " + e.getMessage());
            }
            throw new ProjectionException("LLXYLoader: problem creating LLXY projection");
        }
    }
}

