/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.EditableOMGraphicList;
import com.bbn.openmap.omGraphics.editable.EOMGStateMachine;
import com.bbn.openmap.omGraphics.editable.ListSelectedState;
import com.bbn.openmap.omGraphics.editable.ListUnselectedState;
import com.bbn.openmap.util.Debug;
import java.util.Iterator;

public class ListStateMachine
extends EOMGStateMachine {
    public ListStateMachine(EditableOMGraphicList list) {
        super(list);
    }

    protected State[] init() {
        Debug.message("eomg", "ListStateMachine.init()");
        State[] states = super.init();
        states[2] = new ListSelectedState(this.graphic);
        states[1] = new ListUnselectedState(this.graphic);
        return states;
    }

    public boolean isOffsetNeeded() {
        return this.offsetNeeded;
    }

    public void setState(int state) {
        super.setState(state);
        if (Debug.debugging("eomg")) {
            Debug.output("ListStateMachine.setState: Setting state to " + this.states.elementAt(state).getClass().getName());
        }
        Iterator<EditableOMGraphic> it = ((EditableOMGraphicList)this.graphic).getEditables().iterator();
        while (it.hasNext()) {
            try {
                EditableOMGraphic editable = it.next();
                editable.getStateMachine().setState(state);
                if (!Debug.debugging("eomg")) continue;
                Debug.debugging("  on " + editable.getClass().getName());
            }
            catch (NullPointerException npe) {
                Debug.output("ListStateMachine: something's not right setting ListStateMachine.setState()");
            }
        }
    }
}

