/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.mapTile.EmptyTileHandler;
import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Properties;
import java.util.logging.Logger;

public class SimpleEmptyTileHandler
implements EmptyTileHandler,
PropertyConsumer {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.mapTile.EmptyTileHandler");
    public static final String BACKGROUND_PROPERTY = "background";
    public static final String NO_COVERAGE_ZOOM_PROPERTY = "noCoverageZoom";
    public static final int TILE_SIZE = 256;
    protected DrawingAttributes backgroundAtts = DrawingAttributes.getDefaultClone();
    protected DrawingAttributes noCoverageAtts = DrawingAttributes.getDefaultClone();
    protected String prefix;
    protected int noCoverageZoom = 20;

    public SimpleEmptyTileHandler() {
        this.noCoverageAtts.setLinePaint(OMColor.clear);
    }

    public BufferedImage getImageForEmptyTile(String imagePath, int x, int y, int zoomLevel, MapTileCoordinateTransform mtcTransform, Projection proj) {
        OMRect rect = new OMRect(0, 0, 256, 256);
        if (zoomLevel < this.noCoverageZoom) {
            this.backgroundAtts.setTo(rect);
        } else {
            if (this.noCoverageAtts == null) {
                return null;
            }
            this.noCoverageAtts.setTo(rect);
        }
        rect.generate(proj);
        BufferedImage bi = new BufferedImage(256, 256, 2);
        Graphics g = bi.getGraphics();
        rect.render(g);
        g.dispose();
        return bi;
    }

    public void setPropertyPrefix(String pref) {
        this.prefix = pref;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        this.backgroundAtts.setProperties(prefix + BACKGROUND_PROPERTY, props);
        this.noCoverageAtts.setProperties(prefix + NO_COVERAGE_ZOOM_PROPERTY, props);
        this.noCoverageZoom = PropUtils.intFromProperties(props, prefix + NO_COVERAGE_ZOOM_PROPERTY, this.noCoverageZoom);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.backgroundAtts.getProperties(props);
        this.noCoverageAtts.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.backgroundAtts.getPropertyInfo(props);
        this.noCoverageAtts.getPropertyInfo(props);
        return props;
    }

    public DrawingAttributes getBackgroundAtts() {
        return this.backgroundAtts;
    }

    public void setBackgroundAtts(DrawingAttributes backgroundAtts) {
        this.backgroundAtts = backgroundAtts;
    }

    public DrawingAttributes getNoCoverageAtts() {
        return this.noCoverageAtts;
    }

    public void setNoCoverageAtts(DrawingAttributes noCoverageAtts) {
        this.noCoverageAtts = noCoverageAtts;
    }

    public int getNoCoverageZoom() {
        return this.noCoverageZoom;
    }

    public void setNoCoverageZoom(int noCoverageZoom) {
        this.noCoverageZoom = noCoverageZoom;
    }
}

