/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.coordFormatter;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.coordFormatter.CoordInfoFormatter;
import java.text.DecimalFormat;
import java.util.Properties;

public class BasicCoordInfoFormatter
extends OMComponent
implements CoordInfoFormatter {
    protected String prettyName = "Default";
    public static final String DEGREE_SIGN = "\u00b0";
    protected DecimalFormat df = new DecimalFormat("0.###");

    public String createCoordinateInformationLine(int x, int y, LatLonPoint llp, Object source) {
        if (llp != null) {
            return "Lat, Lon (" + this.df.format(llp.getLatitude()) + ", " + this.df.format(llp.getLongitude()) + ") - x, y (" + x + "," + y + ")";
        }
        return "x, y (" + x + "," + y + ")";
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.prettyName = props.getProperty(prefix + "prettyName", this.prettyName);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "prettyName", this.prettyName);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, this.getClass(), "prettyName", "Name", "Name for formatter", null);
        return props;
    }
}

