/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.cacheHandler;

import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.util.Arrays;
import java.util.ListIterator;

public abstract class CacheHandler {
    protected CacheObject[] objs;
    protected int logicalClock;
    public static int DEFAULT_MAX_CACHE_SIZE = 25;

    public CacheHandler() {
        this.initCache(DEFAULT_MAX_CACHE_SIZE);
    }

    public CacheHandler(int max_size) {
        this.initCache(max_size);
    }

    private void initCache(int max_size) {
        if (this.objs != null && this.objs.length == max_size) {
            this.clear();
        } else {
            this.objs = new CacheObject[max_size];
        }
        this.logicalClock = 0;
    }

    public void clear() {
        if (this.objs != null) {
            for (int i = 0; i < this.objs.length; ++i) {
                this.objs[i] = null;
            }
        }
    }

    public void resetCache() {
        this.initCache(this.objs.length);
    }

    public void resetCache(int max_size) {
        this.initCache(max_size);
    }

    public int getCacheSize() {
        return this.objs.length;
    }

    public Object get(Object key) {
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            return ret.obj;
        }
        ret = this.load(key);
        if (ret == null) {
            return null;
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    public abstract CacheObject load(Object var1);

    public CacheObject searchCache(Object key) {
        CacheObject co;
        for (int i = 0; i < this.objs.length && (co = this.objs[i]) != null; ++i) {
            if (!co.id.equals(key)) continue;
            return co;
        }
        return null;
    }

    protected void replaceLeastUsed(CacheObject newObj) {
        int i;
        for (i = this.objs.length - 1; i >= 0; --i) {
            if (this.objs[i] == null) {
                if (i != 0) continue;
                this.objs[0] = newObj;
                if (Debug.debugging("cache")) {
                    Debug.output("CacheHandler: was empty - added " + newObj.id);
                }
                return;
            }
            if (i == this.objs.length - 1) break;
            this.objs[i + 1] = newObj;
            if (Debug.debugging("cache")) {
                Debug.output("CacheHandler: had room - added " + newObj.id + " to the " + i + " spot.");
            }
            return;
        }
        int minClock = this.logicalClock + 1;
        int LUIndex = -1;
        for (i = this.objs.length - 1; i >= 0; --i) {
            if (!this.objs[i].older(minClock)) continue;
            LUIndex = i;
            minClock = this.objs[i].cachedTime;
        }
        if (LUIndex != -1) {
            if (Debug.debugging("cache")) {
                Debug.output("CacheHandler: Tossing " + this.objs[LUIndex].id + " from cache to add " + newObj.id);
            }
            this.objs[LUIndex] = newObj;
            newObj.cachedTime = this.logicalClock++;
        }
    }

    public ListIterator listIterator() {
        return Arrays.asList(this.objs).listIterator();
    }
}

