/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.tools.symbology.milStd2525.CodeAffiliation;
import com.bbn.openmap.tools.symbology.milStd2525.CodeMOOTWModifier;
import com.bbn.openmap.tools.symbology.milStd2525.CodeOptions;
import com.bbn.openmap.tools.symbology.milStd2525.CodeOrderOfBattle;
import com.bbn.openmap.tools.symbology.milStd2525.CodePosition;
import com.bbn.openmap.tools.symbology.milStd2525.CodeScheme;
import com.bbn.openmap.tools.symbology.milStd2525.CodeSizeModifier;
import com.bbn.openmap.tools.symbology.milStd2525.CodeStatus;
import com.bbn.openmap.tools.symbology.milStd2525.CodeWarfightingModifier;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPartTree;
import com.bbn.openmap.util.Debug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class CodePositionTree
extends CodeScheme {
    public CodePositionTree(Properties positionProperties) {
        CodeScheme cs = new CodeScheme();
        cs.parsePositions("scheme", positionProperties);
        this.choices = cs.getPositionChoices();
        CodeAffiliation ca = new CodeAffiliation();
        ca.parsePositions("affiliation", positionProperties);
        ca.choices.add(0, ca.getNULLCodePosition());
        CodeWarfightingModifier cwm = new CodeWarfightingModifier();
        CodeSizeModifier csm = new CodeSizeModifier();
        CodeMOOTWModifier cmm = new CodeMOOTWModifier();
        cwm.parsePositions("modifiers", positionProperties);
        cwm.choices.add(0, cwm.getNULLCodePosition());
        csm.parsePositions("modifiers", positionProperties);
        csm.choices.add(0, csm.getNULLCodePosition());
        cmm.parsePositions("modifiers", positionProperties);
        cmm.choices.add(0, cmm.getNULLCodePosition());
        CodeStatus cstatus = new CodeStatus();
        cstatus.parsePositions("status", positionProperties);
        cstatus.choices.add(0, cstatus.getNULLCodePosition());
        CodeOrderOfBattle coob = new CodeOrderOfBattle();
        coob.parsePositions("oob", positionProperties);
        coob.choices.add(0, coob.getNULLCodePosition());
        LinkedList<CodePosition> basicOptions = new LinkedList<CodePosition>();
        basicOptions.add(ca);
        basicOptions.add(cstatus);
        basicOptions.add(cwm);
        basicOptions.add(csm);
        basicOptions.add(cmm);
        basicOptions.add(coob);
        this.setCodeOptions(new CodeOptions(basicOptions));
        LinkedList<CodePosition> warfightingOptions = new LinkedList<CodePosition>();
        warfightingOptions.add(ca);
        warfightingOptions.add(cstatus);
        warfightingOptions.add(cwm);
        warfightingOptions.add(coob);
        ((CodeScheme)cs.getFromChoices(1)).setCodeOptions(new CodeOptions(warfightingOptions));
        LinkedList<CodePosition> tacOptions = new LinkedList<CodePosition>();
        tacOptions.add(ca);
        tacOptions.add(cstatus);
        tacOptions.add(csm);
        ((CodeScheme)cs.getFromChoices(2)).setCodeOptions(new CodeOptions(tacOptions));
        LinkedList<CodePosition> intelOptions = new LinkedList<CodePosition>();
        intelOptions.add(ca);
        intelOptions.add(cstatus);
        intelOptions.add(coob);
        ((CodeScheme)cs.getFromChoices(4)).setCodeOptions(new CodeOptions(intelOptions));
        LinkedList<CodePosition> mootwOptions = new LinkedList<CodePosition>();
        mootwOptions.add(ca);
        mootwOptions.add(cstatus);
        mootwOptions.add(cmm);
        mootwOptions.add(coob);
        ((CodeScheme)cs.getFromChoices(5)).setCodeOptions(new CodeOptions(mootwOptions));
    }

    public SymbolPart parseHierarchy(String name, Properties hierarchyProperties) {
        List positions = this.getPositionChoices();
        SymbolPartTree head = new SymbolPartTree(name);
        LinkedList<SymbolPart> subs = new LinkedList<SymbolPart>();
        head.setSubs(subs);
        Iterator it = positions.iterator();
        while (it.hasNext()) {
            SymbolPart sp;
            CodeScheme cs = (CodeScheme)it.next();
            if (Debug.debugging("symbolpart")) {
                Debug.output("CodePositionTree: loading " + cs.getPrettyName());
            }
            if ((sp = cs.parseHierarchy(hierarchyProperties, head)) == null) continue;
            subs.add(sp);
        }
        return head;
    }
}

