/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class MessageHeader {
    private String[] keys;
    private String[] values;
    private int nkeys;

    public MessageHeader() {
        this.grow();
    }

    public MessageHeader(InputStream is) throws IOException {
        this.parseHeader(is);
    }

    public String findValue(String k) {
        if (k == null) {
            int i = this.nkeys;
            while (--i >= 0) {
                if (this.keys[i] != null) continue;
                return this.values[i];
            }
        } else {
            int i = this.nkeys;
            while (--i >= 0) {
                if (!k.equalsIgnoreCase(this.keys[i])) continue;
                return this.values[i];
            }
        }
        return null;
    }

    public String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.values[n];
    }

    public String findNextValue(String k, String v) {
        boolean foundV = false;
        if (k == null) {
            int i = this.nkeys;
            while (--i >= 0) {
                if (this.keys[i] != null) continue;
                if (foundV) {
                    return this.values[i];
                }
                if (this.values[i] != v) continue;
                foundV = true;
            }
        } else {
            int i = this.nkeys;
            while (--i >= 0) {
                if (!k.equalsIgnoreCase(this.keys[i])) continue;
                if (foundV) {
                    return this.values[i];
                }
                if (this.values[i] != v) continue;
                foundV = true;
            }
        }
        return null;
    }

    public void print(PrintWriter p) {
        for (int i = 0; i < this.nkeys; ++i) {
            if (this.keys[i] == null) continue;
            p.print(this.keys[i] + (this.values[i] != null ? ": " + this.values[i] : "") + "\r\n");
        }
        p.print("\r\n");
        p.flush();
    }

    public void add(String k, String v) {
        this.grow();
        this.keys[this.nkeys] = k;
        this.values[this.nkeys] = v;
        ++this.nkeys;
    }

    public void prepend(String k, String v) {
        this.grow();
        for (int i = this.nkeys; i > 0; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[0] = k;
        this.values[0] = v;
        ++this.nkeys;
    }

    public void set(int i, String k, String v) {
        this.grow();
        if (i < 0) {
            return;
        }
        if (i > this.nkeys) {
            this.add(k, v);
        } else {
            this.keys[i] = k;
            this.values[i] = v;
        }
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] nk = new String[this.nkeys + 4];
            String[] nv = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, nk, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy(this.values, 0, nv, 0, this.nkeys);
            }
            this.keys = nk;
            this.values = nv;
        }
    }

    public void set(String k, String v) {
        int i = this.nkeys;
        while (--i >= 0) {
            if (!k.equalsIgnoreCase(this.keys[i])) continue;
            this.values[i] = v;
            return;
        }
        this.add(k, v);
    }

    public static String canonicalID(String id) {
        char c;
        int st;
        if (id == null) {
            return "";
        }
        int len = id.length();
        boolean substr = false;
        for (st = 0; st < len && ((c = id.charAt(st)) == '<' || c <= ' '); ++st) {
            substr = true;
        }
        while (st < len && ((c = id.charAt(len - 1)) == '>' || c <= ' ')) {
            --len;
            substr = true;
        }
        return substr ? id.substring(st, len) : id;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseHeader(InputStream is) throws IOException {
        this.nkeys = 0;
        if (is == null) {
            return;
        }
        char[] s = new char[10];
        int firstc = is.read();
        while (true) {
            String k;
            int keyend;
            int len;
            block19: {
                int c;
                boolean inKey;
                if (firstc != 10 && firstc != 13 && firstc >= 0) {
                    len = 0;
                    keyend = -1;
                    inKey = firstc > 32;
                    s[len++] = (char)firstc;
                } else {
                    return;
                }
                block7: while ((c = is.read()) >= 0) {
                    switch (c) {
                        case 58: {
                            if (inKey && len > 0) {
                                keyend = len;
                            }
                            inKey = false;
                            break;
                        }
                        case 9: {
                            c = 32;
                        }
                        case 32: {
                            inKey = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            firstc = is.read();
                            if (c == 13 && firstc == 10 && (firstc = is.read()) == 13) {
                                firstc = is.read();
                            }
                            if (firstc != 10 && firstc != 13 && firstc <= 32) continue block7;
                            break block19;
                        }
                    }
                    if (len >= s.length) {
                        char[] ns = new char[s.length * 2];
                        System.arraycopy(s, 0, ns, 0, len);
                        s = ns;
                    }
                    s[len++] = (char)c;
                }
                firstc = -1;
            }
            while (len > 0 && s[len - 1] <= ' ') {
                --len;
            }
            if (keyend <= 0) {
                k = null;
                keyend = 0;
            } else {
                k = String.copyValueOf(s, 0, keyend);
                if (keyend < len && s[keyend] == ':') {
                    ++keyend;
                }
                while (keyend < len && s[keyend] <= ' ') {
                    ++keyend;
                }
            }
            String v = keyend >= len ? new String() : String.copyValueOf(s, keyend, len - keyend);
            this.add(k, v);
        }
    }

    public String toString() {
        String result = super.toString();
        for (int i = 0; i < this.keys.length; ++i) {
            result = result + "{" + this.keys[i] + ": " + this.values[i] + "}";
        }
        return result;
    }
}

